/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge;

import com.mojang.brigadier.CommandDispatcher;
import com.pulsar.soulforge.SoulForgeClient;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.advancement.SoulForgeCriterions;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.block.SoulForgeBlocks;
import com.pulsar.soulforge.client.networking.OpenScreenPacket;
import com.pulsar.soulforge.client.ui.CreativeZoneScreenHandler;
import com.pulsar.soulforge.client.ui.SoulForgeScreenHandler;
import com.pulsar.soulforge.command.AntihealCommand;
import com.pulsar.soulforge.command.DisguiseCommand;
import com.pulsar.soulforge.command.GhostBlockCommand;
import com.pulsar.soulforge.command.HateCommand;
import com.pulsar.soulforge.command.MinionCommand;
import com.pulsar.soulforge.command.SoulForgeCommand;
import com.pulsar.soulforge.command.WormholeCommand;
import com.pulsar.soulforge.components.EntityInitializer;
import com.pulsar.soulforge.components.HateComponent;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.TemporaryModifierComponent;
import com.pulsar.soulforge.components.ValueComponent;
import com.pulsar.soulforge.components.WorldComponent;
import com.pulsar.soulforge.components.WorldInitializer;
import com.pulsar.soulforge.config.ConfigHelper;
import com.pulsar.soulforge.damage_type.SoulForgeDamageTypes;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.entity.SoulForgeEntities;
import com.pulsar.soulforge.event.ServerEndTick;
import com.pulsar.soulforge.event.ServerStartTick;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.networking.SoulForgeNetworking;
import com.pulsar.soulforge.particle.SoulForgeParticles;
import com.pulsar.soulforge.recipe.SoulForgeRecipes;
import com.pulsar.soulforge.registries.AbilityReloadListener;
import com.pulsar.soulforge.registries.TraitReloadListener;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import com.pulsar.soulforge.util.Constants;
import com.pulsar.soulforge.util.SoulForgeCustomTrades;
import com.pulsar.soulforge.util.TeamUtils;
import com.pulsar.soulforge.util.Utils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3917;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoulForge
implements ModInitializer {
    public static final String MOD_ID = "soulforge";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"soulforge");
    public static class_3917<SoulForgeScreenHandler> SOUL_FORGE_SCREEN_HANDLER;
    public static class_3917<CreativeZoneScreenHandler> CREATIVE_ZONE_SCREEN_HANDLER;

    public void onInitialize() {
        LOGGER.info("Loading SoulForge v2.7.6");
        SoulForgeBlocks.registerBlocks();
        SoulForgeItems.registerItems();
        SoulForgeEffects.registerEffects();
        SoulForgeSounds.registerSounds();
        SoulForgeEntities.register();
        SoulForgeCriterions.registerCriterions();
        SoulForgeDamageTypes.register();
        SoulForgeRecipes.register();
        SoulForgeAttributes.register();
        SoulForgeCustomTrades.register();
        SoulForgeParticles.serverRegister();
        TeamUtils.checkForTeams();
        SOUL_FORGE_SCREEN_HANDLER = ScreenHandlerRegistry.registerSimple((class_2960)new class_2960(MOD_ID, "soul_forge_screen"), SoulForgeScreenHandler::new);
        CREATIVE_ZONE_SCREEN_HANDLER = ScreenHandlerRegistry.registerExtended((class_2960)new class_2960(MOD_ID, "creative_zone_screen"), CreativeZoneScreenHandler::new);
        ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960(MOD_ID, "trait"), SoulForgeCommand.TraitArgumentType.class, (class_2314)class_2319.method_41999(SoulForgeCommand.TraitArgumentType::trait));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            SoulForgeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            GhostBlockCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
            WormholeCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
            AntihealCommand.register((CommandDispatcher<class_2168>)dispatcher);
            DisguiseCommand.register((CommandDispatcher<class_2168>)dispatcher);
            MinionCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
            HateCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        SoulForgeNetworking.registerPackets();
        ServerTickEvents.START_SERVER_TICK.register((Object)new ServerStartTick());
        ServerTickEvents.END_SERVER_TICK.register((Object)new ServerEndTick());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)handler.field_14140);
            if (!playerSoul.getResetData().setFirst) {
                ServerPlayNetworking.send((class_3222)handler.field_14140, (class_2960)SoulForgeNetworking.OPEN_SCREEN, (class_2540)PacketByteBufs.create().method_10804(OpenScreenPacket.ScreenType.FIRST_TRAIT.val()));
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)handler.method_32311());
            if (playerSoul != null) {
                for (AbilityBase active : playerSoul.getActiveAbilities()) {
                    if (!Utils.abilityInstanceInList(active, Constants.endsOnDisconnect)) continue;
                    active.end(handler.method_32311());
                }
            }
        });
        ConfigHelper.register();
    }

    public static void registerResourceListeners() {
        LOGGER.info("Registering resource listeners");
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)AbilityReloadListener.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)TraitReloadListener.INSTANCE);
    }

    public static SoulComponent getPlayerSoul(class_1657 player) {
        SoulComponent playerSoul = EntityInitializer.SOUL.maybeGet((Object)player).orElse(new SoulComponent(player));
        if (player.method_37908().field_9236 && player == class_310.method_1551().field_1724) {
            playerSoul = SoulForgeClient.getPlayerData();
        }
        return playerSoul;
    }

    public static WorldComponent getWorldComponent(class_1937 world) {
        return (WorldComponent)WorldInitializer.WORLD_CONFIG.get((Object)world);
    }

    public static ValueComponent getValues(class_1309 living) {
        try {
            return (ValueComponent)EntityInitializer.VALUES.get((Object)living);
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    public static TemporaryModifierComponent getTemporaryModifiers(class_1309 living) {
        try {
            return (TemporaryModifierComponent)EntityInitializer.TEMPORARY_MODIFIERS.get((Object)living);
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    public static HateComponent getHate(class_1309 living) {
        try {
            return (HateComponent)EntityInitializer.HATE.get((Object)living);
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }
}

