/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability;

import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.hate.sideeffects.Insanity;
import com.pulsar.soulforge.ability.other.BadToTheBone;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;

public class Abilities {
    public static List<AbilityBase> specialAbilities = List.of(new BadToTheBone());
    public static List<AbilityBase> hateAbilities = new ArrayList<Insanity>(List.of(new Insanity()));

    public static AbilityBase get(class_2960 id) {
        for (TraitBase trait : Traits.trueAll()) {
            if (trait != Traits.spite) {
                for (AbilityBase ability : List.copyOf(trait.getAbilities())) {
                    if (!ability.getID().equals((Object)id)) continue;
                    return ability.getInstance();
                }
            }
            if (!Constants.pureAbilities.containsKey(trait) || !Constants.pureAbilities.get(trait).getID().equals((Object)id)) continue;
            return Constants.pureAbilities.get(trait).getInstance();
        }
        for (AbilityBase ability : Constants.dualAbilities) {
            if (!ability.getID().equals((Object)id)) continue;
            return ability.getInstance();
        }
        for (AbilityBase ability : hateAbilities) {
            if (!ability.getID().equals((Object)id)) continue;
            return ability.getInstance();
        }
        return null;
    }

    public static AbilityBase get(String name) {
        if (name.contains(":")) {
            return Abilities.get(class_2960.method_12829((String)name));
        }
        for (TraitBase trait : Traits.trueAll()) {
            if (trait != Traits.spite) {
                for (AbilityBase ability : List.copyOf(trait.getAbilities())) {
                    if (!Objects.equals(ability.getName(), name)) continue;
                    return ability.getInstance();
                }
            }
            if (!Constants.pureAbilities.containsKey(trait) || !Objects.equals(Constants.pureAbilities.get(trait).getName(), name)) continue;
            return Constants.pureAbilities.get(trait).getInstance();
        }
        for (AbilityBase ability : Constants.dualAbilities) {
            if (!Objects.equals(ability.getName(), name)) continue;
            return ability.getInstance();
        }
        for (AbilityBase ability : hateAbilities) {
            if (!Objects.equals(ability.getName(), name)) continue;
            return ability.getInstance();
        }
        for (AbilityBase ability : specialAbilities) {
            if (!Objects.equals(ability.getName(), name)) continue;
            return ability.getInstance();
        }
        return null;
    }

    public static List<String> getAllAbilityNames() {
        ArrayList<String> abilityNames = new ArrayList<String>();
        for (TraitBase trait : Traits.trueAll()) {
            if (trait != Traits.spite) {
                for (AbilityBase ability : List.copyOf(trait.getAbilities())) {
                    if (abilityNames.contains(ability.getName())) continue;
                    abilityNames.add(ability.getName());
                }
            }
            if (!Constants.pureAbilities.containsKey(trait) || abilityNames.contains(Constants.pureAbilities.get(trait).getName())) continue;
            abilityNames.add(Constants.pureAbilities.get(trait).getName());
        }
        for (AbilityBase ability : Constants.dualAbilities) {
            if (abilityNames.contains(ability.getName())) continue;
            abilityNames.add(ability.getName());
        }
        for (AbilityBase ability : hateAbilities) {
            if (abilityNames.contains(ability.getName())) continue;
            abilityNames.add(ability.getName());
        }
        return abilityNames;
    }

    public static int totalAbilityCount() {
        return Abilities.getAllAbilityNames().size();
    }
}

