/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability;

import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.util.CooldownDisplayEntry;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public abstract class AbilityBase {
    private boolean isActive = false;
    private int cooldown = 0;

    public String getName() {
        return String.join((CharSequence)" ", this.getClass().getSimpleName().split("(?=\\p{Upper})"));
    }

    public class_2561 getLocalizedText() {
        return class_2561.method_43471((String)("ability." + this.getID().method_12832() + ".name"));
    }

    public class_2960 getID() {
        return new class_2960("soulforge", this.getName().toLowerCase().replace(" ", "_"));
    }

    public String getTooltip() {
        return class_2561.method_43471((String)("ability." + this.getID().method_12832() + ".tooltip")).getString();
    }

    public abstract int getLV();

    public abstract int getCost();

    public abstract int getCooldown();

    public abstract AbilityType getType();

    public abstract AbilityBase getInstance();

    public void cooldownTick() {
        --this.cooldown;
    }

    public class_2487 saveNbt(class_2487 nbt) {
        nbt.method_10582("id", this.getID().method_12832());
        nbt.method_10582("name", this.getName());
        nbt.method_10556("active", this.isActive);
        nbt.method_10569("cooldown", this.cooldown);
        return nbt;
    }

    public void readNbt(class_2487 nbt) {
        this.isActive = nbt.method_10577("active");
        this.cooldown = nbt.method_10550("cooldown");
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean getActive() {
        return this.isActive;
    }

    public void setCooldownVal(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getCooldownVal() {
        return this.cooldown;
    }

    public boolean onCooldown() {
        return this.cooldown > 0;
    }

    public boolean cast(class_3222 player) {
        this.setActive(true);
        return true;
    }

    public boolean tick(class_3222 player) {
        return true;
    }

    public boolean end(class_3222 player) {
        this.setActive(false);
        return true;
    }

    public void displayTick(class_1657 player) {
    }

    public Optional<CooldownDisplayEntry> getCooldownEntry() {
        return Optional.empty();
    }
}

