/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.ability.DataDrivenAbility;
import com.pulsar.soulforge.ability.DataDrivenAuraAbility;
import com.pulsar.soulforge.ability.DataDrivenToggleableAbility;
import com.pulsar.soulforge.ability.DataDrivenWeaponAbility;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class DataDrivenAbilitySerializer {
    public static AbilityBase fromJson(JsonObject json) throws JsonParseException {
        String name = json.get("name").getAsString();
        class_2960 id = class_2960.method_12829((String)json.get("id").getAsString());
        int unlockLv = json.get("unlockLv").getAsInt();
        int cost = json.get("cost").getAsInt();
        int cooldown = json.get("cooldown").getAsInt();
        switch (json.get("type").getAsString()) {
            case "cast": {
                return new DataDrivenAbility(id, name, unlockLv, cost, cooldown, AbilityType.CAST);
            }
            case "toggle": {
                return new DataDrivenToggleableAbility(id, name, unlockLv, cost, cooldown);
            }
            case "aura": {
                JsonArray modifierArray = json.get("modifiers").getAsJsonArray();
                HashMap<class_1320, class_1322> modifiers = new HashMap<class_1320, class_1322>();
                for (int i = 0; i < modifierArray.size(); ++i) {
                    JsonObject modifierJson = modifierArray.get(i).getAsJsonObject();
                    class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(class_2960.method_12829((String)modifierJson.get("attribute").getAsString()));
                    UUID modifierId = UUID.fromString(modifierJson.get("uuid").getAsString());
                    String modifierName = modifierJson.get("name").getAsString();
                    double modifierValue = modifierJson.get("value").getAsDouble();
                    int modifierOperation = modifierJson.get("operation").getAsInt();
                    class_1322 modifier = new class_1322(modifierId, modifierName, modifierValue, class_1322.class_1323.method_6190((int)modifierOperation));
                    modifiers.put(attribute, modifier);
                }
                return new DataDrivenAuraAbility(id, name, unlockLv, cost, cooldown, modifiers);
            }
            case "weapon": {
                class_1792 weapon = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)json.get("item").getAsString()));
                return new DataDrivenWeaponAbility(id, name, unlockLv, cost, cooldown, weapon);
            }
        }
        return new DataDrivenAbility(id, name, unlockLv, cost, cooldown, AbilityType.CAST);
    }
}

