/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.bravery;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.ability.ToggleableAbilityBase;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.entity.BlastEntity;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import com.pulsar.soulforge.util.Utils;
import java.awt.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;

public class EnergyWave
extends ToggleableAbilityBase {
    private int chargeTimer = 0;
    private int chargeLevel = 0;
    private int lastCooldownLength = 0;
    private final class_1322 modifier = new class_1322("energy_wave", -0.7, class_1322.class_1323.field_6331);

    @Override
    public boolean cast(class_3222 player) {
        if (!this.getActive()) {
            player.method_5996(class_5134.field_23719).method_26837(this.modifier);
            this.chargeLevel = 0;
            this.chargeTimer = 0;
            super.cast(player);
        } else {
            this.setActive(false);
        }
        return true;
    }

    @Override
    public boolean tick(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        playerSoul.resetLastCastTime();
        boolean valiantHeart = playerSoul.hasCast("Valiant Heart");
        ++this.chargeTimer;
        if (this.chargeTimer % (valiantHeart ? 10 : 20) == 0) {
            if (!playerSoul.tryConsumeMagic(5.0f)) {
                if (playerSoul.getLV() >= 10 && playerSoul.getStyleRank() >= 3) {
                    playerSoul.setMagic(0.0f);
                } else {
                    this.setActive(false);
                    return true;
                }
            }
            ++this.chargeLevel;
        }
        return super.tick(player);
    }

    @Override
    public boolean end(class_3222 player) {
        class_243 end = player.method_33571().method_1019(player.method_5720().method_1021(30.0));
        class_3965 hit = player.method_37908().method_17742(new class_3959(player.method_33571(), player.method_33571().method_1019(player.method_5720().method_1021(30.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (hit != null) {
            end = hit.method_17784().method_1020(Utils.getArmPosition((class_1657)player));
        }
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        float damage = 0.4f * (float)playerSoul.getEffectiveLV();
        float size = 0.25f;
        if (playerSoul.getMagic() == 0.0f) {
            damage = 1.6f * (float)playerSoul.getEffectiveLV();
            size = 0.5f;
            playerSoul.setStyleRank(Math.max(0, playerSoul.getStyleRank() - 3));
        }
        BlastEntity blast = new BlastEntity(player.method_37908(), Utils.getArmPosition((class_1657)player), (class_1309)player, size, class_243.field_1353, end, damage, new Color(255, 128, 0));
        blast.owner = player;
        class_3218 serverWorld = (class_3218)player.method_37908();
        serverWorld.method_8649((class_1297)blast);
        serverWorld.method_43129(null, (class_1297)player, SoulForgeSounds.UT_BLASTER_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        this.lastCooldownLength = 100 + 20 * this.chargeLevel;
        Utils.clearModifiersByName((class_1309)player, class_5134.field_23719, "energy_wave");
        return super.end(player);
    }

    @Override
    public int getLV() {
        return 3;
    }

    @Override
    public int getCost() {
        return 20;
    }

    @Override
    public int getCooldown() {
        return this.lastCooldownLength;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new EnergyWave();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        super.saveNbt(nbt);
        nbt.method_10569("lastCooldownLength", this.lastCooldownLength);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        super.readNbt(nbt);
        this.lastCooldownLength = nbt.method_10550("lastCooldownLength");
    }
}

