/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.bravery;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.util.CooldownDisplayEntry;
import com.pulsar.soulforge.util.Utils;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class ValiantHeart
extends AbilityBase {
    private int timer = 0;
    private final class_1322 damageModifier = new class_1322("valiant_heart", 0.5, class_1322.class_1323.field_6331);
    private final class_1322 magicModifier = new class_1322("valiant_heart", 0.5, class_1322.class_1323.field_6328);
    private final class_1322 costCooldownModifier = new class_1322("valiant_heart", -0.25, class_1322.class_1323.field_6331);

    @Override
    public boolean cast(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        if (playerSoul.getMagic() < 100.0f) {
            return false;
        }
        if (playerSoul.getStyleRank() < 5) {
            player.method_43502((class_2561)class_2561.method_43471((String)(Math.random() < (double)0.01f ? "soulforge.style.get_real" : "soulforge.style.not_enough")), true);
            return false;
        }
        playerSoul.setMagic(0.0f);
        this.timer = 3600;
        player.method_6092(new class_1293(SoulForgeEffects.MANA_OVERLOAD, 6000, 0));
        player.method_5996(class_5134.field_23721).method_26837(this.damageModifier);
        player.method_5996(SoulForgeAttributes.MAGIC_POWER).method_26837(this.magicModifier);
        player.method_5996(SoulForgeAttributes.MAGIC_COST).method_26837(this.costCooldownModifier);
        player.method_5996(SoulForgeAttributes.MAGIC_COOLDOWN).method_26837(this.costCooldownModifier);
        return super.cast(player);
    }

    @Override
    public boolean tick(class_3222 player) {
        --this.timer;
        class_3218 serverWorld = player.method_51469();
        for (class_3222 target : serverWorld.method_18456()) {
            player.method_51469().method_14166(target, (class_2394)class_2398.field_11240, false, player.method_23317(), player.method_23318(), player.method_23321(), 5, 0.5, 1.0, 0.5, (double)0.1f);
        }
        return this.timer <= 0;
    }

    @Override
    public boolean end(class_3222 player) {
        Utils.clearModifiersByName((class_1309)player, class_5134.field_23721, "valiant_heart");
        Utils.clearModifiersByName((class_1309)player, SoulForgeAttributes.MAGIC_POWER, "valiant_heart");
        Utils.clearModifiersByName((class_1309)player, SoulForgeAttributes.MAGIC_COST, "valiant_heart");
        Utils.clearModifiersByName((class_1309)player, SoulForgeAttributes.MAGIC_COOLDOWN, "valiant_heart");
        return super.end(player);
    }

    @Override
    public int getLV() {
        return 20;
    }

    @Override
    public int getCost() {
        return 100;
    }

    @Override
    public int getCooldown() {
        return 15600;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new ValiantHeart();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        nbt.method_10569("timer", this.timer);
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        this.timer = nbt.method_10550("timer");
        super.readNbt(nbt);
    }

    @Override
    public Optional<CooldownDisplayEntry> getCooldownEntry() {
        return Optional.of(new CooldownDisplayEntry(new class_2960("soulforge", "valiant_heart"), "Valiant Heart", 0.0f, (float)this.timer / 20.0f, 1200.0f, new Color(1.0f, 0.5f, 0.0f)));
    }
}

