/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.determination;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.ToggleableAbilityBase;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.entity.DomeEntity;
import com.pulsar.soulforge.entity.DomePart;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class DeterminationDome
extends ToggleableAbilityBase {
    public float domeHealth = 200.0f;
    public DomeEntity entity;
    private class_2338 center = null;
    private final int domeRadius = 5;

    private float lengthSq(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    @Override
    public boolean cast(class_3222 player) {
        super.cast(player);
        if (this.getActive()) {
            SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
            this.domeHealth = (float)playerSoul.getEffectiveLV() * 10.0f;
            this.center = player.method_24515();
            player.method_51469().method_8396(null, this.center, SoulForgeSounds.DR_RUDEBUSTER_SWING_EVENT, class_3419.field_15248, 2.0f, 1.0f);
            this.entity = new DomeEntity(player.method_37908(), player.method_24515().method_46558(), 5, this.domeHealth, false, (class_1657)player);
            this.entity.method_33574(player.method_24515().method_46558().method_1023(0.0, 0.5, 0.0));
            player.method_5682().execute(() -> {
                double radius = 5.5;
                double radSq = radius * radius;
                double rad1Sq = (radius - 1.5) * (radius - 1.5);
                int ceilRad = class_3532.method_15384((double)radius);
                for (int x = 0; x <= ceilRad; ++x) {
                    for (int y = 0; y < ceilRad; ++y) {
                        for (int z = 0; z <= ceilRad; ++z) {
                            double distanceSq = this.lengthSq(x, y, z);
                            if (distanceSq > radSq || distanceSq < rad1Sq) continue;
                            this.placeDomeBlock(x, y, z, (class_1657)player);
                            this.placeDomeBlock(-x, y, z, (class_1657)player);
                            this.placeDomeBlock(x, -y, z, (class_1657)player);
                            this.placeDomeBlock(-x, -y, z, (class_1657)player);
                            this.placeDomeBlock(x, y, -z, (class_1657)player);
                            this.placeDomeBlock(-x, y, -z, (class_1657)player);
                            this.placeDomeBlock(x, -y, -z, (class_1657)player);
                            this.placeDomeBlock(-x, -y, -z, (class_1657)player);
                        }
                    }
                }
            });
        }
        return true;
    }

    private void placeDomeBlock(int x, int y, int z, class_1657 player) {
        class_2338 pos = new class_2338(x, y, z).method_10081((class_2382)this.center);
        class_1937 world = player.method_37908();
        if (!world.field_9236 && pos.method_46558().method_1022(this.center.method_46558()) <= 5.0) {
            DomePart part = new DomePart(this.entity, x + this.center.method_10263(), y + this.center.method_10264(), z + this.center.method_10260(), true);
            player.method_37908().method_8649((class_1297)part);
            this.entity.addPart(part);
        }
    }

    @Override
    public boolean tick(class_3222 player) {
        if (this.entity != null) {
            return super.tick(player) || !this.entity.method_5805() || this.entity.method_31481();
        }
        return super.tick(player);
    }

    @Override
    public boolean end(class_3222 player) {
        if (this.entity != null) {
            player.method_5682().execute(() -> {
                for (DomePart part : this.entity.getParts()) {
                    if (part.method_31481()) continue;
                    part.method_5650(class_1297.class_5529.field_26998);
                }
                if (!this.entity.method_31481()) {
                    this.entity.method_5650(class_1297.class_5529.field_26998);
                }
                this.entity = null;
            });
        }
        if (this.center != null) {
            player.method_37908().method_45446(this.center, class_3417.field_15081, class_3419.field_15245, 1.0f, 1.0f, true);
        }
        return super.end(player);
    }

    @Override
    public int getLV() {
        return 10;
    }

    @Override
    public int getCost() {
        return 40;
    }

    @Override
    public int getCooldown() {
        return 300;
    }

    @Override
    public AbilityBase getInstance() {
        return new DeterminationDome();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        if (nbt.method_10545("center")) {
            nbt.method_10566("center", (class_2520)class_2512.method_10692((class_2338)this.center));
        }
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        super.readNbt(nbt);
        if (this.center != null) {
            this.center = class_2512.method_10691((class_2487)nbt.method_10562("center"));
        }
    }
}

