/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.fear;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.entity.FearBombEntity;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import com.pulsar.soulforge.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class FearBombs
extends AbilityBase {
    class_243 pos = class_243.field_1353;
    class_243 offset = class_243.field_1353;
    int summonCount = 0;
    float spread = 4.0f;
    List<FearBombEntity> toSummon = new ArrayList<FearBombEntity>();
    int timer = 0;

    @Override
    public boolean cast(class_3222 player) {
        float magicCost;
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        if (!playerSoul.tryConsumeMagic(magicCost = Math.max(20.0f * (1.0f - (float)this.summonCount * 0.1f), 4.0f) * (playerSoul.isPure() ? 0.5f : 1.0f) * (float)player.method_5996(SoulForgeAttributes.MAGIC_COOLDOWN).method_6194())) {
            return false;
        }
        if (!this.getActive()) {
            class_3966 result = Utils.getFocussedEntity((class_1657)player, 20.0f);
            if (result == null) {
                result = player.method_5745(20.0, 1.0f, false);
            }
            if (result != null) {
                this.spread = 6.0f;
                this.pos = result.method_17784();
                this.offset = new class_243(0.0, 1.0, 0.0);
                this.summonCount = 0;
                this.timer = 0;
                this.toSummon = new ArrayList<FearBombEntity>();
                if (result instanceof class_3965) {
                    class_3965 blockHit = (class_3965)result;
                    this.offset = Utils.vector3fToVec3d(blockHit.method_17780().method_23955());
                }
                this.addBombs(player);
                return super.cast(player);
            }
        } else {
            this.spread = Math.min(this.spread * 1.2f, 12.0f);
            ++this.summonCount;
            this.addBombs(player);
            return false;
        }
        return false;
    }

    void addBombs(class_3222 player) {
        int i = 0;
        while ((double)i < Math.min(Math.pow(2.0, this.summonCount) * 5.0, 20.0)) {
            FearBombEntity bomb = new FearBombEntity(player.method_37908(), (class_1657)player);
            class_243 posOffset = new class_243(Math.random() * (double)this.spread * 2.0 - (double)this.spread, Math.random() * (double)this.spread - (double)(this.spread / 2.0f), Math.random() * (double)this.spread * 2.0 - (double)this.spread);
            bomb.method_33574(this.pos.method_1019(this.offset.method_1021((double)(this.spread / 2.0f))).method_1019(posOffset));
            this.toSummon.add(bomb);
            ++i;
        }
    }

    @Override
    public boolean tick(class_3222 player) {
        float ticksToNextSummon = (float)Math.pow(2.0, -(Math.floor((float)this.toSummon.size() / 5.0f) - 1.0));
        int amountToSummon = Math.max((int)(1.0f / ticksToNextSummon), 1);
        ++this.timer;
        if (ticksToNextSummon <= (float)this.timer) {
            for (int i = 0; i < amountToSummon; ++i) {
                if (this.toSummon.isEmpty()) continue;
                FearBombEntity bomb = this.toSummon.get((int)(Math.random() * (double)this.toSummon.size()));
                player.method_37908().method_8649((class_1297)bomb);
                player.method_37908().method_8396(null, bomb.method_24515(), SoulForgeSounds.MINE_SUMMON_EVENT, class_3419.field_15250, 1.0f, 1.0f);
                this.toSummon.remove((Object)bomb);
            }
            this.timer = 0;
        }
        return this.toSummon.isEmpty();
    }

    @Override
    public boolean end(class_3222 player) {
        this.summonCount = 0;
        this.spread = 4.0f;
        this.timer = 0;
        return super.end(player);
    }

    @Override
    public int getLV() {
        return 20;
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int getCooldown() {
        return 0;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new FearBombs();
    }
}

