/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.integrity;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.TemporaryModifierComponent;
import com.pulsar.soulforge.util.TeamUtils;
import com.pulsar.soulforge.util.Utils;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3966;

public class GravityAnchor
extends AbilityBase {
    private int timer = 0;
    private class_1309 target;
    float lastY = 0.0f;

    @Override
    public boolean cast(class_3222 player) {
        class_1297 class_12972;
        class_3966 result = Utils.getFocussedEntity((class_1657)player, 15.0f);
        if (result != null && (class_12972 = result.method_17782()) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            if (living instanceof class_1657) {
                class_1657 targetPlayer = (class_1657)living;
                if (!TeamUtils.canDamageEntity(player.method_5682(), (class_1657)player, (class_1309)targetPlayer)) {
                    return false;
                }
            }
            SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
            this.target = living;
            for (int i = 0; i < 10; ++i) {
                float x = class_3532.method_15374((float)((float)((double)((float)i / 5.0f) * Math.PI)));
                float z = class_3532.method_15362((float)((float)((double)((float)i / 5.0f) * Math.PI)));
                player.method_37908().method_8406((class_2394)new class_2390(class_243.method_24457((int)255).method_46409(), 1.0f), this.target.method_23317() + (double)x, this.target.method_23318(), this.target.method_23321() + (double)z, 1.0, 0.0, 0.2);
            }
            living.method_6092(new class_1293(class_1294.field_5909, 100, playerSoul.getEffectiveLV() / 8));
            TemporaryModifierComponent modifiers = SoulForge.getTemporaryModifiers(living);
            modifiers.addTemporaryModifier(SoulForgeAttributes.JUMP_MULTIPLIER, new class_1322(UUID.fromString("93caf707-f05b-4d7f-9aa2-729b48eb7a1d"), "gravity-anchor", -1.0, class_1322.class_1323.field_6331), 100.0f);
            this.timer = Math.round((float)playerSoul.getEffectiveLV() * 15.0f);
            this.lastY = (float)this.target.method_23318();
            return super.cast(player);
        }
        return false;
    }

    @Override
    public boolean tick(class_3222 player) {
        --this.timer;
        if (this.target != null) {
            this.target.method_5762(0.0, -1.0, 0.0);
            this.target.field_6037 = true;
        }
        if (this.timer % 10 == 0) {
            float yDiff = (float)((double)this.lastY - player.method_23318());
            this.lastY = (float)player.method_23318();
            SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
            playerSoul.setStyle(playerSoul.getStyle() + (int)yDiff);
        }
        return this.timer == 0;
    }

    @Override
    public boolean end(class_3222 player) {
        return super.end(player);
    }

    @Override
    public int getLV() {
        return 5;
    }

    @Override
    public int getCost() {
        return 40;
    }

    @Override
    public int getCooldown() {
        return 400;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new GravityAnchor();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        nbt.method_10569("timer", this.timer);
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        this.timer = nbt.method_10550("timer");
    }
}

