/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.integrity;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.ValueComponent;
import com.pulsar.soulforge.damage_type.SoulForgeDamageTypes;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.util.CooldownDisplayEntry;
import com.pulsar.soulforge.util.TeamUtils;
import com.pulsar.soulforge.util.Utils;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class Warpspeed
extends AbilityBase {
    private int timer = 0;
    private class_243 lastPos = class_243.field_1353;
    private int stillTimer = 0;

    @Override
    public boolean cast(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        if (playerSoul.getStyleRank() < 4) {
            player.method_43502((class_2561)class_2561.method_43471((String)(Math.random() < (double)0.01f ? "soulforge.style.get_real" : "soulforge.style.not_enough")), true);
            return false;
        }
        playerSoul.setSpokenText("AAAAAAAAAAAAAAAAAAAA", 10, 300);
        this.timer = 300;
        player.method_5996(class_5134.field_23719).method_26837(new class_1322(UUID.fromString("627e27ce-5e02-11ef-85ff-325096b39f47"), "warpspeed", 2.0, class_1322.class_1323.field_6330));
        player.method_5996(SoulForgeAttributes.AIR_SPEED_BECAUSE_MOJANG_SUCKS).method_26837(new class_1322(UUID.fromString("627e27ce-5e02-11ef-85ff-325096b39f47"), "warpspeed", 2.0, class_1322.class_1323.field_6330));
        player.method_5996(SoulForgeAttributes.STEP_HEIGHT).method_26837(new class_1322(UUID.fromString("627e27ce-5e02-11ef-85ff-325096b39f47"), "warpspeed", 3.0, class_1322.class_1323.field_6328));
        player.method_6092(new class_1293(SoulForgeEffects.MANA_OVERLOAD, 1200, 0));
        ValueComponent values = SoulForge.getValues((class_1309)player);
        values.setBool("forcedRunning", true);
        return super.cast(player);
    }

    @Override
    public boolean tick(class_3222 player) {
        for (class_1297 entity : player.method_5770().method_8335((class_1297)player, new class_238(player.method_19538().method_1023(1.0, 1.0, 1.0), player.method_19538().method_1031(1.0, 1.0, 1.0)))) {
            if (entity instanceof class_1657) {
                class_1657 targetPlayer = (class_1657)entity;
                if (!TeamUtils.canDamageEntity(player.method_5682(), (class_1657)player, (class_1309)targetPlayer)) {
                    return false;
                }
            }
            entity.method_5643(SoulForgeDamageTypes.of(player.method_37908(), SoulForgeDamageTypes.WARPSPEED_DAMAGE_TYPE), player.method_6029() * 8.0f);
            entity.method_18800(player.method_5720().field_1352 * 5.0, 1.5, player.method_5720().field_1350 * 5.0);
            entity.field_6037 = true;
        }
        ValueComponent values = SoulForge.getValues((class_1309)player);
        values.setBool("forcedRunning", true);
        --this.timer;
        if (this.lastPos.method_1022(player.method_19538()) < (double)0.001f) {
            ++this.stillTimer;
            if (this.stillTimer > 4) {
                this.timer = 0;
            }
        } else {
            this.stillTimer = 0;
        }
        this.lastPos = player.method_19538();
        return this.timer <= 0;
    }

    @Override
    public boolean end(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        playerSoul.setSpokenText("");
        ValueComponent values = SoulForge.getValues((class_1309)player);
        values.removeBool("forcedRunning");
        Utils.clearModifiersByName((class_1309)player, class_5134.field_23719, "warpspeed");
        Utils.clearModifiersByName((class_1309)player, SoulForgeAttributes.AIR_SPEED_BECAUSE_MOJANG_SUCKS, "warpspeed");
        Utils.clearModifiersByName((class_1309)player, SoulForgeAttributes.STEP_HEIGHT, "warpspeed");
        return super.end(player);
    }

    @Override
    public int getLV() {
        return 20;
    }

    @Override
    public int getCost() {
        return 100;
    }

    @Override
    public int getCooldown() {
        return 6000;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new Warpspeed();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        nbt.method_10569("timer", this.timer);
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        this.timer = nbt.method_10550("timer");
        super.readNbt(nbt);
    }

    @Override
    public Optional<CooldownDisplayEntry> getCooldownEntry() {
        return Optional.of(new CooldownDisplayEntry(new class_2960("soulforge", "warpspeed"), "Warpspeed", 0.0f, (float)this.timer / 20.0f, 15.0f, new Color(0.0f, 0.0f, 1.0f)));
    }
}

