/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.justice;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.entity.OrbitalStrikeEntity;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import com.pulsar.soulforge.util.CooldownDisplayEntry;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class OrbitalStrike
extends AbilityBase {
    public OrbitalStrikeEntity entity;
    public int timer = 0;

    @Override
    public boolean cast(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        if (playerSoul.getStyleRank() < 4) {
            player.method_43502((class_2561)class_2561.method_43471((String)(Math.random() < (double)0.01f ? "soulforge.style.get_real" : "soulforge.style.not_enough")), true);
            return false;
        }
        class_243 start = player.method_33571();
        class_243 end = start.method_1031(player.method_5720().field_1352 * 50.0, player.method_5720().field_1351 * 50.0, player.method_5720().field_1350 * 50.0);
        class_3965 blockHit = player.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        if (blockHit.method_17777().method_19769((class_2374)player.method_19538(), 50.0)) {
            this.entity = new OrbitalStrikeEntity(player.method_37908(), blockHit.method_17784(), (class_1657)player);
            this.entity.owner = player;
            class_3218 serverWorld = (class_3218)player.method_37908();
            serverWorld.method_8649((class_1297)this.entity);
            player.method_37908().method_43129(null, (class_1297)player, SoulForgeSounds.DR_REVIVAL_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            this.timer = 300;
            player.method_6092(new class_1293(SoulForgeEffects.MANA_OVERLOAD, 1800, 1));
            return super.cast(player);
        }
        return false;
    }

    @Override
    public boolean tick(class_3222 player) {
        if (this.entity != null) {
            class_243 start = player.method_33571();
            class_243 end = start.method_1031(player.method_5720().field_1352 * 50.0, player.method_5720().field_1351 * 50.0, player.method_5720().field_1350 * 50.0);
            class_3965 blockHit = player.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
            class_243 direction = blockHit.method_17784().method_38499(class_2350.class_2351.field_11052, 0.0).method_1020(this.entity.method_19538().method_38499(class_2350.class_2351.field_11052, 0.0));
            direction = direction.method_1029().method_1021(Math.min((double)0.4f, direction.method_1033()));
            this.entity.setPos(this.entity.method_19538().method_1019(direction));
        }
        --this.timer;
        return this.timer <= 0;
    }

    @Override
    public boolean end(class_3222 player) {
        return super.end(player);
    }

    @Override
    public int getLV() {
        return 20;
    }

    @Override
    public int getCost() {
        return 50;
    }

    @Override
    public int getCooldown() {
        return 6000;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new OrbitalStrike();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        nbt.method_10569("timer", this.timer);
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        this.timer = nbt.method_10550("timer");
        super.readNbt(nbt);
    }

    @Override
    public Optional<CooldownDisplayEntry> getCooldownEntry() {
        return Optional.of(new CooldownDisplayEntry(new class_2960("soulforge", "orbital_strike"), "Orbital Strike", 0.0f, (float)this.timer / 20.0f, 15.0f, new Color(1.0f, 1.0f, 0.0f)));
    }
}

