/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.kindness;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.ToggleableAbilityBase;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.entity.DomeEntity;
import com.pulsar.soulforge.entity.DomePart;
import com.pulsar.soulforge.entity.ShieldShardEntity;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import com.pulsar.soulforge.trait.Traits;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.joml.Vector3f;

public class KindnessDome
extends ToggleableAbilityBase {
    public DomeEntity entity;
    private class_2338 center = null;
    private int domeRadius = 4;

    private float lengthSq(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    @Override
    public boolean cast(class_3222 player) {
        class_3965 hitResult;
        super.cast(player);
        if (this.getActive() && (hitResult = player.method_37908().method_17742(new class_3959(player.method_33571(), player.method_33571().method_1019(player.method_5720().method_1021(40.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player))) != null) {
            SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
            this.center = hitResult.method_17777().method_10093(hitResult.method_17780());
            this.domeRadius = Math.min(class_3532.method_15375((float)((float)playerSoul.getEffectiveLV() / 10.0f)) + 4, 10);
            player.method_51469().method_8396(null, this.center, SoulForgeSounds.DR_RUDEBUSTER_SWING_EVENT, class_3419.field_15248, 2.0f, 1.0f);
            this.entity = new DomeEntity(player.method_37908(), this.center.method_46558().method_1023(0.5, 0.5, 0.5), this.domeRadius, playerSoul.getEffectiveLV() * 10, false, (class_1657)player, playerSoul.hasTrait(Traits.perseverance) && playerSoul.hasTrait(Traits.kindness));
            this.entity.method_33574(this.center.method_46558().method_1023(0.5, 0.5, 0.5));
            player.method_37908().method_8649((class_1297)this.entity);
            player.method_5682().execute(() -> {
                double radius = (double)this.domeRadius + 0.5;
                double radSq = radius * radius;
                double rad1Sq = (radius - 1.5) * (radius - 1.5);
                int ceilRad = class_3532.method_15384((double)radius);
                for (int x = 0; x <= ceilRad; ++x) {
                    for (int y = 0; y < ceilRad; ++y) {
                        for (int z = 0; z <= ceilRad; ++z) {
                            double distanceSq = this.lengthSq(x, y, z);
                            if (distanceSq > radSq || distanceSq < rad1Sq) continue;
                            this.placeDomeBlock(x, y, z, (class_1657)player);
                            this.placeDomeBlock(-x, y, z, (class_1657)player);
                            this.placeDomeBlock(x, -y, z, (class_1657)player);
                            this.placeDomeBlock(-x, -y, z, (class_1657)player);
                            this.placeDomeBlock(x, y, -z, (class_1657)player);
                            this.placeDomeBlock(-x, y, -z, (class_1657)player);
                            this.placeDomeBlock(x, -y, -z, (class_1657)player);
                            this.placeDomeBlock(-x, -y, -z, (class_1657)player);
                        }
                    }
                }
            });
        }
        return true;
    }

    private void placeDomeBlock(int x, int y, int z, class_1657 player) {
        class_2338 pos = new class_2338(x, y, z).method_10081((class_2382)this.center);
        class_1937 world = player.method_37908();
        if (!world.field_9236 && pos.method_46558().method_1022(this.center.method_46558()) <= (double)this.domeRadius) {
            DomePart part = new DomePart(this.entity, x + this.center.method_10263(), y + this.center.method_10264(), z + this.center.method_10260());
            player.method_37908().method_8649((class_1297)part);
            this.entity.addPart(part);
        }
    }

    @Override
    public boolean tick(class_3222 player) {
        if (this.entity != null) {
            return super.tick(player) || !this.entity.method_5805() || this.entity.method_31481();
        }
        return super.tick(player);
    }

    @Override
    public boolean end(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        if (this.entity != null) {
            player.method_5682().execute(() -> {
                for (DomePart part : this.entity.getParts()) {
                    if (part.method_31481()) continue;
                    part.method_5650(class_1297.class_5529.field_26998);
                }
                if (!this.entity.method_31481()) {
                    this.entity.method_5650(class_1297.class_5529.field_26998);
                }
                this.entity = null;
            });
        }
        if (this.center != null) {
            if (playerSoul.hasTrait(Traits.kindness) && playerSoul.hasTrait(Traits.integrity)) {
                for (int i = 0; i < 15; ++i) {
                    class_243 velocity = new class_243(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).method_1029().method_1021(2.0);
                    ShieldShardEntity shard = new ShieldShardEntity((class_1309)player, this.center.method_46558(), velocity);
                    shard.method_33574(this.center.method_46558());
                    shard.method_18799(velocity);
                    player.method_37908().method_8649((class_1297)shard);
                }
            }
            player.method_51469().method_8396(null, this.center, class_3417.field_15081, class_3419.field_15245, 2.0f, 1.0f);
        }
        return super.end(player);
    }

    @Override
    public void displayTick(class_1657 player) {
        class_3965 hitResult = player.method_37908().method_17742(new class_3959(player.method_33571(), player.method_33571().method_1019(player.method_5720().method_1021(40.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        if (hitResult != null) {
            SoulComponent playerSoul = SoulForge.getPlayerSoul(player);
            float domeRadius = class_3532.method_15375((float)((float)playerSoul.getEffectiveLV() / 10.0f)) + 4;
            class_243 centerPos = hitResult.method_17784();
            float phiStep = 0.19634955f;
            float thetaStep = 0.3926991f;
            for (int i = 0; i < 16; ++i) {
                float phi = (float)i * phiStep;
                for (int j = 0; j < 16; ++j) {
                    float theta = (float)j * thetaStep;
                    float x = (float)(Math.sin(phi) * Math.cos(theta));
                    float y = (float)Math.cos(phi);
                    float z = (float)(Math.sin(phi) * Math.sin(theta));
                    Vector3f particlePos = new Vector3f(x, y, z).normalize().mul(domeRadius);
                    player.method_37908().method_8406((class_2394)new class_2390(class_243.method_24457((int)65280).method_46409(), 1.0f), (double)particlePos.x + centerPos.field_1352, (double)particlePos.y + centerPos.field_1351, (double)particlePos.z + centerPos.field_1350, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public int getLV() {
        return 5;
    }

    @Override
    public int getCost() {
        return 40;
    }

    @Override
    public int getCooldown() {
        return 300;
    }

    @Override
    public AbilityBase getInstance() {
        return new KindnessDome();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        if (nbt.method_10545("center")) {
            nbt.method_10566("center", (class_2520)class_2512.method_10692((class_2338)this.center));
        }
        nbt.method_10548("domeRadius", (float)this.domeRadius);
        nbt.method_10582("id", this.getID().method_12832());
        nbt.method_10582("name", this.getName());
        nbt.method_10569("lastCastTime", this.getCooldownVal());
        super.saveNbt(nbt);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        super.readNbt(nbt);
        if (this.center != null) {
            this.center = class_2512.method_10691((class_2487)nbt.method_10562("center"));
        }
        this.domeRadius = nbt.method_10550("domeRadius");
    }
}

