/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.patience;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.ToggleableAbilityBase;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.TemporaryModifierComponent;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.Utils;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class BlindingSnowstorm
extends ToggleableAbilityBase {
    public class_1309 frostMark;
    public UUID frostMarkUUID;
    public class_243 location;
    public float size;
    int timer = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cast(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        if (this.getActive()) return super.cast(player);
        if (playerSoul.hasTrait(Traits.patience) && playerSoul.hasTrait(Traits.perseverance)) {
            class_1297 class_12972;
            class_3966 hit = Utils.getFocussedEntity((class_1657)player, 10.0f);
            if (hit == null || !((class_12972 = hit.method_17782()) instanceof class_1309)) return false;
            class_1309 living = (class_1309)class_12972;
            this.size = 60.0f;
            this.frostMark = living;
            this.frostMarkUUID = living.method_5667();
            this.location = living.method_19538();
            return super.cast(player);
        } else {
            class_3965 hit = player.method_37908().method_17742(new class_3959(player.method_33571(), player.method_33571().method_1019(player.method_5720().method_1021(50.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1345, (class_1297)player));
            if (hit == null) return false;
            this.size = 60.0f;
            this.location = hit.method_17777().method_46558();
        }
        return super.cast(player);
    }

    @Override
    public boolean tick(class_3222 player) {
        if (this.location == null && this.frostMark == null) {
            this.setActive(false);
            return true;
        }
        if (this.frostMarkUUID != null) {
            this.frostMark = (class_1309)player.method_37908().method_31592().method_31808(this.frostMarkUUID);
        }
        if (this.frostMark != null) {
            if (this.frostMark.method_29504()) {
                this.setActive(false);
                this.frostMark = null;
                this.frostMarkUUID = null;
                this.location = null;
                return false;
            }
            this.location = this.frostMark.method_19538();
            SoulForge.getValues(this.frostMark).setTimer("FrostMarked", 3);
        }
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        float styleChange = 0.0f;
        for (class_1297 entity : player.method_5770().method_8335(null, class_238.method_30048((class_243)this.location, (double)(this.size * 2.0f), (double)(this.size * 2.0f), (double)(this.size * 2.0f)))) {
            class_1309 target;
            if (!(entity instanceof class_1309) || !((target = (class_1309)entity).method_5707(this.location) <= (double)(this.size * this.size))) continue;
            target.method_6092(new class_1293(SoulForgeEffects.SNOWED_VISION, 5, 0));
            SoulForge.getValues(target).setUUID("SnowedBy", player.method_5667());
            TemporaryModifierComponent modifiers = SoulForge.getTemporaryModifiers(target);
            float level = 1.0f / Math.min(1.0f + 0.015f * (float)playerSoul.getEffectiveLV(), 1.6f) - 1.0f;
            modifiers.addTemporaryModifier(SoulForgeAttributes.EFFECT_DURATION_MULTIPLIER, new class_1322(UUID.fromString("2ab10d5f-e29a-468e-b77b-c8faba1b16c7"), "snowstorm", (double)level, class_1322.class_1323.field_6331), 2.0f);
            if (target == player) continue;
            styleChange += 1.0f + (float)Utils.getTotalDebuffLevel(target) / 10.0f;
        }
        if (this.timer % 20 == 0) {
            playerSoul.setStyle(playerSoul.getStyle() + (int)styleChange);
        }
        this.timer = (this.timer + 1) % 20;
        class_3218 serverWorld = player.method_5682().method_3847(player.method_37908().method_27983());
        float phiStep = 0.09817477f;
        float thetaStep = 0.09817477f;
        for (int i = 0; i < 64; ++i) {
            float phi = (float)i * phiStep;
            for (int j = 2; j < 62; ++j) {
                if (!(Math.random() <= 0.25)) continue;
                float theta = (float)j * thetaStep;
                float x = (float)(Math.sin(phi) * Math.cos(theta) * (double)(this.size - 0.5f) + this.location.method_10216());
                float y = (float)(Math.cos(phi) * (double)(this.size - 0.5f) + this.location.method_10214());
                float z = (float)(Math.sin(phi) * Math.sin(theta) * (double)(this.size - 0.5f) + this.location.method_10215());
                serverWorld.method_14199((class_2394)class_2398.field_28013, (double)x, (double)y, (double)z, 1, 0.5, 0.5, 0.5, 0.0);
            }
        }
        if (player.method_6059(SoulForgeEffects.MANA_OVERLOAD)) {
            this.setActive(false);
        }
        return super.tick(player);
    }

    @Override
    public int getLV() {
        return 12;
    }

    @Override
    public int getCost() {
        return 40;
    }

    @Override
    public int getCooldown() {
        return 400;
    }

    @Override
    public AbilityBase getInstance() {
        return new BlindingSnowstorm();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        if (this.location != null) {
            nbt.method_10566("location", (class_2520)Utils.vectorToNbt(this.location));
        }
        if (this.frostMark != null && this.frostMarkUUID != null) {
            nbt.method_25927("frostMark", this.frostMarkUUID);
        }
        nbt.method_10548("size", this.size);
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        if (nbt.method_10545("location")) {
            this.location = Utils.nbtToVector(nbt.method_10554("location", 6));
        }
        if (nbt.method_10545("frostMark")) {
            this.frostMarkUUID = nbt.method_25926("frostMark");
        }
        this.size = nbt.method_10583("size");
        super.readNbt(nbt);
    }
}

