/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.patience;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.util.CooldownDisplayEntry;
import com.pulsar.soulforge.util.TeamUtils;
import com.pulsar.soulforge.util.Utils;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class Snowglobe
extends AbilityBase {
    public int timer = 0;

    @Override
    public boolean cast(class_3222 player) {
        super.cast(player);
        if (this.getActive()) {
            SoulForge.getValues((class_1309)player).setBool("Immobilized", true);
            this.timer = 200;
            Utils.addTemporaryAttribute((class_1309)player, SoulForgeAttributes.DAMAGE_REDUCTION, new class_1322(UUID.fromString("dcb6e304-2e3f-44e2-b2dd-81dd409fdaae"), "snowglobe", -0.8, class_1322.class_1323.field_6331), 200);
        }
        return this.getActive();
    }

    @Override
    public boolean tick(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        --this.timer;
        for (class_1657 nearby : player.method_37908().method_8390(class_1657.class, class_238.method_30048((class_243)player.method_19538(), (double)10.0, (double)10.0, (double)10.0), entity -> entity != player && TeamUtils.canHealEntity(player.method_5682(), (class_1657)player, (class_1309)entity) && entity.method_5739((class_1297)player) <= 5.0f)) {
            Utils.addTemporaryAttribute((class_1309)nearby, SoulForgeAttributes.MAGIC_POWER, new class_1322(UUID.fromString("e8afbcd4-462a-42b0-8f9f-d7dae0e71dc7"), "snowglobe_boost", (double)((float)playerSoul.getEffectiveLV() * 0.025f), class_1322.class_1323.field_6328), 2);
        }
        return super.tick(player) && this.timer <= 0;
    }

    @Override
    public boolean end(class_3222 player) {
        SoulForge.getValues((class_1309)player).removeBool("Immobilized");
        return super.cast(player);
    }

    @Override
    public int getLV() {
        return 15;
    }

    @Override
    public int getCost() {
        return 60;
    }

    @Override
    public int getCooldown() {
        return 1200;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new Snowglobe();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        nbt.method_10569("timer", this.timer);
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        this.timer = nbt.method_10550("timer");
        super.readNbt(nbt);
    }

    @Override
    public Optional<CooldownDisplayEntry> getCooldownEntry() {
        return Optional.of(new CooldownDisplayEntry(new class_2960("soulforge", "snowglobe"), "Snowglobe", 0.0f, (float)this.timer / 20.0f, 10.0f, new Color(0.0f, 1.0f, 1.0f)));
    }
}

