/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.perseverance;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.ability.perseverance.Furioso;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.damage_type.SoulForgeDamageTypes;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.networking.SoulForgeNetworking;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import com.pulsar.soulforge.util.TeamUtils;
import com.pulsar.soulforge.util.Utils;
import java.util.HashSet;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class ColossalClaymore
extends AbilityBase {
    int timer = 0;
    public boolean greaterSlash = false;

    @Override
    public boolean cast(class_3222 player) {
        this.greaterSlash = false;
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        if (player.method_6047().method_31574(SoulForgeItems.COLOSSAL_CLAYMORE)) {
            if (playerSoul.getMagic() < 100.0f && !playerSoul.hasCast("Furioso")) {
                return false;
            }
            if (playerSoul.getStyleRank() < 2 && !playerSoul.hasCast("Furioso")) {
                player.method_43502((class_2561)class_2561.method_43471((String)(Math.random() < (double)0.01f ? "soulforge.style.get_real" : "soulforge.style.not_enough")), true);
                return false;
            }
            int manaOverload = playerSoul.getStyleRank() * 400;
            float damage = (float)(playerSoul.getEffectiveLV() * playerSoul.getStyleRank()) * 0.5f;
            if (!playerSoul.hasCast("Furioso")) {
                playerSoul.setMagic(0.0f);
            }
            this.greaterSlash = true;
            for (class_1309 target : Utils.getEntitiesInFrontOf((class_1657)player, 5.0f, 8.0f, 2.0f, 2.0f)) {
                if (target instanceof class_1657) {
                    class_1657 targetPlayer = (class_1657)target;
                    if (!TeamUtils.canDamageEntity(player.method_5682(), (class_1657)player, (class_1309)targetPlayer)) continue;
                }
                target.method_5643(SoulForgeDamageTypes.of((class_1657)player, SoulForgeDamageTypes.ABILITY_DAMAGE_TYPE), damage);
            }
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), SoulForgeSounds.UT_BOMBSPLOSION_EVENT, class_3419.field_15250, 1.0f, 1.0f);
            class_2540 buf = PacketByteBufs.create().method_10797(player.method_5667()).method_10814("greater_slash");
            buf.writeBoolean(false);
            if (player.method_5682() != null) {
                SoulForgeNetworking.broadcast(null, player.method_5682(), SoulForgeNetworking.PERFORM_ANIMATION, buf);
            }
            if (!playerSoul.hasCast("Furioso")) {
                player.method_6092(new class_1293(SoulForgeEffects.MANA_OVERLOAD, manaOverload, 0));
            } else {
                AbilityBase abilityBase = playerSoul.getAbility("Furioso");
                if (abilityBase instanceof Furioso) {
                    Furioso furioso = (Furioso)abilityBase;
                    furioso.usedClaymore = true;
                    --furioso.weaponIndex;
                    furioso.doSwitch((class_1657)player);
                }
            }
        }
        this.timer = this.greaterSlash ? 5 : 30;
        return super.cast(player);
    }

    @Override
    public boolean tick(class_3222 player) {
        --this.timer;
        if (this.greaterSlash) {
            return this.timer <= 0;
        }
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        float g = -(player.method_36454() + 90.0f) * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        class_243 velocity = new class_243((double)(i * 2.5f), 1.0, (double)(h * 2.5f));
        for (class_1309 target : Utils.getEntitiesInFrontOf((class_1657)player, 1.0f, 5.0f, 1.0f, 1.0f)) {
            if (target instanceof class_1657) {
                class_1657 targetPlayer = (class_1657)target;
                if (!TeamUtils.canDamageEntity(player.method_5682(), (class_1657)player, (class_1309)targetPlayer)) continue;
            }
            if (target.method_5643(SoulForgeDamageTypes.of((class_1657)player, SoulForgeDamageTypes.ABILITY_DAMAGE_TYPE), (float)playerSoul.getEffectiveLV() * 0.8f)) {
                playerSoul.setStyle(playerSoul.getStyle() + (int)((float)playerSoul.getEffectiveLV() * 0.8f));
            }
            target.method_18799(velocity);
            target.field_6037 = true;
        }
        player.method_48105(player.method_51469(), player.method_23317(), player.method_23318(), player.method_23321(), new HashSet(), player.method_36454() + 25.0f, player.method_36455());
        return this.timer <= 0;
    }

    @Override
    public void displayTick(class_1657 player) {
        if (player.method_6047().method_31574(SoulForgeItems.COLOSSAL_CLAYMORE)) {
            return;
        }
        class_243 centerPos = player.method_19538();
        for (int i = 0; i < 32; ++i) {
            class_243 particlePos = new class_243(Math.sin((double)i * Math.PI / 16.0), 0.0, Math.cos((double)i * Math.PI / 16.0)).method_1021(5.0);
            player.method_37908().method_8406((class_2394)new class_2390(class_243.method_24457((int)0xFF00FF).method_46409(), 1.0f), particlePos.field_1352 + centerPos.field_1352, centerPos.field_1351, particlePos.field_1350 + centerPos.field_1350, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getLV() {
        return 12;
    }

    @Override
    public int getCost() {
        return 40;
    }

    @Override
    public int getCooldown() {
        return 400;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new ColossalClaymore();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        nbt.method_10556("greaterSlash", this.greaterSlash);
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (!Objects.equals(nbt.method_10558("id"), this.getID().method_12832())) {
            return;
        }
        this.greaterSlash = nbt.method_10577("greaterSlash");
        super.readNbt(nbt);
    }
}

