/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ability.perseverance;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.trait.Traits;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Furioso
extends AbilityBase {
    int timer = 0;
    int switchTimer = 0;
    int weaponIndex = 0;
    public boolean usedClaymore = false;

    public void doSwitch(class_1657 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul(player);
        this.switchTimer = 200;
        ArrayList<class_1792> weapons = new ArrayList<class_1792>();
        if (!playerSoul.hasTrait(Traits.justice) || playerSoul.hasTrait(Traits.spite)) {
            weapons.addAll(List.of(SoulForgeItems.PERSEVERANCE_BLADES, SoulForgeItems.PERSEVERANCE_EDGE, SoulForgeItems.PERSEVERANCE_CLAW, SoulForgeItems.PERSEVERANCE_HARPOON));
        }
        if ((playerSoul.isPure() || playerSoul.hasTrait(Traits.spite)) && !this.usedClaymore) {
            weapons.add(SoulForgeItems.COLOSSAL_CLAYMORE);
        }
        if (playerSoul.hasTrait(Traits.bravery) || playerSoul.hasTrait(Traits.spite)) {
            weapons.addAll(List.of(SoulForgeItems.BRAVERY_SPEAR, SoulForgeItems.BRAVERY_HAMMER, SoulForgeItems.BRAVERY_GAUNTLETS));
        }
        if (playerSoul.hasTrait(Traits.justice) || playerSoul.hasTrait(Traits.spite)) {
            weapons.addAll(List.of(SoulForgeItems.GUNBLADES, SoulForgeItems.MUSKET_BLADE, SoulForgeItems.GUNLANCE, SoulForgeItems.JUSTICE_HARPOON));
        }
        if (playerSoul.hasTrait(Traits.kindness) || playerSoul.hasTrait(Traits.spite)) {
            weapons.add(SoulForgeItems.KINDNESS_SHIELD);
        }
        if (playerSoul.hasTrait(Traits.patience) || playerSoul.hasTrait(Traits.spite)) {
            weapons.add(SoulForgeItems.FREEZE_RING);
        }
        if (playerSoul.hasTrait(Traits.integrity) || playerSoul.hasTrait(Traits.spite)) {
            weapons.add(SoulForgeItems.INTEGRITY_RAPIER);
        }
        this.weaponIndex = (this.weaponIndex + 1) % weapons.size();
        playerSoul.setWeapon(new class_1799((class_1935)weapons.get(this.weaponIndex)));
    }

    @Override
    public boolean cast(class_3222 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
        if (playerSoul.getStyleRank() < 5) {
            player.method_43502((class_2561)class_2561.method_43471((String)(Math.random() < (double)0.01f ? "soulforge.style.get_real" : "soulforge.style.not_enough")), true);
            return false;
        }
        this.usedClaymore = false;
        this.timer = 1800;
        this.switchTimer = 200;
        this.weaponIndex = -1;
        this.doSwitch((class_1657)player);
        return super.cast(player);
    }

    @Override
    public boolean tick(class_3222 player) {
        player.method_6092(new class_1293(class_1294.field_5910, 2, 1));
        --this.timer;
        --this.switchTimer;
        if (this.switchTimer <= 0) {
            this.doSwitch((class_1657)player);
        }
        return super.tick(player) && this.timer <= 0;
    }

    @Override
    public boolean end(class_3222 player) {
        this.timer = 0;
        this.switchTimer = 0;
        this.weaponIndex = 0;
        player.method_6092(new class_1293(SoulForgeEffects.MANA_OVERLOAD, 4800, 0));
        return super.end(player);
    }

    @Override
    public int getLV() {
        return 20;
    }

    @Override
    public int getCost() {
        return 100;
    }

    @Override
    public int getCooldown() {
        return 4800;
    }

    @Override
    public AbilityType getType() {
        return AbilityType.CAST;
    }

    @Override
    public AbilityBase getInstance() {
        return new Furioso();
    }

    @Override
    public class_2487 saveNbt(class_2487 nbt) {
        nbt.method_10569("timer", this.timer);
        nbt.method_10569("switchTimer", this.switchTimer);
        nbt.method_10569("weaponIndex", this.weaponIndex);
        return super.saveNbt(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        super.readNbt(nbt);
        this.timer = nbt.method_10550("timer");
        this.switchTimer = nbt.method_10550("switchTimer");
        this.weaponIndex = nbt.method_10550("weaponIndex");
    }
}

