/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.advancement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import net.minecraft.class_195;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;

public class PlayerSoulCriterion
extends class_4558<Conditions> {
    protected Conditions conditionsFromJson(JsonObject obj, class_5258 predicate, class_5257 predicateDeserializer) {
        boolean strong = false;
        boolean pure = false;
        int lv = 1;
        if (obj.has("strong")) {
            strong = obj.get("strong").getAsBoolean();
        }
        if (obj.has("pure")) {
            strong = pure = obj.get("pure").getAsBoolean();
        }
        if (obj.has("lv")) {
            lv = obj.get("lv").getAsInt();
        }
        if (obj.has("trait")) {
            String trait = obj.get("trait").getAsString();
            return new Conditions(trait, strong, pure, lv, this.method_794(), predicate);
        }
        if (obj.has("traits")) {
            JsonArray traits = obj.get("traits").getAsJsonArray();
            return new Conditions(traits.get(0).getAsString(), traits.get(1).getAsString(), strong, pure, lv, this.method_794(), predicate);
        }
        if (obj.has("count")) {
            int count = obj.get("count").getAsInt();
            return new Conditions(count, strong, pure, lv, this.method_794(), predicate);
        }
        return new Conditions(strong, pure, lv, this.method_794(), predicate);
    }

    public class_2960 method_794() {
        return new class_2960("soulforge", "player_soul");
    }

    public void trigger(class_3222 player, SoulComponent playerSoul) {
        this.method_22510(player, conditions -> conditions.requirementsMet(playerSoul));
    }

    public static class Conditions
    extends class_195 {
        TraitBase trait1 = null;
        TraitBase trait2 = null;
        int count = -1;
        int lv = 1;
        boolean strong = false;
        boolean pure = false;

        public Conditions(String traitName, boolean strong, boolean pure, int lv, class_2960 id, class_5258 predicate) {
            super(id, predicate);
            this.trait1 = Traits.get(traitName);
            this.strong = strong;
            this.pure = pure;
            this.lv = lv;
        }

        public Conditions(String trait1, String trait2, boolean strong, boolean pure, int lv, class_2960 id, class_5258 predicate) {
            super(id, predicate);
            this.trait1 = Traits.get(trait1);
            this.trait2 = Traits.get(trait2);
            this.strong = strong;
            this.pure = pure;
            this.lv = lv;
        }

        public Conditions(int count, boolean strong, boolean pure, int lv, class_2960 id, class_5258 predicate) {
            super(id, predicate);
            this.count = count;
            this.strong = strong;
            this.pure = pure;
            this.lv = lv;
        }

        public Conditions(boolean strong, boolean pure, int lv, class_2960 id, class_5258 predicate) {
            super(id, predicate);
            this.strong = strong;
            this.pure = pure;
            this.lv = lv;
        }

        boolean requirementsMet(SoulComponent playerSoul) {
            boolean allMatches;
            boolean bl = allMatches = this.lv <= playerSoul.getLV();
            if (this.strong) {
                boolean bl2 = allMatches = playerSoul.isStrong() || playerSoul.isPure() || playerSoul.hasTrait(Traits.determination);
            }
            if (this.pure) {
                boolean bl3 = allMatches = allMatches && (playerSoul.isPure() || playerSoul.hasTrait(Traits.determination));
            }
            if (this.trait1 != null) {
                boolean bl4 = allMatches = allMatches && playerSoul.hasTrait(this.trait1);
            }
            if (this.trait2 != null) {
                boolean bl5 = allMatches = allMatches && playerSoul.hasTrait(this.trait2);
            }
            if (this.count != -1) {
                allMatches = allMatches && playerSoul.getTraitCount() >= this.count;
            }
            return allMatches;
        }

        public JsonObject method_807(class_5267 serializer) {
            JsonObject json = super.method_807(serializer);
            if (this.trait1 != null) {
                if (this.trait2 == null) {
                    json.addProperty("trait", this.trait1.getName());
                } else {
                    JsonArray traits = new JsonArray();
                    traits.add(this.trait1.getName());
                    traits.add(this.trait2.getName());
                    json.add("traits", (JsonElement)traits);
                }
            } else if (this.count != -1) {
                json.addProperty("count", (Number)this.count);
            }
            if (this.strong) {
                json.addProperty("strong", Boolean.valueOf(true));
            }
            if (this.pure) {
                json.addProperty("pure", Boolean.valueOf(true));
            }
            if (this.lv != 1) {
                json.addProperty("lv", (Number)this.lv);
            }
            return json;
        }
    }
}

