/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ai;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ai.NeuralNetwork;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.ValueComponent;
import com.pulsar.soulforge.tag.SoulForgeTags;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.Utils;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class HATEBaseAI {
    public static NeuralNetwork network = new NeuralNetwork(new int[]{19, 24, 24, 24, 3});

    public static float calculateSurvivability(class_1309 living) {
        float value = living.method_6063() + living.method_6032() + (float)living.method_6096();
        value += (float)class_3532.method_15357((double)living.method_26825(class_5134.field_23725));
        if (living instanceof class_1657) {
            class_1657 player = (class_1657)living;
            SoulComponent playerSoul = SoulForge.getPlayerSoul(player);
            if (playerSoul.hasTrait(Traits.bravery)) {
                value *= 1.2f;
            }
            if (playerSoul.hasTrait(Traits.justice)) {
                value *= 1.2f;
            }
            if (playerSoul.hasTrait(Traits.kindness)) {
                value *= 1.5f;
            }
            if (playerSoul.hasTrait(Traits.patience)) {
                value *= 1.1f;
            }
            if (playerSoul.hasTrait(Traits.integrity)) {
                value *= 1.35f;
            }
            if (playerSoul.hasTrait(Traits.perseverance)) {
                value *= 1.5f;
            }
            if (playerSoul.hasTrait(Traits.determination)) {
                value *= 2.0f;
            }
            if (Utils.isInverted(playerSoul)) {
                value *= 1.5f;
            }
        }
        return value;
    }

    public static double[] getInputsFromEntity(class_1309 entity) {
        int nearbyEnemies = 0;
        int nearbyNeutrals = 0;
        int nearbyAllies = 0;
        class_1309 nearestEnemy = null;
        class_1309 nearestNeutral = null;
        class_1309 nearestAlly = null;
        List nearby = entity.method_37908().method_8390(class_1309.class, class_238.method_30048((class_243)entity.method_19538(), (double)30.0, (double)30.0, (double)30.0), target -> true);
        for (class_1309 living : nearby) {
            SoulComponent playerSoul;
            ValueComponent values = SoulForge.getValues(living);
            if (living instanceof class_1657) {
                class_1657 targetPlayer = (class_1657)living;
                v0 = SoulForge.getPlayerSoul(targetPlayer);
            } else {
                v0 = playerSoul = null;
            }
            if (living.method_5864().method_20210(SoulForgeTags.HATE_ALLY) || values.getBool("HatePossessed")) {
                ++nearbyAllies;
                if (nearestAlly == null) {
                    nearestAlly = living;
                    continue;
                }
                if (!(living.method_5739((class_1297)entity) < nearestAlly.method_5739((class_1297)entity))) continue;
                nearestAlly = living;
                continue;
            }
            if (playerSoul != null && Utils.isInverted(playerSoul)) {
                ++nearbyNeutrals;
                if (nearestNeutral == null) {
                    nearestNeutral = living;
                    continue;
                }
                if (!(living.method_5739((class_1297)entity) < nearestNeutral.method_5739((class_1297)entity))) continue;
                nearestNeutral = living;
                continue;
            }
            ++nearbyEnemies;
            if (nearestEnemy == null) {
                nearestEnemy = living;
                continue;
            }
            if (!(living.method_5739((class_1297)entity) < nearestEnemy.method_5739((class_1297)entity))) continue;
            nearestEnemy = living;
        }
        double magic = 0.0;
        boolean inverted = false;
        double magicGauge = 0.0;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            SoulComponent playerSoul = SoulForge.getPlayerSoul(player);
            magic = playerSoul.getMagic();
            inverted = Utils.isInverted(playerSoul);
            magicGauge = playerSoul.getMagicGauge();
        }
        double[] inputs = new double[]{entity.method_6032() / entity.method_6063(), entity.method_6096(), class_3532.method_15357((double)entity.method_26825(class_5134.field_23725)), magic, (double)inverted, magicGauge, Utils.getHate(entity), nearbyEnemies, nearbyNeutrals, nearbyAllies, nearestEnemy != null ? (double)nearestEnemy.method_5739((class_1297)entity) : 0.0, nearestEnemy != null ? (double)(nearestEnemy.method_6032() / nearestEnemy.method_6063()) : 0.0, nearestEnemy != null ? (double)HATEBaseAI.calculateSurvivability(nearestEnemy) : 0.0, nearestNeutral != null ? (double)nearestNeutral.method_5739((class_1297)entity) : 0.0, nearestNeutral != null ? (double)(nearestNeutral.method_6032() / nearestNeutral.method_6063()) : 0.0, nearestNeutral != null ? (double)HATEBaseAI.calculateSurvivability(nearestNeutral) : 0.0, nearestAlly != null ? (double)nearestAlly.method_5739((class_1297)entity) : 0.0, nearestAlly != null ? (double)(nearestAlly.method_6032() / nearestAlly.method_6063()) : 0.0, nearestAlly != null ? (double)HATEBaseAI.calculateSurvivability(nearestAlly) : 0.0};
        return inputs;
    }

    public static double[] getOutputs(class_1309 entity) {
        double[] inputs = HATEBaseAI.getInputsFromEntity(entity);
        return network.feedforward(inputs);
    }

    public static AiResult getResult(double[] outputs) {
        int highestIndex = 0;
        for (int i = 0; i < outputs.length; ++i) {
            if (!(outputs[i] > outputs[highestIndex])) continue;
            highestIndex = i;
        }
        if (highestIndex == 0) {
            return AiResult.ATTACK;
        }
        if (highestIndex == 1) {
            return AiResult.DEFEND;
        }
        if (highestIndex == 2) {
            return AiResult.ESCAPE;
        }
        return AiResult.ATTACK;
    }

    public static AiResult getResult(class_1657 player) {
        double[] outputs = HATEBaseAI.getOutputs((class_1309)player);
        int highestIndex = 0;
        for (int i = 0; i < outputs.length; ++i) {
            if (!(outputs[i] > outputs[highestIndex])) continue;
            highestIndex = i;
        }
        if (highestIndex == 0) {
            return AiResult.ATTACK;
        }
        if (highestIndex == 1) {
            return AiResult.DEFEND;
        }
        if (highestIndex == 2) {
            return AiResult.ESCAPE;
        }
        return AiResult.ATTACK;
    }

    public static void train(class_1309 entity, double[] expected) {
        double[] inputs = HATEBaseAI.getInputsFromEntity(entity);
        if (expected.length != 3) {
            return;
        }
        network.backpropagate(inputs, expected, 0.1);
    }

    public static enum AiResult {
        ATTACK,
        DEFEND,
        ESCAPE;

    }
}

