/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.ai;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ai.NeuralNetwork;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class NetworkSerializer {
    public static void writeNetworkToFile(NeuralNetwork network, String path) {
        try (FileOutputStream stream = new FileOutputStream(path);){
            int j;
            int i;
            stream.write(network.layerSizes.length);
            for (i = 0; i < network.layerSizes.length; ++i) {
                stream.write(network.layerSizes[i]);
            }
            stream.write(network.weights.length);
            for (i = 0; i < network.weights.length; ++i) {
                stream.write(network.weights[i].length);
                for (j = 0; j < network.weights[i].length; ++j) {
                    stream.write(network.weights[i][j].length);
                    for (int k = 0; k < network.weights[i][j].length; ++k) {
                        for (int l = 0; l < 8; ++l) {
                            stream.write((byte)(Double.doubleToLongBits(network.weights[i][j][k]) >> (7 - i) * 8 & 0xFFL));
                        }
                    }
                }
            }
            stream.write(network.biases.length);
            for (i = 0; i < network.biases.length; ++i) {
                stream.write(network.biases[i].length);
                for (j = 0; j < network.biases[i].length; ++j) {
                    for (int l = 0; l < 8; ++l) {
                        stream.write((byte)(Double.doubleToLongBits(network.biases[i][j]) >> (7 - i) * 8 & 0xFFL));
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            SoulForge.LOGGER.warn("Could not find file while writing network data!", (Throwable)e);
        }
        catch (IOException e) {
            SoulForge.LOGGER.warn("Invalid file located while writing network data!", (Throwable)e);
        }
    }

    public static NeuralNetwork readNetworkFromFile(String path) {
        NeuralNetwork neuralNetwork;
        FileInputStream stream = new FileInputStream(path);
        try {
            double value;
            long lngVal;
            byte[] bytes;
            int layerCount = stream.read();
            int[] layerSizes = new int[layerCount];
            for (int i = 0; i < layerCount; ++i) {
                layerSizes[i] = stream.read();
            }
            int weightSize1 = stream.read();
            double[][][] weights = new double[weightSize1][][];
            for (int i = 0; i < weightSize1; ++i) {
                int weightSize2 = stream.read();
                weights[i] = new double[weightSize2][];
                for (int j = 0; j < weightSize2; ++j) {
                    int weightSize3 = stream.read();
                    weights[i][j] = new double[weightSize3];
                    for (int k = 0; k < weightSize3; ++k) {
                        bytes = stream.readNBytes(8);
                        lngVal = 0L;
                        for (int l = 0; l < 8; ++l) {
                            lngVal += (long)bytes[l] << (7 - l) * 8;
                        }
                        weights[i][j][k] = value = Double.longBitsToDouble(lngVal);
                    }
                }
            }
            int biasesSize1 = stream.read();
            double[][] biases = new double[biasesSize1][];
            for (int i = 0; i < biasesSize1; ++i) {
                int biasesSize2 = stream.read();
                biases[i] = new double[biasesSize2];
                for (int j = 0; j < biasesSize2; ++j) {
                    bytes = stream.readNBytes(8);
                    lngVal = 0L;
                    for (int k = 0; k < 8; ++k) {
                        lngVal += (long)bytes[k] << (7 - k) * 8;
                    }
                    biases[i][j] = value = Double.longBitsToDouble(lngVal);
                }
            }
            neuralNetwork = new NeuralNetwork(layerSizes, weights, biases);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SoulForge.LOGGER.warn("Error while reading network data!", (Throwable)e);
                return null;
            }
        }
        stream.close();
        return neuralNetwork;
    }

    public static void writeTrainingData(String path, double[] inputs, double[] expected) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject trainingDataJson = new JsonObject();
        try (FileReader reader = new FileReader(path);){
            trainingDataJson = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            JsonArray inputArray = new JsonArray();
            for (double input : inputs) {
                inputArray.add((Number)input);
            }
            JsonArray expectedArray = new JsonArray();
            for (double value : expected) {
                expectedArray.add((Number)value);
            }
            JsonObject json = new JsonObject();
            json.add("inputs", (JsonElement)inputArray);
            json.add("expected", (JsonElement)expectedArray);
            trainingDataJson.getAsJsonArray("datasets").add((JsonElement)json);
        }
        catch (IOException e) {
            SoulForge.LOGGER.warn("Error while reading training data!", (Throwable)e);
        }
        try (FileWriter writer = new FileWriter(path);){
            gson.toJson((JsonElement)trainingDataJson, (Appendable)writer);
        }
        catch (IOException e) {
            SoulForge.LOGGER.warn("Error while writing training data!", (Throwable)e);
        }
    }
}

