/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.block;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.block.ImplementedInventory;
import com.pulsar.soulforge.block.SoulForgeBlocks;
import com.pulsar.soulforge.client.ui.CreativeZoneScreenHandler;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.item.SoulForgeItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class CreativeZoneBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
GeoBlockEntity,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    protected final class_3913 propertyDelegate;
    public int fuel;
    List<class_1297> inside = new ArrayList<class_1297>();
    private boolean wasActivated = false;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public CreativeZoneBlockEntity(class_2338 pos, class_2680 state) {
        super(SoulForgeBlocks.CREATIVE_ZONE_ENTITY, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                if (index == 0) {
                    return CreativeZoneBlockEntity.this.fuel;
                }
                return 0;
            }

            public void method_17391(int index, int value) {
                if (index == 0) {
                    CreativeZoneBlockEntity.this.fuel = value;
                }
            }

            public int method_17389() {
                return 1;
            }
        };
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        class_1799 stack;
        if (world.field_9236) {
            return;
        }
        if (world.method_49803(pos) != this.wasActivated) {
            if (world.method_49803(pos)) {
                SoulForge.getWorldComponent(world).addActiveCreativeZone(pos);
                this.inside = new ArrayList<class_1297>();
                for (class_1297 class_12972 : world.method_8335(null, class_238.method_30048((class_243)pos.method_46558(), (double)170.0, (double)170.0, (double)170.0))) {
                    if (!(class_12972.method_19538().method_1022(pos.method_46558()) < 80.0)) continue;
                    this.inside.add(class_12972);
                }
            } else {
                SoulForge.getWorldComponent(world).removeActiveCreativeZone(pos);
                this.inside = new ArrayList<class_1297>();
            }
        }
        this.wasActivated = world.method_49803(pos);
        if (world.method_49803(pos)) {
            if (this.fuel > 0) {
                --this.fuel;
                if (this.fuel % 20 == 0) {
                    Iterator<Object> box = new class_238(pos).method_1014(80.0).method_1012(0.0, (double)world.method_31605(), 0.0);
                    for (class_1657 player : world.method_18467(class_1657.class, box)) {
                        if (!this.inside.contains(player)) continue;
                        player.method_6092(new class_1293(SoulForgeEffects.CREATIVE_ZONE, 150, 0));
                    }
                }
            }
            for (class_1297 class_12973 : world.method_8335(null, class_238.method_30048((class_243)pos.method_46558(), (double)170.0, (double)170.0, (double)170.0))) {
                double distance = class_12973.method_19538().method_1022(pos.method_46558());
                if (!(distance < 80.0) || this.inside.contains(class_12973)) continue;
                class_12973.method_45319(class_12973.method_19538().method_1020(pos.method_46558()).method_1029().method_1021(Math.max(1.0, (distance - 80.0) / 5.0)));
                class_12973.field_6037 = true;
            }
            for (class_1297 class_12974 : this.inside) {
                double distance = class_12974.method_19538().method_1022(pos.method_46558());
                if (!(distance > 80.0)) continue;
                class_12974.method_45319(class_12974.method_19538().method_1020(pos.method_46558()).method_1029().method_1021(-Math.max(1.0, (distance - 80.0) / 5.0)));
                class_12974.field_6037 = true;
            }
        }
        if ((stack = this.method_5438(0)).method_31574(SoulForgeItems.KINDNESS_ARNICITE) || stack.method_31574(SoulForgeItems.INTEGRITY_ARNICITE)) {
            this.fuel += 1000;
            stack.method_7934(1);
        } else if (stack.method_31574(SoulForgeItems.KINDNESS_ARNICITE_HEART) || stack.method_31574(SoulForgeItems.INTEGRITY_ARNICITE_HEART)) {
            this.fuel += 2000;
            stack.method_7934(1);
        } else if (stack.method_31574(SoulForgeItems.KINDNESS_ARNICITE_CORE) || stack.method_31574(SoulForgeItems.INTEGRITY_ARNICITE_CORE)) {
            this.fuel += 20000;
            stack.method_7934(1);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<CreativeZoneBlockEntity> animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("SPINNN", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.soulforge.creative_zone_block");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new CreativeZoneScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public int getFuel() {
        if (this.fuel != 0) {
            return this.fuel;
        }
        if (this.propertyDelegate.method_17390(0) != 0) {
            return this.propertyDelegate.method_17390(0);
        }
        return 0;
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("creative_zone.fuel", this.fuel);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.fuel = nbt.method_10550("creative_zone.fuel");
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }
}

