/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.client.entity;

import com.pulsar.soulforge.entity.BlastEntity;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import team.lodestar.lodestone.helpers.RenderHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

@Environment(value=EnvType.CLIENT)
public class BlastRenderer
extends class_897<BlastEntity> {
    public static final RenderTypeProvider TRANSPARENT_TEXTURE_TRIANGLE_TRUE = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType((String)"transparent_texture_triangles", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27379, (LodestoneRenderTypeRegistry.LodestoneCompositeStateBuilder)LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.TRIANGLE_TEXTURE).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setLightmapState(class_4668.field_21383).setCullState(class_4668.field_21344).setTextureState(token.get())));
    public static final class_2960 MAIN_TEXTURE = new class_2960("soulforge", "textures/white.png");
    public static final class_2960 ENERGY_TEXTURE = new class_2960("soulforge", "textures/entity/energy_beam.png");
    public static final LodestoneRenderType MAIN_RENDER_TYPE_TRIANGLE = TRANSPARENT_TEXTURE_TRIANGLE_TRUE.apply(RenderTypeToken.createToken((class_2960)MAIN_TEXTURE));
    public static final LodestoneRenderType ENERGY_RENDER_TYPE_TRIANGLE = TRANSPARENT_TEXTURE_TRIANGLE_TRUE.apply(RenderTypeToken.createToken((class_2960)ENERGY_TEXTURE));
    public static final LodestoneRenderType MAIN_RENDER_TYPE_QUADS = LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.apply(RenderTypeToken.createToken((class_2960)MAIN_TEXTURE));
    public static final LodestoneRenderType ENERGY_RENDER_TYPE_QUADS = LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.apply(RenderTypeToken.createToken((class_2960)ENERGY_TEXTURE));

    public BlastRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public class_2960 getTexture(BlastEntity blastEntity) {
        return MAIN_TEXTURE;
    }

    protected int getBlockLight(BlastEntity blastEntity, class_2338 blockPos) {
        return 1;
    }

    public void render(BlastEntity blast, float f, float partialTicks, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        matrixStack.method_22903();
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setVertexSupplier((consumer, stack, vfxBuilder, x, y, z, u, v) -> {
            if (stack == null) {
                consumer.method_22912((double)x, (double)y, (double)z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22916(15).method_1344();
            } else {
                consumer.method_22918(stack, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22916(15).method_1344();
            }
        }).setFormat(class_290.field_20888);
        float x2 = (float)class_3532.method_16436((double)partialTicks, (double)blast.field_6038, (double)blast.method_23317());
        float y2 = (float)class_3532.method_16436((double)partialTicks, (double)blast.field_5971, (double)blast.method_23318());
        float z2 = (float)class_3532.method_16436((double)partialTicks, (double)blast.field_5989, (double)blast.method_23321());
        matrixStack.method_46416(-x2, -y2, -z2);
        class_243 toPos = blast.getEnd().method_1019(blast.method_19538());
        builder.setRenderType((class_1921)MAIN_RENDER_TYPE_QUADS);
        builder.setColor(blast.getColor()).setAlpha(1.0f).renderBeam(matrixStack.method_23760().method_23761(), blast.method_19538(), toPos, 2.0f * blast.getRadius());
        class_243 cameraPosition = class_310.method_1551().method_31975().field_4344.method_19326();
        class_243 normal = blast.method_19538().method_1020(cameraPosition).method_1036(toPos.method_1020(blast.method_19538())).method_1029().method_1021((double)0.01f);
        matrixStack.method_22904(normal.field_1352, normal.field_1351, normal.field_1350);
        builder.setRenderType((class_1921)ENERGY_RENDER_TYPE_QUADS);
        builder.setColor(blast.getColor()).setAlpha(0.3f).renderBeam(matrixStack.method_23760().method_23761(), blast.method_19538(), toPos, 2.0f * blast.getRadius());
        matrixStack.method_22909();
    }

    public void renderSphereGood(class_4588 consumer, class_4587 stack, float radius, int longs, int lats, Color color, int light) {
        Matrix4f last = stack.method_23760().method_23761();
        float startU = 0.0f;
        float startV = 0.0f;
        float endU = (float)Math.PI * 2;
        float endV = (float)Math.PI;
        float stepU = (endU - startU) / (float)longs;
        float stepV = (endV - startV) / (float)lats;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        for (int i = 0; i < longs; ++i) {
            for (int j = 0; j < lats; ++j) {
                float u = (float)i * stepU + startU;
                float v = (float)j * stepV + startV;
                float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                Vector3f p0 = RenderHelper.parametricSphere((float)u, (float)v, (float)radius);
                Vector3f p1 = RenderHelper.parametricSphere((float)u, (float)vn, (float)radius);
                Vector3f p2 = RenderHelper.parametricSphere((float)un, (float)v, (float)radius);
                Vector3f p3 = RenderHelper.parametricSphere((float)un, (float)vn, (float)radius);
                float textureU = u / endU;
                float textureV = v / endV;
                float textureUN = un / endU;
                float textureVN = vn / endV;
                RenderHelper.vertexPosColorUVLight((class_4588)consumer, (Matrix4f)last, (float)p0.x(), (float)p0.y(), (float)p0.z(), (float)r, (float)g, (float)b, (float)a, (float)textureU, (float)textureV, (int)light);
                RenderHelper.vertexPosColorUVLight((class_4588)consumer, (Matrix4f)last, (float)p2.x(), (float)p2.y(), (float)p2.z(), (float)r, (float)g, (float)b, (float)a, (float)textureUN, (float)textureV, (int)light);
                RenderHelper.vertexPosColorUVLight((class_4588)consumer, (Matrix4f)last, (float)p1.x(), (float)p1.y(), (float)p1.z(), (float)r, (float)g, (float)b, (float)a, (float)textureU, (float)textureVN, (int)light);
                RenderHelper.vertexPosColorUVLight((class_4588)consumer, (Matrix4f)last, (float)p3.x(), (float)p3.y(), (float)p3.z(), (float)r, (float)g, (float)b, (float)a, (float)textureUN, (float)textureVN, (int)light);
                RenderHelper.vertexPosColorUVLight((class_4588)consumer, (Matrix4f)last, (float)p1.x(), (float)p1.y(), (float)p1.z(), (float)r, (float)g, (float)b, (float)a, (float)textureU, (float)textureVN, (int)light);
                RenderHelper.vertexPosColorUVLight((class_4588)consumer, (Matrix4f)last, (float)p2.x(), (float)p2.y(), (float)p2.z(), (float)r, (float)g, (float)b, (float)a, (float)textureUN, (float)textureV, (int)light);
            }
        }
    }
}

