/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.client.entity;

import com.pulsar.soulforge.entity.WormholeEntity;
import java.awt.Color;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

@Environment(value=EnvType.CLIENT)
public class WormholeEntityRenderer
extends class_897<WormholeEntity> {
    private static final ArrayList<class_2960> RIFT_CRACKS = new ArrayList();
    private static final ArrayList<class_2960> RIFT_CRACKS_BLOOMS = new ArrayList();
    public static final ArrayList<class_1921> RIFT_CRACKS_RENDER_TYPES = new ArrayList();
    public static final ArrayList<class_1921> RIFT_CRACKS_BLOOMS_RENDER_TYPES = new ArrayList();

    public WormholeEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public static void initialiseCrackRenderTypes() {
        for (int i = 1; i <= 5; ++i) {
            class_2960 crack = new class_2960("soulforge", "textures/vfx/rift_crack_" + i + ".png");
            class_2960 bloom = new class_2960("soulforge", "textures/vfx/rift_crack_bloom_" + i + ".png");
            RIFT_CRACKS.add(crack);
            RIFT_CRACKS_BLOOMS.add(bloom);
            RIFT_CRACKS_RENDER_TYPES.add((class_1921)LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE_TRIANGLE.apply(RenderTypeToken.createToken((class_2960)crack)));
            RIFT_CRACKS_BLOOMS_RENDER_TYPES.add((class_1921)LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE_TRIANGLE.apply(RenderTypeToken.createToken((class_2960)bloom)));
        }
    }

    public class_2960 getTexture(WormholeEntity wormhole) {
        return RIFT_CRACKS.get(0);
    }

    protected int getBlockLight(WormholeEntity wormhole, class_2338 blockPos) {
        return 1;
    }

    public void render(WormholeEntity rift, float yaw, float partialTicks, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setVertexSupplier((consumer, stack, vfxBuilder, x, y, z, u, v) -> {
            if (stack == null) {
                consumer.method_22912((double)x, (double)y, (double)z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22916(15).method_1344();
            } else {
                consumer.method_22918(stack, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22916(15).method_1344();
            }
        }).setFormat(class_290.field_20888);
        float x2 = (float)class_3532.method_16436((double)partialTicks, (double)rift.field_6038, (double)rift.method_23317());
        float y2 = (float)class_3532.method_16436((double)partialTicks, (double)rift.field_5971, (double)rift.method_23318());
        float z2 = (float)class_3532.method_16436((double)partialTicks, (double)rift.field_5989, (double)rift.method_23321());
        matrixStack.method_46416(-x2, -y2, -z2);
        for (class_243 crack : rift.cracks) {
            class_243 toPos = crack.method_1019(rift.method_19538());
            float spreadTime = 3.0f;
            if ((float)rift.field_6012 + partialTicks <= spreadTime) {
                toPos = rift.method_19538().method_1019(crack.method_1021((double)(((float)rift.field_6012 + partialTicks) / spreadTime)));
            }
            builder.setRenderType(RIFT_CRACKS_RENDER_TYPES.get(rift.cracks.indexOf(crack) % 5));
            builder.setColor(new Color(0xFFFFFF)).setAlpha(1.0f).renderBeam(matrixStack.method_23760().method_23761(), rift.method_19538(), toPos, 2.0f * rift.getSize());
            builder.setRenderType(RIFT_CRACKS_BLOOMS_RENDER_TYPES.get(rift.cracks.indexOf(crack) % 5));
            builder.setColor(new Color(65424)).setAlpha(1.0f).renderBeam(matrixStack.method_23760().method_23761(), rift.method_19538(), toPos, 2.0f * rift.getSize());
            builder.setVertexConsumer(RenderHandler.DELAYED_RENDER.getTarget().getBuffer(RIFT_CRACKS_BLOOMS_RENDER_TYPES.get(rift.cracks.indexOf(crack) % 5)));
            for (int i = (int)(2.0f * rift.getSize()); i <= (int)(5.0f * rift.getSize()); ++i) {
                builder.setColor(new Color(0.0f, 1.0f, (float)i / (5.0f * rift.getSize()))).setAlpha(class_3532.method_15363((float)((class_3532.method_15374((float)(((float)rift.field_6012 + partialTicks + (float)i / rift.getSize() * 20.0f) / 10.0f)) + (float)i / rift.getSize() / 2.0f) / (2.0f * ((float)i / rift.getSize() / 2.0f))), (float)0.0f, (float)1.0f) / rift.getSize()).renderBeam(matrixStack.method_23760().method_23761(), rift.method_19538(), toPos, (float)i);
            }
        }
    }
}

