/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.client.render;

import java.awt.Color;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CylinderRenderer {
    private static final int CYLINDER_SEGMENTS = 16;

    public static void renderCylinder(Matrix4f model, class_4588 vertexConsumer, Vector3f a, Vector3f b, float radius, Color color, int overlay, int light, boolean dualFace) {
        float thetaStep = 0.3926991f;
        Vector3f direction = new Vector3f(b.x - a.x, b.y - a.y, b.z - a.z).normalize();
        Vector3f perp1 = new Vector3f(direction.z, direction.z, -(direction.x + direction.y)).normalize();
        Vector3f perp2 = new Vector3f(direction.y * perp1.z - direction.z * perp1.y, direction.z * perp1.x - direction.x * perp1.z, direction.x * perp1.y - direction.y * perp1.x).normalize();
        vertexConsumer.method_22901(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int j = 0; j < 16; ++j) {
            float theta1 = (float)j * thetaStep;
            float theta2 = (float)(j + 1) * thetaStep;
            Vector3f p1 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, radius).add((Vector3fc)a);
            Vector3f p2 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, radius).add((Vector3fc)a);
            Vector3f p3 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, radius).add((Vector3fc)b);
            Vector3f p4 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, radius).add((Vector3fc)b);
            CylinderRenderer.renderQuad(model, vertexConsumer, p1, p2, p3, p4, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, p2, p1, a, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, p4, p3, b, overlay, light);
            if (!dualFace) continue;
            CylinderRenderer.renderQuad(model, vertexConsumer, p4, p3, p2, p1, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, a, p1, p2, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, b, p3, p4, overlay, light);
        }
        vertexConsumer.method_35666();
    }

    public static void renderCylinder(Matrix4f model, class_4588 vertexConsumer, Vector3f a, Vector3f b, float startRad, float endRad, Color color, int overlay, int light) {
        float thetaStep = 0.3926991f;
        Vector3f direction = new Vector3f(b.x - a.x, b.y - a.y, b.z - a.z).normalize();
        Vector3f perp1 = new Vector3f(direction.z, direction.z, -(direction.x + direction.y)).normalize();
        Vector3f perp2 = new Vector3f(direction.y * perp1.z - direction.z * perp1.y, direction.z * perp1.x - direction.x * perp1.z, direction.x * perp1.y - direction.y * perp1.x).normalize();
        vertexConsumer.method_22901(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int j = 0; j < 16; ++j) {
            float theta1 = (float)j * thetaStep;
            float theta2 = (float)(j + 1) * thetaStep;
            Vector3f p1 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, startRad).add((Vector3fc)a);
            Vector3f p2 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, startRad).add((Vector3fc)a);
            Vector3f p3 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, endRad).add((Vector3fc)b);
            Vector3f p4 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, endRad).add((Vector3fc)b);
            CylinderRenderer.renderQuad(model, vertexConsumer, p1, p2, p3, p4, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, p2, p1, a, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, p4, p3, b, overlay, light);
        }
        vertexConsumer.method_35666();
    }

    public static void renderCylinderInnerFace(Matrix4f model, class_4588 vertexConsumer, Vector3f a, Vector3f b, float radius, Color color, int overlay, int light) {
        float thetaStep = 0.3926991f;
        Vector3f direction = new Vector3f(b.x - a.x, b.y - a.y, b.z - a.z).normalize();
        Vector3f perp1 = new Vector3f(direction.z, direction.z, -(direction.x + direction.y)).normalize();
        Vector3f perp2 = new Vector3f(direction.y * perp1.z - direction.z * perp1.y, direction.z * perp1.x - direction.x * perp1.z, direction.x * perp1.y - direction.y * perp1.x).normalize();
        vertexConsumer.method_22901(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int j = 0; j < 16; ++j) {
            float theta1 = (float)j * thetaStep;
            float theta2 = (float)(j + 1) * thetaStep;
            Vector3f p1 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, radius).add((Vector3fc)a);
            Vector3f p2 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, radius).add((Vector3fc)a);
            Vector3f p3 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, radius).add((Vector3fc)b);
            Vector3f p4 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, radius).add((Vector3fc)b);
            CylinderRenderer.renderQuad(model, vertexConsumer, p4, p3, p2, p1, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, a, p1, p2, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, b, p3, p4, overlay, light);
        }
        vertexConsumer.method_35666();
    }

    public static void renderCylinderWithTexture(Matrix4f model, class_4588 vertexConsumer, Vector3f a, Vector3f b, float radius, Color color, int overlay, int light, float uOffset, float vOffset) {
        float thetaStep = 0.3926991f;
        Vector3f direction = new Vector3f(b.x - a.x, b.y - a.y, b.z - a.z).normalize();
        Vector3f perp1 = new Vector3f(direction.z, direction.z, -(direction.x + direction.y)).normalize();
        Vector3f perp2 = new Vector3f(direction.y * perp1.z - direction.z * perp1.y, direction.z * perp1.x - direction.x * perp1.z, direction.x * perp1.y - direction.y * perp1.x).normalize();
        vertexConsumer.method_22901(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int j = 0; j < 16; ++j) {
            float theta1 = (float)j * thetaStep;
            float theta2 = (float)(j + 1) * thetaStep;
            Vector3f p1 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, radius).add((Vector3fc)a);
            Vector3f p2 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, radius).add((Vector3fc)a);
            Vector3f p3 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, radius).add((Vector3fc)b);
            Vector3f p4 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, radius).add((Vector3fc)b);
            CylinderRenderer.renderQuad(model, vertexConsumer, p1, p2, p3, p4, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, p2, p1, a, overlay, light);
            CylinderRenderer.renderTri(model, vertexConsumer, p4, p3, b, overlay, light);
        }
        vertexConsumer.method_35666();
    }

    private static Vector3f calculateCylinderPoint(float theta, Vector3f perp1, Vector3f perp2, float radius) {
        return new Vector3f((float)((double)radius * (Math.cos(theta) * (double)perp1.x + Math.sin(theta) * (double)perp2.x)), (float)((double)radius * (Math.cos(theta) * (double)perp1.y + Math.sin(theta) * (double)perp2.y)), (float)((double)radius * (Math.cos(theta) * (double)perp1.z + Math.sin(theta) * (double)perp2.z)));
    }

    private static void renderQuad(Matrix4f model, class_4588 vertices, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, int overlay, int light) {
        vertices.method_22918(model, p1.x, p1.y, p1.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p2.x, p2.y, p2.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p3.x, p3.y, p3.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p4.x, p4.y, p4.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private static void renderTri(Matrix4f model, class_4588 vertices, Vector3f p1, Vector3f p2, Vector3f p3, int overlay, int light, float u, float v) {
        vertices.method_22918(model, p1.x, p1.y, p1.z).method_22913(u, v).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p2.x, p2.y, p2.z).method_22913(u, v).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p3.x, p3.y, p3.z).method_22913(u, v).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p3.x, p3.y, p3.z).method_22913(u, u).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private static void renderQuad(Matrix4f model, class_4588 vertices, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, int overlay, int light, float u, float v) {
        vertices.method_22918(model, p1.x, p1.y, p1.z).method_22913(0.0f, 0.0f).method_22922(0).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p2.x, p2.y, p2.z).method_22913(0.0f, 0.0f).method_22922(0).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p3.x, p3.y, p3.z).method_22913(0.0f, 0.0f).method_22922(0).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p4.x, p4.y, p4.z).method_22913(0.0f, 0.0f).method_22922(0).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private static void renderTri(Matrix4f model, class_4588 vertices, Vector3f p1, Vector3f p2, Vector3f p3, int overlay, int light) {
        vertices.method_22918(model, p1.x, p1.y, p1.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p2.x, p2.y, p2.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p3.x, p3.y, p3.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p3.x, p3.y, p3.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    public static void renderCylinder(class_4588 vertexConsumer, Vector3f a, Vector3f b, float radius, Color color, int overlay, int light) {
        float thetaStep = 0.3926991f;
        Vector3f direction = new Vector3f(b.x - a.x, b.y - a.y, b.z - a.z).normalize();
        Vector3f perp1 = new Vector3f(direction.z, direction.z, -(direction.x + direction.y)).normalize();
        Vector3f perp2 = new Vector3f(direction.y * perp1.z - direction.z * perp1.y, direction.z * perp1.x - direction.x * perp1.z, direction.x * perp1.y - direction.y * perp1.x).normalize();
        vertexConsumer.method_22901(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int j = 0; j < 16; ++j) {
            float theta1 = (float)j * thetaStep;
            float theta2 = (float)(j + 1) * thetaStep;
            Vector3f p1 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, radius).add((Vector3fc)a);
            Vector3f p2 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, radius).add((Vector3fc)a);
            Vector3f p3 = CylinderRenderer.calculateCylinderPoint(theta2, perp1, perp2, radius).add((Vector3fc)b);
            Vector3f p4 = CylinderRenderer.calculateCylinderPoint(theta1, perp1, perp2, radius).add((Vector3fc)b);
            CylinderRenderer.renderQuad(vertexConsumer, p1, p2, p3, p4, overlay, light);
            CylinderRenderer.renderTri(vertexConsumer, p2, p1, a, overlay, light);
            CylinderRenderer.renderTri(vertexConsumer, p4, p3, b, overlay, light);
        }
        vertexConsumer.method_35666();
    }

    public static void renderCylinder(class_4588 vertexConsumer, Vector3f a, Vector3f b, float radius, Color color) {
        CylinderRenderer.renderCylinder(vertexConsumer, a, b, radius, color, 0, 255);
    }

    private static void renderQuad(class_4588 vertices, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, int overlay, int light) {
        vertices.method_22912((double)p1.x, (double)p1.y, (double)p1.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p2.x, (double)p2.y, (double)p2.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p3.x, (double)p3.y, (double)p3.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p4.x, (double)p4.y, (double)p4.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private static void renderTri(class_4588 vertices, Vector3f p1, Vector3f p2, Vector3f p3, int overlay, int light) {
        vertices.method_22912((double)p1.x, (double)p1.y, (double)p1.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p2.x, (double)p2.y, (double)p2.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p3.x, (double)p3.y, (double)p3.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p3.x, (double)p3.y, (double)p3.z).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }
}

