/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.client.render;

import java.awt.Color;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SphereRenderer {
    private static final int SPHERE_SEGMENTS = 16;
    private static final int SPHERE_RINGS = 8;

    public static void renderSphere(Matrix4f model, class_4588 vertexConsumer, float size, Color color) {
        float phiStep = 0.3926991f;
        float thetaStep = 0.3926991f;
        vertexConsumer.method_22901(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int i = 0; i < 8; ++i) {
            float phi1 = (float)i * phiStep;
            float phi2 = (float)(i + 1) * phiStep;
            for (int j = 0; j < 16; ++j) {
                float theta1 = (float)j * thetaStep;
                float theta2 = (float)(j + 1) * thetaStep;
                Vector3f p1 = SphereRenderer.calculateSpherePoint(phi1, theta1, size);
                Vector3f p2 = SphereRenderer.calculateSpherePoint(phi1, theta2, size);
                Vector3f p3 = SphereRenderer.calculateSpherePoint(phi2, theta2, size);
                Vector3f p4 = SphereRenderer.calculateSpherePoint(phi2, theta1, size);
                SphereRenderer.renderQuad(model, vertexConsumer, p1, p2, p3, p4);
            }
        }
        vertexConsumer.method_35666();
    }

    public static void renderSphere(class_4588 vertexConsumer, Vector3f position, float size, Color color) {
        float phiStep = 0.3926991f;
        float thetaStep = 0.3926991f;
        vertexConsumer.method_22901(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int i = 0; i < 8; ++i) {
            float phi1 = (float)i * phiStep;
            float phi2 = (float)(i + 1) * phiStep;
            for (int j = 0; j < 16; ++j) {
                float theta1 = (float)j * thetaStep;
                float theta2 = (float)(j + 1) * thetaStep;
                Vector3f p1 = SphereRenderer.calculateSpherePoint(phi1, theta1, size).add((Vector3fc)position);
                Vector3f p2 = SphereRenderer.calculateSpherePoint(phi1, theta2, size).add((Vector3fc)position);
                Vector3f p3 = SphereRenderer.calculateSpherePoint(phi2, theta2, size).add((Vector3fc)position);
                Vector3f p4 = SphereRenderer.calculateSpherePoint(phi2, theta1, size).add((Vector3fc)position);
                SphereRenderer.renderQuad(vertexConsumer, p1, p2, p3, p4);
            }
        }
        vertexConsumer.method_35666();
    }

    private static Vector3f calculateSpherePoint(float phi, float theta, float mul) {
        float x = (float)(Math.sin(phi) * Math.cos(theta));
        float y = (float)Math.cos(phi);
        float z = (float)(Math.sin(phi) * Math.sin(theta));
        return new Vector3f(x, y, z).normalize().mul(mul);
    }

    private static void renderQuad(Matrix4f model, class_4588 vertices, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4) {
        vertices.method_22918(model, p1.x, p1.y, p1.z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p2.x, p2.y, p2.z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p3.x, p3.y, p3.z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22918(model, p4.x, p4.y, p4.z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private static void renderQuad(class_4588 vertices, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4) {
        vertices.method_22912((double)p1.x, (double)p1.y, (double)p1.z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p2.x, (double)p2.y, (double)p2.z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p3.x, (double)p3.y, (double)p3.z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        vertices.method_22912((double)p4.x, (double)p4.y, (double)p4.z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }
}

