/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.client.ui;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.StringCalculator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class EncyclopediaScreen
extends class_437 {
    public static final class_2960 TEXTURE = new class_2960("soulforge", "textures/ui/encyclopedia.png");
    public PageButton leftPage;
    public PageButton rightPage;
    public int currentPage = 0;
    public int maxPages = 101;
    public List<class_4068> widgets = List.of();

    public EncyclopediaScreen() {
        super((class_2561)class_2561.method_43470((String)"Encyclopedia"));
    }

    public EncyclopediaScreen(int pageNum) {
        super((class_2561)class_2561.method_43470((String)"Encyclopedia"));
        this.currentPage = pageNum;
    }

    protected void method_25426() {
        this.updateWidgets();
    }

    public void updateWidgets() {
        int i;
        this.widgets = new ArrayList<class_4068>();
        this.method_37067();
        this.leftPage = new PageButton(this.field_22789 / 2 - 125, this.field_22790 / 2 + 64, true, () -> {
            this.currentPage = Math.max(0, this.currentPage - 1);
            this.updateWidgets();
        });
        this.rightPage = new PageButton(this.field_22789 / 2 + 102, this.field_22790 / 2 + 64, false, () -> {
            this.currentPage = Math.min(this.maxPages, this.currentPage + 1);
            this.updateWidgets();
        });
        this.widgets.add((class_4068)this.leftPage);
        this.widgets.add((class_4068)this.rightPage);
        this.method_25429((class_364)this.leftPage);
        this.method_25429((class_364)this.rightPage);
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)this.field_22787.field_1724);
        int left = (this.field_22789 - 283) / 2;
        int top = (this.field_22790 - 180) / 2;
        if (this.currentPage == 0) {
            i = 1;
            int j = 0;
            for (TraitBase trait : Traits.all()) {
                int finalI = i;
                ContentButton traitButton = new ContentButton(left + 159, top + 17 + j * 10, 105, 9, () -> {
                    this.currentPage = finalI;
                    this.updateWidgets();
                }, trait.getName());
                i += trait.getAbilities().size() + 1;
                ++j;
                this.widgets.add((class_4068)traitButton);
                this.method_25429((class_364)traitButton);
            }
            ContentButton siphonsButton = new ContentButton(left + 159, top + 17 + j * 10, 105, 9, () -> {
                this.currentPage = 77;
                this.updateWidgets();
            }, "Siphons");
            this.widgets.add((class_4068)siphonsButton);
            this.method_25429((class_364)siphonsButton);
            ContentButton dualsButton = new ContentButton(left + 159, top + 17 + ++j * 10, 105, 9, () -> {
                this.currentPage = 81;
                this.updateWidgets();
            }, "Duals");
            this.widgets.add((class_4068)dualsButton);
            this.method_25429((class_364)dualsButton);
            ContentButton puresButton = new ContentButton(left + 159, top + 17 + ++j * 10, 105, 9, () -> {
                this.currentPage = 96;
                this.updateWidgets();
            }, "Pures");
            this.widgets.add((class_4068)puresButton);
            this.method_25429((class_364)puresButton);
        }
        i = 1;
        for (TraitBase trait : Traits.all()) {
            if (this.currentPage == i) {
                int j = 0;
                List<AbilityBase> abilities = List.copyOf(trait.getAbilities());
                abilities = abilities.stream().sorted(Comparator.comparingInt(AbilityBase::getLV)).toList();
                for (AbilityBase ability : abilities) {
                    int pageNum = i + j;
                    ContentButton abilityButton = new ContentButton(left + 159, top + 17 + j * 10, 105, 9, () -> {
                        this.currentPage = pageNum + 1;
                        this.updateWidgets();
                    }, ability.getLocalizedText());
                    ++j;
                    this.widgets.add((class_4068)abilityButton);
                    this.method_25429((class_364)abilityButton);
                }
            }
            i += trait.getAbilities().size() + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int k;
        this.method_25420(context);
        int left = (this.field_22789 - 283) / 2;
        int top = (this.field_22790 - 180) / 2;
        context.method_25290(TEXTURE, left, top, 0.0f, 0.0f, 283, 180, 283, 180);
        for (class_4068 widget : this.widgets) {
            widget.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.field_22787 == null) {
            return;
        }
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)this.field_22787.field_1724);
        switch (this.currentPage) {
            case 0: {
                context.method_25290(new class_2960("soulforge", "icon.png"), left + 32, top + 19, 0.0f, 0.0f, 79, 79, 79, 79);
                class_5250 leftText = class_2561.method_43471((String)"encyclopedia.front_page.text");
                int j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)leftText, 105)) {
                    context.method_35719(this.field_22793, text, left + 71, top + 102 + j, 0xBBBBBB);
                    j += 9;
                }
                break;
            }
            case 77: {
                class_5250 leftText = class_2561.method_43471((String)"encyclopedia.siphons");
                int j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)leftText, 105)) {
                    context.method_35719(this.field_22793, text, left + 71, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                class_5250 rightText = class_2561.method_43471((String)"encyclopedia.siphons.determination");
                j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)rightText, 105)) {
                    context.method_35719(this.field_22793, text, left + 211, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                break;
            }
            case 78: {
                class_5250 leftText = class_2561.method_43471((String)"encyclopedia.siphons.bravery");
                int j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)leftText, 105)) {
                    context.method_35719(this.field_22793, text, left + 71, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                class_5250 rightText = class_2561.method_43471((String)"encyclopedia.siphons.justice");
                j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)rightText, 105)) {
                    context.method_35719(this.field_22793, text, left + 211, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                break;
            }
            case 79: {
                class_5250 leftText = class_2561.method_43471((String)"encyclopedia.siphons.kindness");
                int j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)leftText, 105)) {
                    context.method_35719(this.field_22793, text, left + 71, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                class_5250 rightText = class_2561.method_43471((String)"encyclopedia.siphons.patience");
                j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)rightText, 105)) {
                    context.method_35719(this.field_22793, text, left + 211, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                break;
            }
            case 80: {
                class_5250 leftText = class_2561.method_43471((String)"encyclopedia.siphons.integrity");
                int j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)leftText, 105)) {
                    context.method_35719(this.field_22793, text, left + 71, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                class_5250 rightText = class_2561.method_43471((String)"encyclopedia.siphons.perseverance");
                j = 0;
                for (class_5481 text : this.field_22793.method_1728((class_5348)rightText, 105)) {
                    context.method_35719(this.field_22793, text, left + 211, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                break;
            }
        }
        int i = 0;
        for (TraitBase trait : Traits.all()) {
            if (this.currentPage == ++i) {
                context.method_27534(this.field_22793, (class_2561)trait.getLocalizedText(), left + 71, top + 17, trait.getColor());
                class_5250 text = class_2561.method_43471((String)("encyclopedia.trait." + trait.getName().toLowerCase() + ".text"));
                int j = 9;
                for (class_5481 line : this.field_22793.method_1728((class_5348)text, 105)) {
                    context.method_35719(this.field_22793, line, left + 71, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
                continue;
            }
            List<AbilityBase> abilities = List.copyOf(trait.getAbilities());
            abilities = abilities.stream().sorted(Comparator.comparingInt(AbilityBase::getLV)).toList();
            for (AbilityBase ability : abilities) {
                if (this.currentPage != ++i) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                class_5250 description = class_2561.method_43471((String)("encyclopedia.ability." + ability.getID().method_12832() + ".text"));
                class_2960 texture = new class_2960("soulforge", "textures/ui/ability_icon/" + ability.getID().method_12832() + ".png");
                arrayList.add(ability.getLocalizedText());
                arrayList.add(class_2561.method_43470((String)"\"").method_27693(ability.getTooltip()).method_27693("\""));
                arrayList.add(class_2561.method_43471((String)"encyclopedia.prefixes.lv").method_27693("" + ability.getLV()));
                arrayList.add(class_2561.method_43471((String)"encyclopedia.prefixes.cost").method_27693("" + ability.getCost()));
                int n = ability.getCooldown();
                class_5250 cooldownText = n == 0 ? class_2561.method_43471((String)"encyclopedia.cooldown.none") : (n < 20 ? class_2561.method_43470((String)(n + " ")).method_10852((class_2561)class_2561.method_43471((String)"encyclopedia.cooldown.ticks")) : (n < 1200 ? class_2561.method_43470((String)String.format("%.02f ", Float.valueOf((float)n / 20.0f))).method_10852((class_2561)class_2561.method_43471((String)"encyclopedia.cooldown.seconds")) : class_2561.method_43470((String)String.format("%.02f ", Float.valueOf((float)n / 1200.0f))).method_10852((class_2561)class_2561.method_43471((String)"encyclopedia.cooldown.minutes"))));
                arrayList.add(class_2561.method_43471((String)"encyclopedia.prefixes.cooldown").method_10852((class_2561)cooldownText));
                String desc = description.getString();
                while (desc.contains("${")) {
                    String toReplace = desc.substring(desc.indexOf("${") + 2, desc.indexOf("}"));
                    String string = toReplace.replace("lv", String.valueOf(playerSoul.getLV()));
                    int value = 0;
                    try {
                        value = (int)StringCalculator.getResult(string);
                    }
                    catch (Exception e) {
                        SoulForge.LOGGER.warn("Exception occurred while attempting to calculate string " + string + ". Exception: " + String.valueOf(e));
                    }
                    desc = desc.replace("${" + toReplace + "}", String.valueOf(value));
                }
                description = class_2561.method_43470((String)desc);
                context.method_25290(texture, left + 33, top + 19, 0.0f, 0.0f, 79, 79, 79, 79);
                int j = 0;
                for (class_2561 class_25612 : arrayList) {
                    for (class_5481 text : this.field_22793.method_1728((class_5348)class_25612, 105)) {
                        context.method_35719(this.field_22793, text, left + 71, top + 102 + j, 0xBBBBBB);
                        j += 9;
                    }
                }
                j = 0;
                for (class_5481 class_54812 : this.field_22793.method_1728((class_5348)description, 105)) {
                    context.method_35719(this.field_22793, class_54812, left + 211, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
            }
        }
        i = 80;
        for (k = 0; k < Traits.all().size() - 1; ++k) {
            TraitBase trait1 = Traits.all().get(k);
            if (trait1 == Traits.determination) continue;
            for (int l = k + 1; l < Traits.all().size(); ++l) {
                void var18_37;
                TraitBase trait2 = Traits.all().get(l);
                if (trait2 == Traits.determination || trait1 == trait2 || this.currentPage != ++i) continue;
                ArrayList<class_5250> data = new ArrayList<class_5250>();
                class_5250 description = class_2561.method_43471((String)("encyclopedia.dual." + trait1.getName().toLowerCase() + "_" + trait2.getName().toLowerCase() + ".text"));
                if (!playerSoul.getResetData().hasDual(trait1, trait2)) {
                    String string = class_2561.method_43471((String)"encyclopedia.unlock_dual").getString();
                    data.add(class_2561.method_43470((String)string.replace("{0}", trait1.getName() + "-" + trait2.getName())));
                    description = class_2561.method_43471((String)"encyclopedia.missing_dual.text");
                } else {
                    data.add(trait1.getLocalizedText().method_27693("-").method_10852((class_2561)trait2.getLocalizedText()));
                }
                String string = description.getString();
                while (var18_37.contains("${")) {
                    Iterator toReplace = var18_37.substring(var18_37.indexOf("${") + 2, var18_37.indexOf("}"));
                    String string2 = ((String)((Object)toReplace)).replace("lv", String.valueOf(playerSoul.getLV()));
                    int value = 0;
                    try {
                        value = (int)StringCalculator.getResult(string2);
                    }
                    catch (Exception e) {
                        SoulForge.LOGGER.warn("Exception occurred while attempting to calculate string " + string2 + ". Exception: " + String.valueOf(e));
                    }
                    String string3 = var18_37.replace("${" + toReplace + "}", String.valueOf(value));
                }
                description = class_2561.method_43470((String)var18_37);
                int j = 0;
                for (class_2561 class_25613 : data) {
                    for (class_5481 text : this.field_22793.method_1728((class_5348)class_25613, 105)) {
                        context.method_35719(this.field_22793, text, left + 71, top + 17 + j, 0xBBBBBB);
                        j += 9;
                    }
                }
                j = 0;
                for (class_5481 class_54813 : this.field_22793.method_1728((class_5348)description, 105)) {
                    context.method_35719(this.field_22793, class_54813, left + 211, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
            }
        }
        for (k = 0; k < Traits.all().size() - 1; ++k) {
            TraitBase trait;
            trait = Traits.all().get(k);
            if (trait == Traits.determination || this.currentPage != ++i) continue;
            ArrayList<class_5250> data = new ArrayList<class_5250>();
            class_5250 description = class_2561.method_43471((String)("encyclopedia.pure." + trait.getName().toLowerCase() + ".text"));
            if (!playerSoul.getResetData().hasPure(trait)) {
                String text = class_2561.method_43471((String)"encyclopedia.unlock_pure").getString();
                data.add(class_2561.method_43470((String)text.replace("{0}", trait.getName())));
                description = class_2561.method_43471((String)"encyclopedia.missing_pure.text");
            } else {
                data.add(trait.getLocalizedText());
            }
            String desc = description.getString();
            while (desc.contains("${")) {
                String toReplace = desc.substring(desc.indexOf("${") + 2, desc.indexOf("}"));
                String string = toReplace.replace("lv", String.valueOf(playerSoul.getLV()));
                int value = 0;
                try {
                    value = (int)StringCalculator.getResult(string);
                }
                catch (Exception exception) {
                    SoulForge.LOGGER.warn("Exception occurred while attempting to calculate string " + string + ". Exception: " + String.valueOf(exception));
                }
                desc = desc.replace("${" + toReplace + "}", String.valueOf(value));
            }
            description = class_2561.method_43470((String)desc);
            int j = 0;
            for (class_2561 class_25614 : data) {
                for (class_5481 class_54814 : this.field_22793.method_1728((class_5348)class_25614, 105)) {
                    context.method_35719(this.field_22793, class_54814, left + 71, top + 17 + j, 0xBBBBBB);
                    j += 9;
                }
            }
            j = 0;
            for (class_5481 class_54815 : this.field_22793.method_1728((class_5348)description, 105)) {
                context.method_35719(this.field_22793, class_54815, left + 211, top + 17 + j, 0xBBBBBB);
                j += 9;
            }
        }
    }

    public static class PageButton
    extends class_339 {
        private final boolean isLeft;
        private final PressAction pressAction;

        protected PageButton(int x, int y, boolean isLeft, PressAction pressAction) {
            super(x, y, 23, 13, (class_2561)class_2561.method_43473());
            this.isLeft = isLeft;
            this.pressAction = pressAction;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int u = this.method_49606() ? 26 : 3;
            int v = this.isLeft ? 207 : 194;
            context.method_25290(new class_2960("textures/gui/book.png"), this.method_46426(), this.method_46427(), (float)u, (float)v, 18, 10, 256, 256);
        }

        protected void method_47399(class_6382 builder) {
        }

        public void method_25348(double mouseX, double mouseY) {
            if (this.method_49606()) {
                this.pressAction.onPress();
            }
        }

        public static interface PressAction {
            public void onPress();
        }
    }

    public static class ContentButton
    extends class_4264 {
        private final PressAction pressAction;

        protected ContentButton(int x, int y, int width, int height, PressAction pressAction, String text) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)text));
            this.pressAction = pressAction;
        }

        protected ContentButton(int x, int y, int width, int height, PressAction pressAction, class_2561 text) {
            super(x, y, width, height, text);
            this.pressAction = pressAction;
        }

        protected void method_47399(class_6382 builder) {
        }

        public void method_25306() {
            this.pressAction.onPress();
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            this.method_48589(context, class_310.method_1551().field_1772, 0xBBBBBB);
        }

        public static interface PressAction {
            public void onPress();
        }
    }
}

