/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.client.ui;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.config.ConfigHelper;
import com.pulsar.soulforge.util.Utils;
import java.awt.Color;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class MagicHudOverlay
implements HudRenderCallback {
    int rainbowAnim = 0;

    public void onHudRender(class_332 context, float tickDelta) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)class_310.method_1551().field_1724);
        if (playerSoul.getTraits().isEmpty()) {
            return;
        }
        this.renderMagicBar(context);
        if (Utils.isInverted(playerSoul)) {
            this.renderMagicGauge(context);
        }
    }

    public void renderMagicBar(class_332 context) {
        int top;
        class_310 client = class_310.method_1551();
        int left = switch (ConfigHelper.getMagicBarLocation()) {
            case ConfigHelper.MagicBarLocation.BOTTOM_RIGHT -> {
                top = client.method_22683().method_4502() - 136;
                yield client.method_22683().method_4486() - 27;
            }
            case ConfigHelper.MagicBarLocation.TOP_LEFT -> {
                top = 30;
                yield 5;
            }
            case ConfigHelper.MagicBarLocation.TOP_RIGHT -> {
                top = 30;
                yield client.method_22683().method_4486() - 27;
            }
            default -> {
                top = client.method_22683().method_4502() - 136;
                yield 5;
            }
        };
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)client.field_1724);
        context.method_25290(new class_2960("soulforge", "textures/ui/magic/bar_background.png"), left, top, 0.0f, 0.0f, 21, 106, 21, 106);
        int magic = (int)playerSoul.getMagic();
        int colorA = playerSoul.getTrait(0).getColor();
        int colorB = playerSoul.getTrait(playerSoul.getTraitCount() - 1).getColor();
        colorA = new Color(colorA, false).getRGB();
        colorB = new Color(colorB, false).getRGB();
        int darkA = new Color(colorA).darker().getRGB();
        int darkB = new Color(colorB).darker().getRGB();
        int darkkA = new Color(darkA).darker().getRGB();
        int darkkB = new Color(darkB).darker().getRGB();
        Color styleColor = new Color(255, 0, 255);
        context.method_25301(left + 2, top + 2, top + 52, darkkB);
        context.method_25301(left + 2, top + 51, top + 103, darkkA);
        context.method_25301(left + 13, top + 2, top + 52, darkkB);
        context.method_25301(left + 13, top + 51, top + 103, darkkA);
        context.method_25301(left + 18, top + 2, top + 52, darkkB);
        context.method_25301(left + 18, top + 51, top + 103, darkkA);
        context.method_25292(left + 3, left + 18, top + 2, darkkB);
        context.method_25292(left + 3, left + 18, top + 103, darkkA);
        if (magic != 0) {
            context.method_25294(left + 3, top + 102 - Math.min(magic - 1, 50), left + 13, top + 103, colorA);
        }
        if (magic <= 50) {
            context.method_25294(left + 3, top + 103 - (magic - 1), left + 13, top + 52, darkA);
        } else {
            context.method_25294(left + 3, top + 102 - (magic - 1), left + 13, top + 52, colorB);
        }
        if (magic != 100) {
            context.method_25294(left + 3, top + 102 - Math.max(50, magic - 1), left + 13, top + 2, darkB);
        }
        float stylePercent = (float)playerSoul.getStyle() / (float)playerSoul.getStyleRequirement();
        context.method_25294(left + 14, top + 103, left + 18, top + 103 - (int)(stylePercent * 100.0f), styleColor.getRGB());
        context.method_25294(left + 14, top + 103 - (int)(stylePercent * 100.0f), left + 18, top + 3, styleColor.darker().getRGB());
        if (playerSoul.getStyleRank() < 5) {
            class_2960 styleTextureID = new class_2960("soulforge", "textures/ui/magic/style_" + playerSoul.getStyleRank() + ".png");
            context.method_25290(styleTextureID, left + 3, top - 20, 0.0f, 0.0f, 15, 15, 15, 15);
        } else if (playerSoul.getStyleRank() == 5) {
            for (int x = 0; x < 15; ++x) {
                for (int y = 0; y < 15; ++y) {
                    context.method_25294(left + x + 3, top + y - 20, left + x + 4, top + y - 19, Color.getHSBColor((float)((this.rainbowAnim + x + y) % 40) / 40.0f, 1.0f, 1.0f).getRGB());
                }
            }
            this.rainbowAnim = (this.rainbowAnim + 1) % 40;
            class_2960 styleTextureID = new class_2960("soulforge", "textures/ui/magic/style_5.png");
            context.method_25290(styleTextureID, left + 3, top - 20, 0.0f, 0.0f, 15, 15, 15, 15);
        } else {
            class_2960 styleTextureID = new class_2960("soulforge", "textures/ui/forg.png");
            context.method_25290(styleTextureID, left + 3, top - 20, 0.0f, 0.0f, 15, 15, 15, 15);
        }
    }

    public void renderMagicGauge(class_332 context) {
        int top;
        class_310 client = class_310.method_1551();
        int left = switch (ConfigHelper.getMagicBarLocation()) {
            case ConfigHelper.MagicBarLocation.BOTTOM_RIGHT -> {
                top = client.method_22683().method_4502() - 136;
                yield client.method_22683().method_4486() - 67;
            }
            case ConfigHelper.MagicBarLocation.TOP_LEFT -> {
                top = 30;
                yield 55;
            }
            case ConfigHelper.MagicBarLocation.TOP_RIGHT -> {
                top = 30;
                yield client.method_22683().method_4486() - 67;
            }
            default -> {
                top = client.method_22683().method_4502() - 136;
                yield 55;
            }
        };
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)client.field_1724);
        context.method_25290(new class_2960("soulforge", "textures/ui/magic/bar_background.png"), left, top, 0.0f, 0.0f, 21, 106, 21, 106);
        int magic = (int)(playerSoul.getMagicGauge() / 300.0f);
        int colorA = playerSoul.getTrait(0).getColor();
        int colorB = playerSoul.getTrait(playerSoul.getTraitCount() - 1).getColor();
        colorA = new Color(colorA, false).getRGB();
        colorB = new Color(colorB, false).getRGB();
        int darkA = new Color(colorA).darker().getRGB();
        int darkB = new Color(colorB).darker().getRGB();
        int darkkA = new Color(darkA).darker().getRGB();
        int darkkB = new Color(darkB).darker().getRGB();
        Color styleColor = new Color(255, 0, 255);
        context.method_25301(left + 2, top + 2, top + 52, darkkB);
        context.method_25301(left + 2, top + 51, top + 103, darkkA);
        context.method_25301(left + 13, top + 2, top + 52, darkkB);
        context.method_25301(left + 13, top + 51, top + 103, darkkA);
        context.method_25301(left + 18, top + 2, top + 52, darkkB);
        context.method_25301(left + 18, top + 51, top + 103, darkkA);
        context.method_25292(left + 3, left + 18, top + 2, darkkB);
        context.method_25292(left + 3, left + 18, top + 103, darkkA);
        if (magic != 0) {
            context.method_25294(left + 3, top + 102 - Math.min(magic - 1, 50), left + 13, top + 103, colorA);
        }
        if (magic <= 50) {
            context.method_25294(left + 3, top + 103 - (magic - 1), left + 13, top + 52, darkA);
        } else {
            context.method_25294(left + 3, top + 102 - (magic - 1), left + 13, top + 52, colorB);
        }
        if (magic != 100) {
            context.method_25294(left + 3, top + 102 - Math.max(50, magic - 1), left + 13, top + 2, darkB);
        }
        float stylePercent = (float)playerSoul.getStyle() / (float)playerSoul.getStyleRequirement();
        context.method_25294(left + 14, top + 103, left + 18, top + 103 - (int)(stylePercent * 100.0f), styleColor.getRGB());
        context.method_25294(left + 14, top + 103 - (int)(stylePercent * 100.0f), left + 18, top + 3, styleColor.darker().getRGB());
        if (playerSoul.getStyleRank() < 5) {
            class_2960 styleTextureID = new class_2960("soulforge", "textures/ui/magic/style_" + playerSoul.getStyleRank() + ".png");
            context.method_25290(styleTextureID, left + 3, top - 20, 0.0f, 0.0f, 15, 15, 15, 15);
        } else if (playerSoul.getStyleRank() == 5) {
            for (int x = 0; x < 15; ++x) {
                for (int y = 0; y < 15; ++y) {
                    context.method_25294(left + x + 3, top + y - 20, left + x + 4, top + y - 19, Color.getHSBColor((float)((this.rainbowAnim + x + y) % 40) / 40.0f, 1.0f, 1.0f).getRGB());
                }
            }
            this.rainbowAnim = (this.rainbowAnim + 1) % 40;
            class_2960 styleTextureID = new class_2960("soulforge", "textures/ui/magic/style_5.png");
            context.method_25290(styleTextureID, left + 3, top - 20, 0.0f, 0.0f, 15, 15, 15, 15);
        } else {
            class_2960 styleTextureID = new class_2960("soulforge", "textures/ui/forg.png");
            context.method_25290(styleTextureID, left + 3, top - 20, 0.0f, 0.0f, 15, 15, 15, 15);
        }
    }

    public void renderMagicBALLS(class_332 context) {
        class_310 client = class_310.method_1551();
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)client.field_1724);
        int magic = (int)playerSoul.getMagic();
        int y = client.method_22683().method_4502();
        for (int i = 0; i < 10; ++i) {
            class_2960 texture;
            String traitName = playerSoul.getTraitCount() == 1 ? playerSoul.getTrait(0).getName().toLowerCase() : (i < 5 ? playerSoul.getTrait(0) : playerSoul.getTrait(1)).getName().toLowerCase();
            if (magic < (i + 1) * 10 && magic >= i * 10) {
                texture = new class_2960("soulforge", "textures/ui/magic/" + traitName + "/magic_" + magic % 10 + ".png");
                context.method_25290(texture, 5, y - 30 - i * 14, 0.0f, 0.0f, 12, 12, 12, 12);
                continue;
            }
            if (magic < (i + 1) * 10) {
                texture = new class_2960("soulforge", "textures/ui/magic/" + traitName + "/magic_0.png");
                context.method_25290(texture, 5, y - 30 - i * 14, 0.0f, 0.0f, 12, 12, 12, 12);
                continue;
            }
            texture = new class_2960("soulforge", "textures/ui/magic/" + traitName + "/magic_10.png");
            context.method_25290(texture, 5, y - 30 - i * 14, 0.0f, 0.0f, 12, 12, 12, 12);
        }
    }
}

