/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.client.ui;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.ability.ToggleableAbilityBase;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.WorldComponent;
import com.pulsar.soulforge.data.AbilityLayout;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.Constants;
import com.pulsar.soulforge.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_7923;

public class SoulScreen
extends class_437 {
    public final class_437 parent;
    public int x;
    public int y;
    private AbilityBase selectedAbility = null;
    private class_1299<?> selectedEntity = null;
    private final class_2960 abilityTexture = new class_2960("soulforge", "textures/ui/ability_screen.png");
    private final class_2960 soulTexture = new class_2960("soulforge", "textures/ui/soul_screen.png");
    private final class_2960 killsTexture = new class_2960("soulforge", "textures/ui/kills_screen.png");
    private int page = 0;
    private int modeIndex = 0;
    private List<class_339> widgets = new ArrayList<class_339>();
    private List<class_3545<Traits.Mode, String>> modes = new ArrayList<class_3545<Traits.Mode, String>>();

    public SoulScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Soul Screen"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.x = this.field_22789 / 2 - 101;
        this.y = this.field_22790 / 2 - 92;
        this.updateWidgets();
    }

    /*
     * WARNING - void declaration
     */
    public void updateWidgets() {
        assert (this.field_22787 != null);
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)this.field_22787.field_1724);
        this.method_37067();
        this.widgets = new ArrayList<class_339>();
        if (this.page == 0) {
            this.widgets.add(new SlotWidget(8 + this.x, 6 + this.y, new class_1799((class_1935)SoulForgeItems.BRAVERY_HAMMER), () -> {
                this.page = 0;
                this.updateWidgets();
            }));
            this.widgets.add(new SlotWidget(37 + this.x, 9 + this.y, new class_1799((class_1935)SoulForgeItems.DETERMINATION_ARNICITE_HEART), () -> {
                this.page = 1;
                this.updateWidgets();
            }));
        } else if (this.page == 1) {
            this.widgets.add(new SlotWidget(8 + this.x, 9 + this.y, new class_1799((class_1935)SoulForgeItems.BRAVERY_HAMMER), () -> {
                this.page = 0;
                this.updateWidgets();
            }));
            this.widgets.add(new SlotWidget(37 + this.x, 6 + this.y, new class_1799((class_1935)SoulForgeItems.DETERMINATION_ARNICITE_HEART), () -> {
                this.page = 1;
                this.updateWidgets();
            }));
        }
        this.modes = new ArrayList<class_3545<Traits.Mode, String>>();
        if (!playerSoul.hasTrait(Traits.spite)) {
            if (playerSoul.getTraits().isEmpty()) {
                return;
            }
            this.modes.add((class_3545<Traits.Mode, String>)new class_3545((Object)Traits.Mode.TRAIT, (Object)playerSoul.getTrait(0).getName()));
            if (playerSoul.getTraitCount() == 2) {
                this.modes.add((class_3545<Traits.Mode, String>)new class_3545((Object)Traits.Mode.TRAIT, (Object)playerSoul.getTrait(1).getName()));
            }
        } else {
            for (TraitBase traitBase : Traits.all()) {
                this.modes.add((class_3545<Traits.Mode, String>)new class_3545((Object)Traits.Mode.TRAIT, (Object)traitBase.getName()));
            }
        }
        boolean hasPassives = false;
        for (AbilityBase abilityBase : playerSoul.getAbilities()) {
            if (abilityBase.getType() != AbilityType.PASSIVE) continue;
            hasPassives = true;
        }
        if (!Constants.getDualTraitAbilities(playerSoul.getTraits()).isEmpty()) {
            this.modes.add((class_3545<Traits.Mode, String>)new class_3545((Object)Traits.Mode.DUALS, (Object)""));
        }
        if (hasPassives) {
            this.modes.add((class_3545<Traits.Mode, String>)new class_3545((Object)Traits.Mode.PASSIVES, (Object)""));
        }
        if (Utils.hasHate((class_1309)this.field_22787.field_1724)) {
            this.modes.add((class_3545<Traits.Mode, String>)new class_3545((Object)Traits.Mode.HATE, (Object)""));
        }
        if (playerSoul.hasTrait(Traits.spite)) {
            this.modes.add((class_3545<Traits.Mode, String>)new class_3545((Object)Traits.Mode.SPECIAL, (Object)""));
        }
        if (this.page == 0) {
            this.widgets.add(new ClickableTextureWidget(42 + this.x, 35 + this.y, 7, 11, new class_2960("soulforge", "textures/ui/button_left.png"), mouseButton -> {
                this.modeIndex = (this.modeIndex - 1 + this.modes.size()) % this.modes.size();
                this.updateWidgets();
            }, (class_2561)class_2561.method_43470((String)((String)this.modes.get((this.modeIndex - 1 + this.modes.size()) % this.modes.size()).method_15441()))));
            this.widgets.add(new ClickableTextureWidget(146 + this.x, 35 + this.y, 7, 11, new class_2960("soulforge", "textures/ui/button_right.png"), mouseButton -> {
                this.modeIndex = (this.modeIndex + 1) % this.modes.size();
                this.updateWidgets();
            }, (class_2561)class_2561.method_43470((String)((String)this.modes.get((this.modeIndex + 1) % this.modes.size()).method_15441()))));
            boolean bl = false;
            for (AbilityBase ability : Traits.getModeAbilities((Traits.Mode)((Object)this.modes.get(this.modeIndex).method_15442()), (String)this.modes.get(this.modeIndex).method_15441(), playerSoul)) {
                void var3_7;
                class_2960 id = ability instanceof ToggleableAbilityBase ? new class_2960(ability.getID().method_12836(), "textures/ui/ability_icon/" + ability.getID().method_12832() + "_on.png") : new class_2960("soulforge", "textures/ui/ability_icon/" + ability.getID().method_12832() + ".png");
                ClickableTextureWidget button2 = new ClickableTextureWidget(17 + var3_7 % 9 * 18 + this.x, 51 + class_3532.method_15375((float)((float)var3_7 / 9.0f)) * 18 + this.y, 18, 18, id, mouseButton -> {
                    this.selectedAbility = ability;
                    this.updateWidgets();
                }, ability.getLocalizedText());
                if (this.selectedAbility != null && ability.getID() == this.selectedAbility.getID()) {
                    button2.selected = true;
                }
                this.widgets.add(button2);
                ++var3_7;
            }
            boolean bl2 = false;
            for (AbilityLayout.AbilityRow row : playerSoul.getAbilityLayout().rows) {
                void var4_13;
                int slotNum = 0;
                for (AbilityBase ability : row.abilities) {
                    if (ability != null) {
                        class_2960 id = ability instanceof ToggleableAbilityBase ? new class_2960(ability.getID().method_12836(), "textures/ui/ability_icon/" + ability.getID().method_12832() + "_on.png") : new class_2960("soulforge", "textures/ui/ability_icon/" + ability.getID().method_12832() + ".png");
                        void finalRow = var4_13;
                        int finalSlot = slotNum;
                        ClickableTextureWidget button3 = new ClickableTextureWidget(17 + slotNum * 18 + this.x, 101 + var4_13 * 18 + this.y, 18, 18, id, arg_0 -> this.lambda$updateWidgets$7(playerSoul, (int)finalRow, finalSlot, arg_0), ability.getLocalizedText());
                        this.widgets.add(button3);
                    } else {
                        void finalRow = var4_13;
                        int finalSlot = slotNum;
                        ClickableTextureWidget button4 = new ClickableTextureWidget(17 + slotNum * 18 + this.x, 101 + var4_13 * 18 + this.y, 18, 18, null, arg_0 -> this.lambda$updateWidgets$8(playerSoul, (int)finalRow, finalSlot, arg_0));
                        this.widgets.add(button4);
                    }
                    ++slotNum;
                }
                ++var4_13;
            }
        } else if (this.page == 2) {
            ButtonListWidget buttonListWidget = new ButtonListWidget(class_310.method_1551(), this.x + 9, this.y + 43, 40, 130, 14);
            boolean bl = false;
            for (Map.Entry<String, Integer> entry : playerSoul.getMonsterSouls().entrySet()) {
                void var4_15;
                class_2960 typeId = class_2960.method_12829((String)entry.getKey());
                if (!class_7923.field_41177.method_10250(typeId)) continue;
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(typeId);
                class_4185 buttonWidget = class_4185.method_46430((class_2561)class_2561.method_43471((String)entityType.method_5882()), button -> {
                    this.selectedEntity = entityType;
                    this.updateWidgets();
                }).method_46434(this.x + 9, this.y + 43 + 14 * var4_15, 40, 14).method_46431();
                buttonListWidget.addButton(buttonWidget);
                ++var4_15;
            }
        }
        for (class_339 class_3392 : this.widgets) {
            this.method_25429((class_364)class_3392);
            this.method_37063((class_364)class_3392);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        assert (this.field_22787 != null);
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)this.field_22787.field_1724);
        if (this.page == 0) {
            context.method_25293(this.abilityTexture, this.x, this.y, 201, 184, 0.0f, 0.0f, 201, 184, 201, 184);
            context.method_25300(this.field_22793, this.modes.get(this.modeIndex).method_15442() == Traits.Mode.TRAIT ? (String)this.modes.get(this.modeIndex).method_15441() : ((Traits.Mode)((Object)this.modes.get(this.modeIndex).method_15442())).name(), 97 + this.x, 37 + this.y, 0xFFFFFF);
        } else if (this.page == 1) {
            context.method_25293(this.soulTexture, this.x, this.y, 201, 184, 0.0f, 0.0f, 201, 184, 201, 184);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Trait: ").method_10852(Utils.getTraitText(playerSoul)), 100 + this.x, 50 + this.y, 0xFFFFFF);
            int offset = 60;
            context.method_25300(this.field_22793, "LV: " + playerSoul.getLV(), 100 + this.x, offset + this.y, 0xFFFFFF);
            context.method_25300(this.field_22793, "ELV: " + playerSoul.getEffectiveLV(), 100 + this.x, (offset += 10) + this.y, 0xFFFFFF);
            context.method_25300(this.field_22793, "EXP: " + playerSoul.getEXP(), 100 + this.x, (offset += 10) + this.y, 0xFFFFFF);
            offset += 10;
            if (playerSoul.getLV() < 20) {
                context.method_25300(this.field_22793, "EXP until next LV: ", 100 + this.x, offset + this.y, 0xFFFFFF);
                context.method_25300(this.field_22793, String.valueOf(playerSoul.getExpRequirement()), 100 + this.x, (offset += 10) + this.y, 0xFFFFFF);
                offset += 10;
            }
            context.method_25300(this.field_22793, "Power: " + (playerSoul.isPure() || playerSoul.hasTrait(Traits.determination) ? "Pure" : (playerSoul.isStrong() ? "Strong" : "Normal")), 100 + this.x, offset + this.y, 0xFFFFFF);
            context.method_25300(this.field_22793, playerSoul.getAbilities().size() + " Total Abilities", 100 + this.x, (offset += 10) + this.y, 0xFFFFFF);
            context.method_25300(this.field_22793, "Magic Maximum: " + playerSoul.getMagicMax(), 100 + this.x, (offset += 10) + this.y, 0xFFFFFF);
            offset += 10;
            if (Utils.isInverted(playerSoul)) {
                context.method_25300(this.field_22793, "Reserves: " + playerSoul.getMagicGauge() + " / " + playerSoul.getMagicGaugeMax(), 100 + this.x, offset + this.y, 0xFFFFFF);
                offset += 10;
            }
            int totalMonsterSouls = playerSoul.getMonsterSouls().values().stream().mapToInt(a -> a).sum();
            int totalPlayerSouls = playerSoul.getPlayerSouls().values().stream().mapToInt(a -> a).sum();
            context.method_25300(this.field_22793, "Monster Souls: " + totalMonsterSouls, 100 + this.x, offset + this.y, 0xFFFFFF);
            context.method_25300(this.field_22793, "Player Souls: " + totalPlayerSouls, 100 + this.x, (offset += 10) + this.y, 0xFFFFFF);
            offset += 10;
        } else if (this.page == 2) {
            class_1297 drawnEntity;
            context.method_25293(this.killsTexture, this.x, this.y, 201, 184, 0.0f, 0.0f, 201, 184, 201, 184);
            if (this.selectedEntity != null && (drawnEntity = this.selectedEntity.method_5883((class_1937)this.field_22787.field_1687)) instanceof class_1309) {
                class_1309 living = (class_1309)drawnEntity;
                float i = this.x + 140;
                float j = this.y + 60;
                class_490.method_2486((class_332)context, (int)(this.x + 140), (int)(this.y + 45), (int)30, (float)i, (float)j, (class_1309)living);
                context.method_27534(this.field_22793, this.selectedAbility.getLocalizedText(), this.x + 97, this.y + 44, 0xFFFFFF);
                WorldComponent worldComponent = SoulForge.getWorldComponent((class_1937)this.field_22787.field_1687);
                float damageExpMultiplier = Utils.getEntityExpMultiplier(living) * worldComponent.getExpMultiplier() * Utils.getPlayerKillCountExpMultiplier(living, (class_1657)this.field_22787.field_1724);
                context.method_25300(this.field_22793, "EXP Multiplier: " + String.format("%.02f ", Float.valueOf(damageExpMultiplier)), this.x + 97, this.y + 56, 0xFFFFFF);
                context.method_25300(this.field_22793, "Kill EXP: " + Utils.getKillExp(living, (class_1657)this.field_22787.field_1724), this.x + 97, this.y + 68, 0xFFFFFF);
            }
        }
        for (class_339 widget : this.widgets) {
            widget.method_25394(context, mouseX, mouseY, delta);
        }
        int i = 0;
        if (this.selectedAbility != null && this.page == 0) {
            for (AbilityBase ability : Traits.getModeAbilities((Traits.Mode)((Object)this.modes.get(this.modeIndex).method_15442()), (String)this.modes.get(this.modeIndex).method_15441(), playerSoul)) {
                if (ability.getID().equals((Object)this.selectedAbility.getID())) {
                    int x = 17 + i % 9 * 18 + this.x;
                    int y = 51 + class_3532.method_15375((float)((float)i / 9.0f)) * 18 + this.y;
                    context.method_49601(x, y, 18, 18, -16711936);
                    context.method_49601(x + 1, y + 1, 16, 16, -16711936);
                }
                ++i;
            }
        }
    }

    private int getPageOfAbility(AbilityBase ability) {
        int i = 0;
        for (TraitBase trait : Traits.all()) {
            ++i;
            List<AbilityBase> abilities = trait.getAbilities();
            abilities.sort(Comparator.comparingInt(AbilityBase::getLV));
            for (AbilityBase a : abilities) {
                ++i;
                if (!Objects.equals(a.getName(), ability.getName())) continue;
                return i;
            }
        }
        return 0;
    }

    public static class SlotWidget
    extends class_339 {
        public final class_1799 slotStack;
        public final PressAction pressAction;

        public SlotWidget(int x, int y, class_1799 slotStack, PressAction pressAction) {
            super(x, y, 18, 18, (class_2561)class_2561.method_43473());
            this.slotStack = slotStack;
            this.pressAction = pressAction;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_51427(this.slotStack, this.method_46426(), this.method_46427());
        }

        protected void method_47399(class_6382 builder) {
        }

        public void method_25348(double mouseX, double mouseY) {
            if (this.field_22762) {
                this.pressAction.onClick();
            }
        }

        public static interface PressAction {
            public void onClick();
        }
    }

    public static class ClickableTextureWidget
    extends class_339 {
        public class_2960 texture = null;
        public class_2960 hoveredTexture = null;
        public final PressAction pressAction;
        public boolean selected = false;

        public ClickableTextureWidget(int x, int y, int width, int height, class_2960 texture, class_2960 hoveredTexture, PressAction pressAction, class_2561 tooltip) {
            this(x, y, width, height, texture, hoveredTexture, pressAction);
            this.method_47400(class_7919.method_47407((class_2561)tooltip));
        }

        public ClickableTextureWidget(int x, int y, int width, int height, class_2960 texture, PressAction pressAction, class_2561 tooltip) {
            this(x, y, width, height, texture, pressAction);
            this.method_47400(class_7919.method_47407((class_2561)tooltip));
        }

        public ClickableTextureWidget(int x, int y, int width, int height, class_2960 texture, class_2960 hoveredTexture, PressAction pressAction) {
            this(x, y, width, height, texture, pressAction);
            this.hoveredTexture = hoveredTexture;
        }

        public ClickableTextureWidget(int x, int y, int width, int height, class_2960 texture, PressAction pressAction) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.texture = texture;
            this.pressAction = pressAction;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            if (this.texture != null && !this.field_22762) {
                context.method_25293(this.texture, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
            } else if (this.field_22762) {
                if (this.hoveredTexture == null && this.texture != null) {
                    context.method_25293(this.texture, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
                } else if (this.hoveredTexture != null) {
                    context.method_25293(this.hoveredTexture, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
                }
            }
            if (this.selected) {
                context.method_25294(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0);
                context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0);
                context.method_49601(this.method_46426() + 1, this.method_46427() + 1, this.method_25368() - 2, this.method_25364() - 2, 0);
            }
        }

        protected void method_47399(class_6382 builder) {
        }

        public void onClick(int button) {
            if (this.field_22762) {
                this.pressAction.onClick(button);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean bl = this.method_25361(mouseX, mouseY);
            if (bl) {
                this.method_25354(class_310.method_1551().method_1483());
                this.onClick(button);
                return true;
            }
            return false;
        }

        public static interface PressAction {
            public void onClick(int var1);
        }
    }

    public static class ButtonListWidget
    extends class_350<ButtonEntry> {
        public ButtonListWidget(class_310 client, int left, int top, int width, int height, int itemHeight) {
            super(client, width, height, top, top + height, itemHeight);
            SoulForge.LOGGER.info("top: {}, bottom: {}, left: {}, right: {}", new Object[]{this.field_19085, this.field_19086, this.field_19088, this.field_19087});
        }

        public void addButton(class_4185 button) {
            this.method_25321(new ButtonEntry(button));
        }

        public void method_37020(class_6382 builder) {
        }

        public static class ButtonEntry
        extends class_350.class_351<ButtonEntry> {
            private final class_4185 buttonWidget;

            public ButtonEntry(class_4185 buttonWidget) {
                this.buttonWidget = buttonWidget;
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                this.buttonWidget.method_25394(context, mouseX, mouseY, tickDelta);
                SoulForge.LOGGER.info("button x: {}, button y: {}", (Object)this.buttonWidget.method_46426(), (Object)this.buttonWidget.method_46427());
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                return this.buttonWidget.method_25402(mouseX, mouseY, button);
            }
        }
    }
}

