/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.client.ui;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.TemporaryModifierComponent;
import com.pulsar.soulforge.components.ValueComponent;
import com.pulsar.soulforge.util.CooldownDisplayEntry;
import com.pulsar.soulforge.util.Triplet;
import com.pulsar.soulforge.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class ValueHudOverlay
implements HudRenderCallback {
    public static HashMap<String, String> valueMappings = new HashMap(Map.ofEntries(Map.entry("stockpiles", "Stockpiles")));
    public static HashMap<String, Integer> valueDefaults = new HashMap(Map.ofEntries(Map.entry("stockpiles", 0)));
    public HashMap<UUID, ValueOverlayEntry> entries = new HashMap();
    public HashMap<class_2960, CooldownDisplayEntry> cooldowns = new HashMap();
    public HashMap<UUID, String> oldValues = new HashMap();
    public HashMap<UUID, class_1320> oldModifiers = new HashMap();
    float lastDelta = 0.0f;

    public void onHudRender(class_332 context, float tickDelta) {
        float delta = tickDelta - this.lastDelta;
        if (delta < 0.0f) {
            delta = tickDelta + 1.0f - this.lastDelta;
        }
        this.lastDelta = delta;
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            TemporaryModifierComponent modifiers;
            ValueComponent values = SoulForge.getValues((class_1309)player);
            if (values != null) {
                for (String string : valueMappings.keySet()) {
                    if (!values.hasInt(string) || values.getInt(string) == valueDefaults.get(string).intValue()) continue;
                    if (!this.oldValues.containsValue(string)) {
                        UUID uUID = UUID.randomUUID();
                        this.addEntry(uUID, (class_2561)class_2561.method_43470((String)valueMappings.get(string)).method_27693(": ").method_27693(String.valueOf(values.getInt(string))));
                        this.oldValues.put(uUID, string);
                        continue;
                    }
                    UUID uUID = Utils.getKeyByValue(this.oldValues, string);
                    this.entries.get((Object)uUID).text = class_2561.method_43470((String)valueMappings.get(string)).method_27693(": ").method_27693(String.valueOf(values.getInt(string)));
                }
                for (Map.Entry entry : Set.copyOf(this.oldValues.entrySet())) {
                    if (values.hasInt((String)entry.getValue())) continue;
                    this.oldValues.remove(entry.getKey());
                    this.removeEntry((UUID)entry.getKey());
                }
            }
            if ((modifiers = SoulForge.getTemporaryModifiers((class_1309)player)) != null) {
                for (Triplet<class_1322, class_1320, Float> triplet : modifiers.getModifiers()) {
                    class_5250 text = class_2561.method_43471((String)triplet.getSecond().method_26830()).method_27693(": ");
                    class_1322.class_1323 operation = triplet.getFirst().method_6182();
                    if (operation == class_1322.class_1323.field_6328) {
                        text.method_27693("+").method_27693(String.valueOf(triplet.getFirst().method_6186()));
                    }
                    if (operation == class_1322.class_1323.field_6330) {
                        text.method_27693("x").method_27693(String.valueOf(1.0 + triplet.getFirst().method_6186()));
                    }
                    if (operation == class_1322.class_1323.field_6331) {
                        text.method_27693("x").method_27693(String.valueOf(1.0 + triplet.getFirst().method_6186())).method_27693("%");
                    }
                    if (!this.oldModifiers.containsKey(triplet.getFirst().method_6189())) {
                        this.addEntry(triplet.getFirst().method_6189(), (class_2561)text);
                        this.oldModifiers.put(triplet.getFirst().method_6189(), triplet.getSecond());
                        continue;
                    }
                    this.entries.get((Object)triplet.getFirst().method_6189()).text = text;
                }
                for (Map.Entry<UUID, class_1320> entry : Set.copyOf(this.oldModifiers.entrySet())) {
                    if (modifiers.getModifier(entry.getValue(), entry.getKey()) == null) continue;
                    this.oldModifiers.remove(entry.getKey());
                    this.removeEntry(entry.getKey());
                }
            }
            if (!class_310.method_1551().field_1690.field_1866) {
                this.cooldowns = new HashMap();
                SoulComponent soulComponent = SoulForge.getPlayerSoul((class_1657)player);
                for (AbilityBase ability : soulComponent.getActiveAbilities()) {
                    CooldownDisplayEntry entry;
                    if (!ability.getCooldownEntry().isPresent() || !((entry = ability.getCooldownEntry().get()).getPercent() > 0.0f)) continue;
                    this.cooldowns.put(entry.id, entry);
                }
                if (!this.cooldowns.isEmpty()) {
                    List<CooldownDisplayEntry> list = List.copyOf(this.cooldowns.values());
                    int cooldownCount = this.cooldowns.size();
                    int rowCount = Math.max((int)Math.floor(Math.sqrt(1.5f * (float)cooldownCount) - 1.0), 1);
                    int colCount = (int)Math.ceil((float)cooldownCount / (float)rowCount);
                    for (int y = 0; y < rowCount; ++y) {
                        for (int x = 0; x < colCount; ++x) {
                            int index = y * colCount + x;
                            if (index >= this.cooldowns.size()) continue;
                            CooldownDisplayEntry cooldownDisplay = list.get(index);
                            cooldownDisplay.render(context, 60 * x + 35, 35 * (y + 1), 12);
                        }
                    }
                }
            }
        }
        for (ValueOverlayEntry entry : this.entries.values()) {
            if (entry.lastPos != entry.pos) {
                entry.moveTimer += delta;
                if (entry.moveTimer >= 1.5f) {
                    entry.lastPos = entry.pos;
                    entry.moveTimer = 0.0f;
                }
            }
            ValueHudOverlay.drawValueEntry(context, entry);
        }
    }

    public void addEntry(UUID id, class_2561 text) {
        ValueOverlayEntry entry = new ValueOverlayEntry(id, text, 0);
        for (ValueOverlayEntry other : this.entries.values()) {
            ++other.pos;
        }
        this.entries.put(id, entry);
    }

    public void removeEntry(UUID id) {
        int removedPos = this.entries.get((Object)id).pos;
        for (ValueOverlayEntry other : this.entries.values()) {
            if (removedPos <= other.pos) continue;
            --other.pos;
        }
    }

    public static void drawValueEntry(class_332 context, ValueOverlayEntry entry) {
        class_327 renderer = class_310.method_1551().field_1772;
        int windowWidth = class_310.method_1551().method_22683().method_4486();
        int windowHeight = class_310.method_1551().method_22683().method_4486();
        int width = renderer.method_27525((class_5348)entry.text);
        float moveDelta = class_3532.method_15374((float)((float)(Math.PI * (double)(2.0f * entry.moveTimer / 3.0f - 0.5f)) + 0.1f)) / 2.0f;
        if (entry.moveTimer < 0.0f) {
            moveDelta = 0.0f;
        }
        if (entry.moveTimer > 1.5f) {
            moveDelta = 1.0f;
        }
        float pos = class_3532.method_37166((float)moveDelta, (float)((float)(entry.lastPos + 1) * 15.0f), (float)((float)(entry.pos + 1) * 15.0f));
        context.method_27535(renderer, entry.text, windowWidth - width - 10, (int)pos, 0xFFFFFF);
    }

    public static class ValueOverlayEntry {
        public UUID id;
        public class_2561 text;
        public int lastPos;
        public int pos;
        public float moveTimer = 0.0f;

        public ValueOverlayEntry(UUID id, class_2561 text, int pos) {
            this.id = id;
            this.text = text;
            this.lastPos = pos;
            this.pos = pos;
        }
    }
}

