/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.pulsar.soulforge.ai.HATEBaseAI;
import com.pulsar.soulforge.ai.NetworkSerializer;
import com.pulsar.soulforge.util.Utils;
import java.io.File;
import java.nio.file.Path;
import java.text.DecimalFormat;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5218;

public class HateCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"hate").requires(source -> source.method_9259(4) && Utils.canAccessInverteds(source))).then(LiteralArgumentBuilder.literal((String)"set").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"entity", (ArgumentType)class_2186.method_9309()).then(RequiredArgumentBuilder.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(context -> {
            if (!Utils.canAccessInverteds((CommandContext<class_2168>)context)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Prohibited.").method_10862(class_2583.field_24360.method_27704(new class_2960("alt"))));
                return 1;
            }
            class_1297 target = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (target instanceof class_1309) {
                class_1309 living = (class_1309)target;
                Utils.setHate(living, FloatArgumentType.getFloat((CommandContext)context, (String)"amount"));
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(2);
                String hatePercent = df.format(Utils.getHate(living));
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Set ").method_10852(target.method_5477()).method_27693("'s HATE to " + hatePercent));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"hasHate").then((ArgumentBuilder)RequiredArgumentBuilder.argument((String)"hasHate", (ArgumentType)BoolArgumentType.bool()))).executes(context -> {
            if (!Utils.canAccessInverteds((CommandContext<class_2168>)context)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Prohibited.").method_10862(class_2583.field_24360.method_27704(new class_2960("alt"))));
                return 1;
            }
            class_1297 target = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (target instanceof class_1309) {
                class_1309 living = (class_1309)target;
                boolean hasHate = BoolArgumentType.getBool((CommandContext)context, (String)"hasHate");
                Utils.setHasHate(living, hasHate);
                if (!hasHate) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Removed ").method_10852(target.method_5477()).method_27693("'s HATE"));
                } else {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Gave ").method_10852(target.method_5477()).method_27693(" HATE"));
                }
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"ai").requires(class_2168::method_43737)).then(LiteralArgumentBuilder.literal((String)"predict").executes(context -> {
            if (!Utils.canAccessInverteds((CommandContext<class_2168>)context)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Prohibited.").method_10862(class_2583.field_24360.method_27704(new class_2960("alt"))));
                return 1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            double[] outputs = HATEBaseAI.getOutputs((class_1309)player);
            HATEBaseAI.AiResult result = HATEBaseAI.getResult(outputs);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("AI result is " + String.valueOf((Object)result))));
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Results were:"));
            for (int i = 0; i < outputs.length; ++i) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Output " + i + ": " + outputs[i])));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"train").then(RequiredArgumentBuilder.argument((String)"values", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            String[] strValues = StringArgumentType.getString((CommandContext)context, (String)"values").split(" ");
            double[] expected = new double[strValues.length];
            for (int i = 0; i < strValues.length; ++i) {
                expected[i] = class_3532.method_15350((double)Double.parseDouble(strValues[i]), (double)0.0, (double)1.0);
            }
            HATEBaseAI.train((class_1309)player, expected);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"example").then(RequiredArgumentBuilder.argument((String)"values", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            String[] strValues = StringArgumentType.getString((CommandContext)context, (String)"values").split(" ");
            double[] expected = new double[strValues.length];
            for (int i = 0; i < strValues.length; ++i) {
                expected[i] = class_3532.method_15350((double)Double.parseDouble(strValues[i]), (double)0.0, (double)1.0);
            }
            double[] inputs = HATEBaseAI.getInputsFromEntity((class_1309)player);
            Path path = ((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188);
            String strPath = path.toString() + "\\networks";
            File directory = new File(strPath);
            if (!directory.exists()) {
                directory.mkdir();
            }
            strPath = strPath + "\\training_data.json";
            NetworkSerializer.writeTrainingData(strPath, inputs, expected);
            return 1;
        }))))).then(LiteralArgumentBuilder.literal((String)"inputs").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null) {
                double[] inputs = HATEBaseAI.getInputsFromEntity((class_1309)player);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"AI inputs:"));
                for (int i = 0; i < inputs.length; ++i) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Input " + i + ": " + inputs[i])));
                }
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"save").executes(context -> {
            Path path = ((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188);
            String strPath = path.toString() + "\\networks";
            File directory = new File(strPath);
            if (!directory.exists()) {
                directory.mkdir();
            }
            strPath = strPath + "\\hate_base.souljafrog";
            NetworkSerializer.writeNetworkToFile(HATEBaseAI.network, strPath);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Network saved!"));
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"load").executes(context -> {
            File file;
            Path path = ((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188);
            String strPath = path.toString() + "\\networks";
            File directory = new File(strPath);
            if (!directory.exists()) {
                directory.mkdir();
            }
            if ((file = new File(strPath = strPath + "\\hate_base.souljafrog")).exists()) {
                HATEBaseAI.network = NetworkSerializer.readNetworkFromFile(strPath);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Network loaded!"));
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Network file does not exist."));
            }
            return 1;
        }))));
    }
}

