/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class TraitArgumentType
implements ArgumentType<TraitBase> {
    public static final DynamicCommandExceptionType TRAIT_NOT_FOUND = new DynamicCommandExceptionType(o -> class_2561.method_43469((String)"commands.soulforge.trait_not_found", (Object[])new Object[]{o}));

    public static TraitArgumentType trait() {
        return new TraitArgumentType();
    }

    public TraitBase parse(StringReader stringReader) throws CommandSyntaxException {
        int argBeginning = stringReader.getCursor();
        if (!stringReader.canRead()) {
            stringReader.skip();
        }
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        String traitStr = stringReader.getString().substring(argBeginning, stringReader.getCursor());
        try {
            return Traits.get(traitStr);
        }
        catch (IllegalArgumentException e) {
            throw TRAIT_NOT_FOUND.create((Object)traitStr);
        }
    }

    public static TraitBase getTrait(CommandContext<class_2168> context, String argumentName) throws CommandSyntaxException {
        String str = (String)context.getArgument(argumentName, String.class);
        try {
            return Traits.get(str);
        }
        catch (IllegalArgumentException e) {
            throw TRAIT_NOT_FOUND.create((Object)str);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList<String> availableTraits = new ArrayList<String>();
        for (TraitBase trait : Traits.all()) {
            availableTraits.add(trait.getName());
        }
        return class_2172.method_9265(availableTraits, (SuggestionsBuilder)builder);
    }
}

