/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.compat.rei;

import com.pulsar.soulforge.block.SoulForgeBlocks;
import com.pulsar.soulforge.client.ui.SoulForgeScreen;
import com.pulsar.soulforge.compat.rei.SiphonCategory;
import com.pulsar.soulforge.compat.rei.SiphonDisplay;
import com.pulsar.soulforge.compat.rei.SoulForgeCategory;
import com.pulsar.soulforge.compat.rei.SoulForgeDisplay;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.recipe.SiphonRecipe;
import com.pulsar.soulforge.recipe.SoulForgeRecipe;
import com.pulsar.soulforge.recipe.SoulForgeRecipes;
import com.pulsar.soulforge.tag.SoulForgeTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class SoulForgeREIClientPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new SoulForgeCategory());
        registry.add((DisplayCategory)new SiphonCategory());
        registry.addWorkstations(SoulForgeCategory.SOUL_FORGE, new EntryStack[]{EntryStacks.of((class_1935)SoulForgeBlocks.SOUL_FORGE_BLOCK)});
        registry.addWorkstations(SiphonCategory.SIPHONING, new EntryStack[]{EntryStacks.of((class_1935)class_2246.field_16329)});
        registry.addWorkstations(SiphonCategory.SIPHONING, new EntryStack[]{EntryStacks.of((class_1935)SoulForgeItems.SIPHON_TEMPLATE)});
    }

    public void registerDisplays(final DisplayRegistry registry) {
        registry.registerRecipeFiller(SoulForgeRecipe.class, (class_3956)SoulForgeRecipe.Type.INSTANCE, SoulForgeDisplay::new);
        registry.registerDisplayGenerator(SiphonCategory.SIPHONING, (DynamicDisplayGenerator)new DynamicDisplayGenerator<SiphonDisplay>(){

            public Optional<List<SiphonDisplay>> getRecipeFor(EntryStack<?> entry) {
                return this.getMatchesOf(entry);
            }

            public Optional<List<SiphonDisplay>> getUsageFor(EntryStack<?> entry) {
                return this.getMatchesOf(entry);
            }

            public Optional<List<SiphonDisplay>> generate(ViewSearchBuilder builder) {
                return this.getMatchesOf(builder.getRecipesFor());
            }

            public Optional<List<SiphonDisplay>> getMatchesOf(@Nullable EntryStack<?> entry) {
                ArrayList<SiphonDisplay> displays = new ArrayList<SiphonDisplay>();
                List siphonRecipes = registry.getRecipeManager().method_30027(SoulForgeRecipes.SIPHON_RECIPE);
                for (SiphonRecipe recipe : siphonRecipes) {
                    if (entry != null) {
                        class_1799 stack;
                        Object object = entry.getValue();
                        if (!(object instanceof class_1799) || !(stack = (class_1799)object).method_31573(SoulForgeTags.SIPHONABLE) && !stack.method_31573(SoulForgeTags.ARTIFACT_SIPHONABLE)) continue;
                        EntryIngredient template = EntryIngredients.ofIngredient((class_1856)recipe.getTemplate());
                        EntryIngredient addition = EntryIngredients.ofIngredient((class_1856)recipe.getAddition());
                        EntryIngredient output = EntryIngredients.of((class_1799)recipe.getOutputFromInput(stack));
                        displays.add(new SiphonDisplay(List.of(template, EntryIngredients.of((class_1799)stack), addition), List.of(output)));
                        continue;
                    }
                    for (class_1799 validBase : recipe.getBase().method_8105()) {
                        EntryIngredient template = EntryIngredients.ofIngredient((class_1856)recipe.getTemplate());
                        EntryIngredient addition = EntryIngredients.ofIngredient((class_1856)recipe.getAddition());
                        EntryIngredient output = EntryIngredients.of((class_1799)recipe.getOutputFromInput(validBase));
                        displays.add(new SiphonDisplay(List.of(template, EntryIngredients.of((class_1799)validBase), addition), List.of(output)));
                    }
                }
                return Optional.of(displays);
            }

            public Optional<List<SiphonDisplay>> getMatchesOf(@Nullable List<EntryStack<?>> entries) {
                ArrayList<SiphonDisplay> displays = new ArrayList<SiphonDisplay>();
                List siphonRecipes = registry.getRecipeManager().method_30027(SoulForgeRecipes.SIPHON_RECIPE);
                for (SiphonRecipe recipe : siphonRecipes) {
                    if (entries != null) {
                        for (EntryStack entryStack : entries) {
                            class_1799 stack;
                            Object object = entryStack.getValue();
                            if (!(object instanceof class_1799) || !(stack = (class_1799)object).method_31573(SoulForgeTags.SIPHONABLE) && !stack.method_31573(SoulForgeTags.ARTIFACT_SIPHONABLE)) continue;
                            EntryIngredient template = EntryIngredients.ofIngredient((class_1856)recipe.getTemplate());
                            EntryIngredient addition = EntryIngredients.ofIngredient((class_1856)recipe.getAddition());
                            EntryIngredient output = EntryIngredients.of((class_1799)recipe.getOutputFromInput(stack));
                            displays.add(new SiphonDisplay(List.of(template, EntryIngredients.of((class_1799)stack), addition), List.of(output)));
                        }
                        continue;
                    }
                    for (class_1799 validBase : recipe.getBase().method_8105()) {
                        EntryIngredient template = EntryIngredients.ofIngredient((class_1856)recipe.getTemplate());
                        EntryIngredient addition = EntryIngredients.ofIngredient((class_1856)recipe.getAddition());
                        EntryIngredient output = EntryIngredients.of((class_1799)recipe.getOutputFromInput(validBase));
                        displays.add(new SiphonDisplay(List.of(template, EntryIngredients.of((class_1799)validBase), addition), List.of(output)));
                    }
                }
                if (displays.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(displays);
            }
        });
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(screen -> new Rectangle(93, 36, 13, 13), SoulForgeScreen.class, new CategoryIdentifier[]{SoulForgeCategory.SOUL_FORGE});
    }
}

