/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.components;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.Abilities;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.ability.SideEffectAbilityBase;
import com.pulsar.soulforge.ability.ToggleableAbilityBase;
import com.pulsar.soulforge.ability.determination.DeterminationPlatform;
import com.pulsar.soulforge.ability.duals.PerfectedAuraTechnique;
import com.pulsar.soulforge.ability.integrity.Platforms;
import com.pulsar.soulforge.advancement.SoulForgeCriterions;
import com.pulsar.soulforge.armor.PlatformBootsItem;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.EntityInitializer;
import com.pulsar.soulforge.components.TemporaryModifierComponent;
import com.pulsar.soulforge.components.ValueComponent;
import com.pulsar.soulforge.damage_type.SoulForgeDamageTypes;
import com.pulsar.soulforge.data.AbilityLayout;
import com.pulsar.soulforge.data.AbilityList;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.entity.BlastEntity;
import com.pulsar.soulforge.entity.DeterminationPlatformEntity;
import com.pulsar.soulforge.entity.IntegrityPlatformEntity;
import com.pulsar.soulforge.event.EventType;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.item.weapons.MagicSwordItem;
import com.pulsar.soulforge.networking.SoulForgeNetworking;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import com.pulsar.soulforge.tag.SoulForgeTags;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.ResetData;
import com.pulsar.soulforge.util.SpokenTextRenderer;
import com.pulsar.soulforge.util.Utils;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private ArrayList<TraitBase> traits = new ArrayList<TraitBase>(List.of(Traits.bravery, Traits.justice));
    private boolean strong = false;
    private boolean pure = false;
    private int lv = 1;
    private int exp = 0;
    private int style = 0;
    private int styleRank = 0;
    private int lastStyleIncrease = 0;
    private float magic = 0.0f;
    private float magicGauge = 0.0f;
    private AbilityList abilities = new AbilityList();
    private final class_1657 player;
    private class_1799 weapon = class_1799.field_8037;
    private int lastCastTime = 0;
    private HashMap<String, Integer> monsterSouls = new HashMap();
    private HashMap<String, Integer> playerSouls = new HashMap();
    private AbilityLayout abilityLayout = new AbilityLayout();
    private int abilityRow = 0;
    private int abilitySlot = 0;
    private boolean magicMode = false;
    private ResetData resetData = new ResetData();
    private class_3545<UUID, Integer> wormholeRequest = null;
    private class_1657 disguisedAs = null;
    private UUID disguisedAsID = null;
    private final SpokenTextRenderer spokenTextRenderer = new SpokenTextRenderer();
    private boolean initialized = false;
    private float manaRegenRate = 0.0f;
    private class_243 lastPos = class_243.field_1353;
    private static final class_1322 strongModifier = new class_1322(UUID.fromString("5390de41-a4a2-450c-be21-efd230c47fc9"), "strong", -0.5, class_1322.class_1323.field_6331);
    private static final class_1322 pureModifier = new class_1322(UUID.fromString("ac02d0d4-839f-4215-b6f0-142c45d8cd47"), "pure", 0.5, class_1322.class_1323.field_6328);
    private static final class_1322 shieldBreakModifier = new class_1322(UUID.fromString("a7fb97e3-f50c-48c0-8e32-3a7c0a4cc0f8"), "perseverance", 1.0, class_1322.class_1323.field_6331);

    public SoulComponent(class_1657 player) {
        this.player = player;
        this.lv = 1;
        this.exp = 0;
        this.style = 0;
        this.styleRank = 0;
        this.magic = 100.0f;
        this.initialized = false;
    }

    public static void sync(class_1657 player) {
        EntityInitializer.SOUL.sync((Object)player);
    }

    public TraitBase getTrait(int num) {
        return this.traits.get(num);
    }

    public List<TraitBase> getTraits() {
        return this.traits;
    }

    public boolean hasTrait(TraitBase trait) {
        return this.traits.stream().map(TraitBase::getName).anyMatch(trait.getName()::equals);
    }

    public int getTraitCount() {
        return this.traits.size();
    }

    public void setTrait(int num, TraitBase trait) {
        if (this.traits.size() >= num + 1) {
            this.traits.set(num, trait);
        } else if (num <= 1) {
            this.traits.add(trait);
        }
        if (num == 1 && trait == null) {
            this.traits = new ArrayList<TraitBase>(List.of(this.traits.get(0)));
        }
        this.abilityLayout = new AbilityLayout();
        for (AbilityBase ability : this.abilities.getActive()) {
            ability.end((class_3222)this.player);
        }
        if (this.pure) {
            this.resetData.addPure(this.traits.get(0));
        }
        if (this.traits.size() >= 2) {
            this.resetData.addDual(this.traits.get(0), this.traits.get(1));
        }
        this.updateAbilities();
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            SoulForgeCriterions.PLAYER_LV.trigger(serverPlayer, this.getLV());
            SoulForgeCriterions.PLAYER_TRAIT.trigger(serverPlayer, this);
            SoulForgeCriterions.PLAYER_SOUL.trigger(serverPlayer, this);
        }
        this.sync();
    }

    public void setTraits(List<TraitBase> traits) {
        this.traits = new ArrayList<TraitBase>(traits);
        this.abilityLayout = new AbilityLayout();
        for (AbilityBase ability : this.abilities.getActive()) {
            ability.end((class_3222)this.player);
        }
        if (this.pure) {
            this.resetData.addPure(traits.get(0));
        }
        if (traits.size() >= 2) {
            this.resetData.addDual(traits.get(0), traits.get(1));
        }
        this.updateAbilities();
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            SoulForgeCriterions.PLAYER_LV.trigger(serverPlayer, this.getLV());
            SoulForgeCriterions.PLAYER_TRAIT.trigger(serverPlayer, this);
            SoulForgeCriterions.PLAYER_SOUL.trigger(serverPlayer, this);
        }
        this.sync();
    }

    public void setResetValues(List<TraitBase> traits, boolean strong, boolean pure) {
        this.traits = new ArrayList<TraitBase>(traits);
        this.abilityLayout = new AbilityLayout();
        for (AbilityBase ability : this.abilities.getActive()) {
            ability.end((class_3222)this.player);
        }
        if (traits.size() >= 2) {
            this.resetData.addDual(traits.get(0), traits.get(1));
        }
        this.strong = strong;
        this.pure = pure;
        this.updateAbilities();
        this.sync();
    }

    public ResetData getResetData() {
        return this.resetData;
    }

    public void setResetData(ResetData resetData) {
        this.resetData = resetData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleEvent(EventType event) {
        Iterator<Object> iterator;
        boolean onTriple;
        boolean stacked;
        float cost;
        boolean hasIG;
        block24: {
            class_1657 class_16572 = this.player;
            if (!(class_16572 instanceof class_3222)) return;
            class_3222 serverPlayerEntity = (class_3222)class_16572;
            switch (event) {
                case FALL_IMMUNITY: {
                    if (!this.abilities.isActive("Launch")) return;
                    this.abilities.get("Launch").end(serverPlayerEntity);
                    return;
                }
                case SPAWN_PLATFORM: {
                    if (this.player.method_7325()) {
                        return;
                    }
                    boolean hasDT = false;
                    hasIG = false;
                    for (AbilityBase ability : this.abilities.getActive()) {
                        if (ability instanceof DeterminationPlatform) {
                            SoulForgeCriterions.CAST_ABILITY.trigger((class_3222)this.player, ability);
                            hasDT = true;
                        }
                        if (!(ability instanceof Platforms)) continue;
                        SoulForgeCriterions.CAST_ABILITY.trigger((class_3222)this.player, ability);
                        hasIG = true;
                    }
                    float f = cost = hasIG ? 5.0f : 10.0f;
                    if (this.player.method_5996(SoulForgeAttributes.MAGIC_COST) != null) {
                        cost *= (float)this.player.method_26825(SoulForgeAttributes.MAGIC_COST);
                    }
                    if (this.getMagic() >= cost && (hasDT || hasIG)) {
                        stacked = false;
                        onTriple = false;
                        class_238 box = new class_238(this.player.method_19538().method_1023(2.0, 2.0, 2.0), this.player.method_19538().method_1031(2.0, 2.0, 2.0));
                        iterator = this.player.method_5770().method_8335((class_1297)this.player, box).iterator();
                        break block24;
                    } else {
                        if (hasDT) return;
                        if (hasIG) return;
                        class_1799 boots = this.player.method_6118(class_1304.field_6166);
                        if (!boots.method_31574(SoulForgeItems.PLATFORM_BOOTS)) return;
                        PlatformBootsItem platformBoots = (PlatformBootsItem)SoulForgeItems.PLATFORM_BOOTS;
                        if (platformBoots.getCharge(boots) < 5) return;
                        boolean stacked2 = false;
                        boolean onTriple2 = false;
                        class_238 box = new class_238(this.player.method_19538().method_1023(2.0, 2.0, 2.0), this.player.method_19538().method_1031(2.0, 2.0, 2.0));
                        for (class_1297 entity : this.player.method_5770().method_8335((class_1297)this.player, box)) {
                            if (!entity.method_5829().method_994(this.player.method_5829().method_989(0.0, -0.5, 0.0)) || !(entity instanceof IntegrityPlatformEntity)) continue;
                            IntegrityPlatformEntity platform = (IntegrityPlatformEntity)entity;
                            if (platform.getStack() < 2) {
                                platform.setStack(platform.getStack() + 1);
                                stacked2 = true;
                                break;
                            }
                            onTriple2 = true;
                        }
                        if (stacked2) {
                            platformBoots.decreaseCharge(boots, 5);
                            this.resetLastCastTime();
                        }
                        if (onTriple2) {
                            return;
                        }
                        if (stacked2) return;
                        if (this.player.method_24828()) return;
                        new Platforms().spawn(this.player);
                        platformBoots.decreaseCharge(boots, 5);
                        return;
                    }
                }
            }
            return;
        }
        while (iterator.hasNext()) {
            class_1297 platform;
            class_1297 entity = (class_1297)iterator.next();
            if (!entity.method_5829().method_994(this.player.method_5829().method_989(0.0, -0.5, 0.0))) continue;
            if (entity instanceof DeterminationPlatformEntity) {
                platform = (DeterminationPlatformEntity)entity;
                if (platform.getStack() < 2) {
                    platform.setStack(platform.getStack() + 1);
                    stacked = true;
                    break;
                }
                onTriple = true;
            }
            if (!(entity instanceof IntegrityPlatformEntity)) continue;
            platform = (IntegrityPlatformEntity)entity;
            if (platform.getStack() < 2) {
                platform.setStack(platform.getStack() + 1);
                stacked = true;
                break;
            }
            onTriple = true;
        }
        if (stacked) {
            this.tryConsumeMagic(cost);
        }
        if (onTriple) {
            return;
        }
        if (stacked) return;
        if (this.player.method_24828()) return;
        if (hasIG) {
            for (AbilityBase ability : this.abilities.getActive()) {
                if (!(ability instanceof Platforms)) continue;
                ((Platforms)ability).spawn(this.player);
                break;
            }
        } else {
            for (AbilityBase ability : this.abilities.getActive()) {
                if (!(ability instanceof DeterminationPlatform)) continue;
                ((DeterminationPlatform)ability).spawn(this.player);
                break;
            }
        }
        this.tryConsumeMagic(cost);
    }

    public int getLV() {
        return this.lv;
    }

    public int getEffectiveLV() {
        float effLv = this.getLV();
        float multiplier = 1.0f;
        if (this.player != null && this.player.method_5996(SoulForgeAttributes.MAGIC_POWER) != null) {
            multiplier = (float)this.player.method_5996(SoulForgeAttributes.MAGIC_POWER).method_6194();
        }
        if (this.traits.contains(Traits.determination)) {
            multiplier += 0.1f * (float)this.getStyleRank();
        }
        if (Utils.isInverted(this)) {
            multiplier += 0.5f;
        }
        return class_3532.method_15375((float)(effLv * multiplier));
    }

    public void setLV(int lv) {
        this.lv = Math.min(Math.max(lv, 1), 20);
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            SoulForgeCriterions.PLAYER_LV.trigger(serverPlayer, this.getLV());
            SoulForgeCriterions.PLAYER_TRAIT.trigger(serverPlayer, this);
            SoulForgeCriterions.PLAYER_SOUL.trigger(serverPlayer, this);
        }
        this.updateAbilities();
        this.sync();
    }

    public int getEXP() {
        return this.exp;
    }

    public void setEXP(int exp) {
        class_1657 class_16572;
        this.exp = Math.max(exp, 0);
        int oldAbilityCount = Traits.getAbilities(this.player, this).size();
        boolean leveledUp = false;
        int expRequirement = this.getExpRequirement();
        while (this.exp >= expRequirement && expRequirement != -1) {
            this.exp -= expRequirement;
            ++this.lv;
            leveledUp = true;
            expRequirement = this.getExpRequirement();
        }
        int newAbilityCount = Traits.getAbilities(this.player, this).size();
        if (leveledUp && (class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            SoulForgeCriterions.PLAYER_LV.trigger(serverPlayer, this.getLV());
            SoulForgeCriterions.PLAYER_TRAIT.trigger(serverPlayer, this);
            SoulForgeCriterions.PLAYER_SOUL.trigger(serverPlayer, this);
            this.player.method_43496((class_2561)class_2561.method_43471((String)"soulforge.lv.increase").method_27693(String.valueOf(this.lv)));
            class_2540 buf = PacketByteBufs.create();
            buf.writeBoolean(false);
            buf.writeBoolean(true);
            buf.method_10814("Your LV has increased!");
            if (newAbilityCount <= oldAbilityCount) {
                buf.method_10814("");
            } else {
                buf.method_10814("Unlocked " + (newAbilityCount - oldAbilityCount) + " new abilities.");
            }
            ServerPlayNetworking.send((class_3222)((class_3222)this.player), (class_2960)SoulForgeNetworking.SHOW_TOAST, (class_2540)buf);
            this.player.method_37908().method_43129(null, (class_1297)this.player, SoulForgeSounds.UT_LEVEL_UP_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
        this.updateAbilities();
        this.sync();
    }

    public int getExpRequirement() {
        if (this.lv >= 20) {
            return -1;
        }
        return class_3532.method_15375((float)(10000.0f * ((float)this.lv / 20.0f) * ((float)this.lv / 20.0f)));
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
        while (this.style >= this.getStyleRequirement()) {
            this.style -= this.getStyleRequirement();
            ++this.styleRank;
        }
        this.lastStyleIncrease = this.player.field_6012;
    }

    public int getStyleRequirement() {
        return switch (this.styleRank) {
            case 0 -> 100;
            case 1 -> 250;
            case 2 -> 350;
            case 3, 4 -> 500;
            default -> 69420;
        };
    }

    public int getStyleRank() {
        return this.styleRank;
    }

    public void setStyleRank(int styleRank) {
        this.styleRank = class_3532.method_15340((int)styleRank, (int)0, (int)6);
        if (this.styleRank >= 5) {
            this.player.method_37908().method_8396(null, this.player.method_24515(), SoulForgeSounds.UT_CREATE_EVENT, class_3419.field_15250, 1.0f, 1.0f);
        } else if (this.styleRank > 0) {
            this.player.method_37908().method_8396(null, this.player.method_24515(), SoulForgeSounds.UT_A_GRAB_EVENT, class_3419.field_15250, 1.0f, 1.0f);
        }
        while (this.style >= this.getStyleRequirement()) {
            this.style -= this.getStyleRequirement();
            ++this.styleRank;
        }
        if (this.styleRank > 5) {
            this.player.method_43496((class_2561)class_2561.method_43470((String)"what sort of frog magic is this"));
        }
    }

    public float getMagic() {
        return this.magic;
    }

    public float getMagicMax() {
        return 100.0f;
    }

    public void setMagic(float magic) {
        float lastMagic = this.magic;
        this.magic = Math.min(Math.max(magic, 0.0f), this.getMagicMax());
    }

    public void addMagic(float magic) {
        float lastMagic = this.magic;
        this.magic = Math.min(Math.max(this.magic + magic, 0.0f), this.getMagicMax());
    }

    public boolean tryConsumeMagic(float magic) {
        if (this.magic < magic) {
            return false;
        }
        float lastMagic = this.magic;
        this.magic = Math.min(Math.max(this.magic - magic, 0.0f), this.getMagicMax());
        this.resetLastCastTime();
        return true;
    }

    public boolean tryConsumeMagic(float magic, boolean serverOnly) {
        if (serverOnly && this.player.method_37908().field_9236) {
            return false;
        }
        return this.tryConsumeMagic(magic);
    }

    public float getMagicGauge() {
        return this.magicGauge;
    }

    public float getMagicGaugeMax() {
        return 30000.0f;
    }

    public void setMagicGauge(float magicGauge) {
        this.magicGauge = Math.min(Math.max(magicGauge, 0.0f), this.getMagicGaugeMax());
    }

    public void addMagicGauge(float magic) {
        float lastMagic = this.magicGauge;
        this.magicGauge = Math.min(Math.max(this.magicGauge + magic, 0.0f), this.getMagicGaugeMax());
    }

    public boolean tryConsumeMagicGauge(float magic) {
        if (this.magicGauge < magic) {
            return false;
        }
        float lastMagic = this.magicGauge;
        this.magicGauge = Math.min(Math.max(this.magicGauge - magic, 0.0f), this.getMagicGaugeMax());
        this.resetLastCastTime();
        return true;
    }

    public boolean tryConsumeMagicGauge(float magic, boolean serverOnly) {
        if (serverOnly && this.player.method_37908().field_9236) {
            return false;
        }
        return this.tryConsumeMagicGauge(magic);
    }

    public List<AbilityBase> getAbilities() {
        return List.copyOf(this.abilities.getAll());
    }

    public List<AbilityBase> getActiveAbilities() {
        return List.copyOf(this.abilities.getActive());
    }

    public AbilityBase getAbility(String abilityName) {
        if (this.abilities.has(abilityName)) {
            return this.abilities.get(abilityName);
        }
        return null;
    }

    public boolean onCooldown(AbilityBase ability) {
        if (this.player == null) {
            return false;
        }
        return this.abilities.has(ability) && this.abilities.get(ability).getCooldownVal() > 0;
    }

    public boolean onCooldown(String abilityName) {
        return this.abilities.has(abilityName) && this.abilities.get(abilityName).getCooldownVal() > 0;
    }

    public float cooldownPercent(AbilityBase ability) {
        try {
            if (this.abilities.get(ability).getCooldownVal() == 0) {
                return 1.0f;
            }
            return class_3532.method_15363((float)(1.0f - (float)this.abilities.get(ability).getCooldownVal() / (float)this.abilities.get(ability).getCooldown()), (float)0.0f, (float)1.0f);
        }
        catch (NullPointerException e) {
            return 1.0f;
        }
    }

    public void setCooldown(AbilityBase ability, int cooldown) {
        if (this.abilities.get(ability).getCooldown() == 0) {
            return;
        }
        this.abilities.get(ability).setCooldownVal(cooldown);
    }

    public void setCooldown(String abilityName, int cooldown) {
        if (this.abilities.has(abilityName)) {
            if (this.abilities.get(abilityName).getCooldown() == 0) {
                return;
            }
            this.abilities.get(abilityName).setCooldownVal(cooldown);
        }
    }

    public void onDeath() {
        for (AbilityBase ability : this.abilities.getActive()) {
            ability.setActive(false);
            if (!(ability instanceof ToggleableAbilityBase)) continue;
            ToggleableAbilityBase toggleable = (ToggleableAbilityBase)ability;
            class_1657 class_16572 = this.player;
            if (!(class_16572 instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)class_16572;
            toggleable.end(serverPlayer);
        }
        this.magic = 100.0f;
        if (Utils.isInverted(this)) {
            this.magicGauge = 1000.0f;
        }
    }

    public int lastCastTime() {
        return this.lastCastTime;
    }

    public void resetLastCastTime() {
        this.lastCastTime = 0;
    }

    public void magicTick() {
        int styleTicks;
        class_1657 reapedBy;
        class_1657 drainedBy;
        SoulComponent playerSoul;
        int manaSicknessAmplifier = 0;
        float manaStartTime = 5.0f - (float)class_3532.method_15340((int)this.getStyleRank(), (int)0, (int)5);
        if (this.player.method_6059(SoulForgeEffects.MANA_SICKNESS)) {
            manaSicknessAmplifier = Objects.requireNonNull(this.player.method_6112(SoulForgeEffects.MANA_SICKNESS)).method_5578() + 1;
        }
        if ((double)((float)this.lastCastTime / 20.0f) > (double)(manaStartTime * (float)(manaSicknessAmplifier + 1)) / Math.ceil((float)this.lv / 5.0f)) {
            if (this.getMagic() < 100.0f) {
                float moveDist = (float)this.player.method_19538().method_1022(this.lastPos);
                if (this.lastCastTime % (60 - this.lv * 2) == 0 && moveDist < 0.01f || this.lastCastTime % (120 - this.lv * 4) == 0 && moveDist >= 0.01f && manaSicknessAmplifier < 4) {
                    this.manaRegenRate += 0.05f - (float)manaSicknessAmplifier / 80.0f;
                }
            }
        } else {
            this.manaRegenRate = 0.0f;
        }
        if (this.abilities.isActive("Perfected Aura Technique")) {
            try {
                if (((PerfectedAuraTechnique)this.abilities.get((String)"Perfected Aura Technique")).fullPower) {
                    this.manaRegenRate = 2.0f;
                }
            }
            catch (Exception moveDist) {
                // empty catch block
            }
        }
        ValueComponent values = SoulForge.getValues((class_1309)this.player);
        float tumorMultiplier = 1.0f;
        if (this.player.method_6059(SoulForgeEffects.MANA_TUMOR)) {
            class_1657 tumorOwner;
            class_1293 tumor = this.player.method_6112(SoulForgeEffects.MANA_TUMOR);
            if (tumor.method_5578() == 1) {
                tumorMultiplier = 0.9f;
            }
            if (tumor.method_5578() == 2) {
                tumorMultiplier = 0.75f;
            }
            if (values.hasUUID("TumorOwner") && (tumorOwner = this.player.method_37908().method_18470(values.getUUID("TumorOwner"))) != null) {
                playerSoul = SoulForge.getPlayerSoul(tumorOwner);
                playerSoul.addMagic(this.manaRegenRate * (1.0f - tumorMultiplier));
            }
        }
        float drainingMultiplier = 1.0f;
        if (values.hasUUID("DrainingField") && (drainedBy = this.player.method_37908().method_18470(values.getUUID("DrainingField"))) != null) {
            drainingMultiplier = 0.6666667f;
            playerSoul = SoulForge.getPlayerSoul(drainedBy);
            if (playerSoul.getMagic() >= 100.0f) {
                playerSoul.addMagicGauge(this.manaRegenRate * (1.0f - drainingMultiplier));
            } else {
                playerSoul.addMagic(this.manaRegenRate * (1.0f - drainingMultiplier));
            }
        }
        if (values.hasUUID("ReapingField") && values.hasFloat("ReapingFieldAmount") && (reapedBy = this.player.method_37908().method_18470(values.getUUID("ReapingField"))) != null) {
            drainingMultiplier = 1.0f - values.getFloat("ReapingFieldAmount");
            playerSoul = SoulForge.getPlayerSoul(reapedBy);
            if (playerSoul.getMagic() >= 100.0f) {
                playerSoul.addMagicGauge(this.manaRegenRate * (1.0f - drainingMultiplier));
            } else {
                playerSoul.addMagic(this.manaRegenRate * (1.0f - drainingMultiplier));
            }
        }
        float magicIncrease = this.manaRegenRate * tumorMultiplier * drainingMultiplier;
        if (Utils.isInverted(this)) {
            magicIncrease = Math.min(magicIncrease, this.magicGauge);
            this.magicGauge -= magicIncrease;
        }
        this.addMagic(magicIncrease);
        ++this.lastCastTime;
        this.lastPos = this.player.method_19538();
        if ((this.style > 0 || this.styleRank > 0) && (styleTicks = this.player.field_6012 - this.lastStyleIncrease) >= 140 && styleTicks % 10 == 0) {
            this.style = class_3532.method_15340((int)(this.style - this.getStyleRequirement() / 100), (int)0, (int)this.getStyleRequirement());
            if (this.style == 0 && this.styleRank > 0) {
                --this.styleRank;
                this.style = this.getStyleRequirement() - 1;
            }
        }
        if (this.player.method_6059(SoulForgeEffects.MANA_OVERLOAD)) {
            this.style = 0;
            this.styleRank = 0;
        }
    }

    public boolean hasCast(String abilityName) {
        return this.abilities.isActive(abilityName);
    }

    public boolean hasAbility(String abilityName) {
        return this.abilities.has(abilityName);
    }

    public boolean hasWeapon() {
        return !this.getWeapon().method_7960();
    }

    public class_1799 getWeapon() {
        if (this.weapon == null) {
            return class_1799.field_8037;
        }
        return this.weapon;
    }

    public void setWeapon(class_1799 weapon) {
        this.setWeapon(weapon, true);
    }

    public void removeWeapon() {
        this.removeWeapon(true);
    }

    public void setWeapon(class_1799 weapon, boolean sound) {
        if (sound && this.player != null) {
            this.player.method_37908().method_43129(null, (class_1297)this.player, SoulForgeSounds.WEAPON_SUMMON_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
        this.weapon = weapon;
    }

    public void removeWeapon(boolean sound) {
        if (this.hasWeapon() && this.getWeapon().method_31574(SoulForgeItems.BFRCMG)) {
            this.setCooldown("BFRCMG", 100);
        }
        if (sound && this.player != null) {
            this.player.method_37908().method_43129(null, (class_1297)this.player, SoulForgeSounds.WEAPON_UNSUMMON_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
        this.weapon = class_1799.field_8037;
    }

    public HashMap<String, Integer> getMonsterSouls() {
        return this.monsterSouls;
    }

    public HashMap<String, Integer> getPlayerSouls() {
        return this.playerSouls;
    }

    public void addMonsterSoul(String type, int amount) {
        if (this.monsterSouls.containsKey(type)) {
            this.monsterSouls.put(type, this.monsterSouls.get(type) + amount);
        } else {
            this.monsterSouls.put(type, amount);
        }
        SoulForgeCriterions.MONSTER_SOUL.trigger((class_3222)this.player, this.monsterSouls.get(type), type);
    }

    public void addMonsterSoul(class_1297 entity, int amount) {
        this.addMonsterSoul(class_7923.field_41177.method_10221((Object)entity.method_5864()).toString(), amount);
    }

    public void addPlayerSoul(String playerName, int amount) {
        if (this.playerSouls.containsKey(playerName)) {
            this.playerSouls.put(playerName, this.playerSouls.get(playerName) + amount);
        } else {
            this.playerSouls.put(playerName, amount);
        }
    }

    public int getSoulCount(String type) {
        if (!this.monsterSouls.containsKey(type)) {
            return 0;
        }
        return this.monsterSouls.get(type);
    }

    public boolean canReset() {
        for (int i = 0; i < this.player.method_31548().method_5439(); ++i) {
            class_1799 stack = this.player.method_31548().method_5438(i);
            if (stack.method_7909() != SoulForgeItems.DETERMINATION_ARNICITE_HEART) continue;
            return true;
        }
        return false;
    }

    public AbilityLayout getAbilityLayout() {
        return this.abilityLayout;
    }

    public AbilityBase getLayoutAbility(int row, int column) {
        return this.abilityLayout.getSlot(row, column);
    }

    public AbilityLayout.AbilityRow getLayoutRow(int row) {
        return this.abilityLayout.rows.get(row);
    }

    public void setAbilityLayout(AbilityLayout layout) {
        this.abilityLayout = layout;
    }

    public void setLayoutAbility(AbilityBase ability, int row, int column) {
        this.abilityLayout.setSlot(ability, row, column);
    }

    public int getAbilityRow() {
        return this.abilityRow;
    }

    public void setAbilityRow(int i) {
        this.abilityRow = class_3532.method_15340((int)i, (int)0, (int)3);
    }

    public int getAbilitySlot() {
        return this.abilitySlot;
    }

    public void setAbilitySlot(int i) {
        this.abilitySlot = class_3532.method_15340((int)i, (int)0, (int)9);
    }

    public void toggleMagicMode() {
        this.magicMode = !this.magicMode;
    }

    public boolean magicModeActive() {
        return this.magicMode;
    }

    public void sync() {
        if (!this.player.method_37908().field_9236) {
            SoulComponent.sync(this.player);
        }
    }

    public class_2540 toBuffer() {
        class_2540 buf = PacketByteBufs.create();
        try {
            buf.method_10804(this.traits.size());
            buf.method_10814(this.traits.get(0).getName());
            if (this.traits.size() == 2) {
                buf.method_10814(this.traits.get(1).getName());
            }
            buf.writeBoolean(this.strong);
            buf.writeBoolean(this.pure);
            buf.method_10804(this.lv);
            buf.method_10804(this.exp);
            buf.method_10804(this.style);
            buf.method_10804(this.styleRank);
            buf.method_10804(this.lastStyleIncrease);
            buf.writeFloat(this.magic);
            buf.writeFloat(this.magicGauge);
            buf.method_10804(this.abilities.getAll().size());
            for (AbilityBase ability : this.abilities.getAll()) {
                buf.method_10814(ability.getName());
                buf.method_10794(ability.saveNbt(new class_2487()));
            }
            buf.method_10793(this.weapon);
            buf.method_10804(this.lastCastTime);
            buf.method_10804(this.monsterSouls.size());
            for (String type : this.monsterSouls.keySet()) {
                buf.method_10814(type);
                buf.method_10804(this.monsterSouls.get(type).intValue());
            }
            buf.method_10804(this.playerSouls.size());
            for (String type : this.playerSouls.keySet()) {
                buf.method_10814(type);
                buf.method_10804(this.playerSouls.get(type).intValue());
            }
            this.abilityLayout.toBuf(buf);
            this.resetData.writeBuf(buf);
            buf.writeBoolean(this.disguisedAsID != null);
            if (this.disguisedAsID != null) {
                buf.method_10797(this.disguisedAsID);
            }
            this.spokenTextRenderer.writeBuffer(buf);
            return buf;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void fromBuffer(class_2540 buf) {
        int i;
        int traitCount = buf.method_10816();
        ArrayList<TraitBase> traits = new ArrayList<TraitBase>(List.of(Objects.requireNonNull(Traits.get(buf.method_19772()))));
        if (traitCount == 2) {
            traits.add(Traits.get(buf.method_19772()));
        }
        this.traits = traits;
        this.strong = buf.readBoolean();
        this.pure = buf.readBoolean();
        this.lv = buf.method_10816();
        this.exp = buf.method_10816();
        this.style = buf.method_10816();
        this.styleRank = buf.method_10816();
        this.lastStyleIncrease = buf.method_10816();
        this.magic = buf.readFloat();
        this.magicGauge = buf.readFloat();
        int abilityCount = buf.method_10816();
        AbilityList abilityList = new AbilityList();
        for (int i2 = 0; i2 < abilityCount; ++i2) {
            String abilityName = buf.method_19772();
            try {
                class_2487 nbt = buf.method_10798();
                AbilityBase ability = Abilities.get(abilityName);
                ability.readNbt(nbt);
                abilityList.add(ability);
                continue;
            }
            catch (NullPointerException e) {
                SoulForge.LOGGER.warn("Ability does not exist: {}", (Object)abilityName);
            }
        }
        this.abilities = abilityList;
        this.weapon = buf.method_10819();
        this.lastCastTime = buf.method_10816();
        int soulCount = buf.method_10816();
        this.monsterSouls = new HashMap();
        for (i = 0; i < soulCount; ++i) {
            this.monsterSouls.put(buf.method_19772(), buf.method_10816());
        }
        soulCount = buf.method_10816();
        this.playerSouls = new HashMap();
        for (i = 0; i < soulCount; ++i) {
            this.playerSouls.put(buf.method_19772(), buf.method_10816());
        }
        this.abilityLayout = AbilityLayout.fromBuf(List.copyOf(this.abilities.getAll()), buf);
        this.resetData = ResetData.fromBuf(buf);
        this.disguisedAsID = null;
        if (buf.readBoolean()) {
            this.disguisedAsID = buf.method_10790();
            this.disguisedAs = this.player.method_37908().method_18470(this.disguisedAsID);
        }
        this.spokenTextRenderer.readBuffer(buf);
    }

    public void castAbility(int index) {
        List<AbilityBase> rowAbilities = this.getLayoutRow((int)this.getAbilityRow()).abilities;
        if (index <= 8 && index >= 0) {
            AbilityBase toCast = rowAbilities.get(index);
            this.castAbility(toCast);
        } else {
            SoulForge.LOGGER.info("Attempted to cast an ability that the player doesn't have!");
        }
    }

    public boolean isStrong() {
        return this.strong;
    }

    public boolean isPure() {
        return this.pure;
    }

    public void setStrong(boolean strong) {
        this.strong = strong;
    }

    public void setPure(boolean pure) {
        if (this.pure) {
            this.strong = true;
        }
        this.pure = pure;
        if (this.player instanceof class_3222) {
            this.updateAbilities();
        }
    }

    public void createWormholeRequest(class_1657 from) {
        this.wormholeRequest = from == null ? null : new class_3545((Object)from.method_5667(), (Object)from.method_5682().method_3780());
        this.sync();
    }

    public void removeWormholeRequest() {
        this.wormholeRequest = null;
        this.sync();
    }

    @Nullable
    public class_3545<UUID, Integer> getWormholeRequest() {
        return this.wormholeRequest;
    }

    public class_1657 getWormholeTarget() {
        if (this.wormholeRequest != null) {
            return this.player.method_37908().method_18470((UUID)this.wormholeRequest.method_15442());
        }
        return null;
    }

    public int getWormholeTime() {
        if (this.wormholeRequest != null) {
            return (Integer)this.wormholeRequest.method_15441();
        }
        return 0;
    }

    public boolean hasWormholeRequest() {
        return this.wormholeRequest != null;
    }

    public void setDisguise(class_1657 target) {
        this.disguisedAsID = target.method_5667();
        this.disguisedAs = target;
        this.sync();
    }

    public void removeDisguise() {
        this.disguisedAsID = null;
        this.disguisedAs = null;
        this.sync();
    }

    public class_1657 getDisguise() {
        return this.disguisedAs;
    }

    public String getSpokenText() {
        return this.spokenTextRenderer.toRender();
    }

    public void setSpokenText(String text, int speed, int timeToDisappear) {
        this.spokenTextRenderer.setText(text, speed, timeToDisappear);
        this.sync();
    }

    public void setSpokenText(String text) {
        this.spokenTextRenderer.setText(text);
        this.sync();
    }

    public void castAbility(AbilityBase ability) {
        if (ability == null) {
            return;
        }
        boolean contains = this.abilities.has(ability.getName());
        if (contains || ability.getType() == AbilityType.PASSIVE) {
            ToggleableAbilityBase toggleable;
            float cost = ability.getCost();
            if (this.player.method_5996(SoulForgeAttributes.MAGIC_COST) != null) {
                cost *= (float)this.player.method_26825(SoulForgeAttributes.MAGIC_COST);
            }
            if (ability instanceof ToggleableAbilityBase && (toggleable = (ToggleableAbilityBase)ability).getActive()) {
                cost = 0.0f;
            }
            if (cost <= this.magic && !this.onCooldown(ability)) {
                boolean canCast = ability.cast((class_3222)this.player);
                if (canCast) {
                    SoulForgeCriterions.CAST_ABILITY.trigger((class_3222)this.player, ability);
                    if (ability instanceof ToggleableAbilityBase) {
                        ToggleableAbilityBase toggleable2 = (ToggleableAbilityBase)ability;
                        if (toggleable2.getActive()) {
                            this.magic -= cost;
                            this.resetLastCastTime();
                        } else {
                            ability.end((class_3222)this.player);
                            ability.setActive(false);
                            float cooldown = ability.getCooldown();
                            if (this.player.method_5996(SoulForgeAttributes.MAGIC_COST) != null) {
                                cooldown *= (float)this.player.method_26825(SoulForgeAttributes.MAGIC_COOLDOWN);
                            }
                            this.setCooldown(ability, (int)cooldown);
                        }
                    } else {
                        this.magic -= cost;
                        float cooldown = ability.getCooldown();
                        if (this.player.method_5996(SoulForgeAttributes.MAGIC_COST) != null) {
                            cooldown *= (float)this.player.method_26825(SoulForgeAttributes.MAGIC_COOLDOWN);
                        }
                        this.setCooldown(ability, (int)cooldown);
                        ability.setActive(true);
                        this.resetLastCastTime();
                    }
                }
                this.sync();
            }
        } else {
            SoulForge.LOGGER.info("Attempted to cast an ability that the player doesn't have!");
        }
    }

    private void decreaseTimer(ValueComponent values, String value) {
        if (values.hasInt(value)) {
            if (values.getInt(value) > 0) {
                values.setInt(value, values.getInt(value) - 1);
            } else {
                values.removeInt(value);
            }
        }
    }

    public void tick() {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (!this.initialized) {
                if (!this.getResetData().setFirst) {
                    this.resetTrait();
                    this.updateAbilities();
                }
                this.initialized = true;
            }
            ValueComponent values = SoulForge.getValues((class_1309)serverPlayer);
            for (AbilityBase ability : this.abilities.getActive()) {
                if (!ability.tick((class_3222)this.player)) continue;
                ability.end((class_3222)this.player);
                if (ability.getType() == AbilityType.TOGGLE || ability.getType() == AbilityType.AURA) {
                    float cooldown = ability.getCooldown();
                    this.setCooldown(ability, (int)(cooldown *= (float)this.player.method_26825(SoulForgeAttributes.MAGIC_COOLDOWN)));
                }
                ability.setActive(false);
            }
            for (AbilityBase ability : this.abilities.getOnCooldown()) {
                ability.cooldownTick();
            }
            for (AbilityBase ability : this.getAbilities()) {
                if (ability.getType() != AbilityType.SIDE_EFFECT || !(ability instanceof SideEffectAbilityBase)) continue;
                SideEffectAbilityBase sideEffect = (SideEffectAbilityBase)ability;
                if (!(Math.random() <= (double)sideEffect.getOccurrenceChance())) continue;
                boolean canCast = sideEffect.cast((class_3222)this.player);
                if (canCast) {
                    SoulForgeCriterions.CAST_ABILITY.trigger((class_3222)this.player, ability);
                    ability.setActive(true);
                }
                this.sync();
            }
            if (this.isStrong() && !this.player.method_5996(SoulForgeAttributes.MAGIC_COST).method_6196(strongModifier)) {
                this.player.method_5996(SoulForgeAttributes.MAGIC_COST).method_26837(strongModifier);
            } else if (this.player.method_5996(SoulForgeAttributes.MAGIC_COST).method_6196(strongModifier)) {
                this.player.method_5996(SoulForgeAttributes.MAGIC_COST).method_27304(strongModifier.method_6189());
            }
            if (this.isPure()) {
                if (!this.player.method_5996(SoulForgeAttributes.MAGIC_COOLDOWN).method_6196(pureModifier)) {
                    this.player.method_5996(SoulForgeAttributes.MAGIC_COOLDOWN).method_26837(pureModifier);
                }
                if (!this.player.method_5996(SoulForgeAttributes.MAGIC_POWER).method_6196(pureModifier)) {
                    this.player.method_5996(SoulForgeAttributes.MAGIC_POWER).method_26837(pureModifier);
                }
            } else {
                if (this.player.method_5996(SoulForgeAttributes.MAGIC_COOLDOWN).method_6196(pureModifier)) {
                    this.player.method_5996(SoulForgeAttributes.MAGIC_COOLDOWN).method_27304(pureModifier.method_6189());
                }
                if (this.player.method_5996(SoulForgeAttributes.MAGIC_POWER).method_6196(pureModifier)) {
                    this.player.method_5996(SoulForgeAttributes.MAGIC_POWER).method_27304(pureModifier.method_6189());
                }
            }
            if (this.hasWeapon() && this.getWeapon().method_7909() instanceof MagicSwordItem) {
                MagicSwordItem weapon = (MagicSwordItem)this.getWeapon().method_7909();
                weapon.attackDamage = this.getWeapon().method_31573(SoulForgeTags.EFFECTIVE_LV_WEAPON) ? weapon.baseAttackDamage + (float)this.getEffectiveLV() * weapon.lvIncrease : weapon.baseAttackDamage + (float)this.getLV() * weapon.lvIncrease;
            }
            if (this.hasWormholeRequest() && this.player.method_5682().method_3780() > this.getWormholeTime() + 600) {
                this.removeWormholeRequest();
            }
            assert (values != null);
            this.decreaseTimer(values, "dtWeaponCooldown");
            this.decreaseTimer(values, "shieldBashCooldown");
            this.decreaseTimer(values, "stockpileTimer");
            this.decreaseTimer(values, "slamJumpTimer");
            if (values.hasInt("stockpileTimer") && values.getInt("stockpileTimer") <= 0 && values.hasInt("stockpiles")) {
                values.setInt("stockpiles", 0);
            }
            if (values.hasInt("stockpiles") && values.getInt("stockpiles") == 8) {
                values.setInt("stockpiles", 0);
                values.setInt("stockpileTimer", 0);
                if (this.abilities.has("Perfected Aura Technique")) {
                    PerfectedAuraTechnique pat = (PerfectedAuraTechnique)this.abilities.get("Perfected Aura Technique");
                    pat.fullPower = true;
                    pat.timer = 5020;
                    SoulForgeCriterions.CAST_ABILITY.trigger((class_3222)this.player, pat);
                }
            }
            if (values.hasTimer("shieldBash")) {
                for (class_1297 target : this.player.method_5770().method_8335((class_1297)this.player, class_238.method_30048((class_243)this.player.method_19538().method_1031(0.0, 1.0, 0.0), (double)1.0, (double)2.0, (double)1.0))) {
                    if (!(target instanceof class_1309)) continue;
                    class_1309 living = (class_1309)target;
                    if (living.method_5643(SoulForgeDamageTypes.of(this.player, SoulForgeDamageTypes.SUMMON_WEAPON_DAMAGE_TYPE), 5.0f)) {
                        this.setStyle(this.getStyle() + 5);
                    }
                    living.method_6005(1.5, -this.player.method_18798().field_1352, -this.player.method_18798().field_1350);
                    if (this.hasCast("Furioso")) {
                        living.method_6092(new class_1293(SoulForgeEffects.VULNERABILITY, 100, 1));
                    }
                    if (!this.player.method_6047().method_31574(SoulForgeItems.DETERMINATION_SHIELD)) continue;
                    living.method_6092(new class_1293(SoulForgeEffects.VULNERABILITY, 100, 0));
                    living.method_6092(new class_1293(class_1294.field_5909, 100, 1));
                    living.method_6092(new class_1293(class_1294.field_5911, 100, 1));
                    living.method_6092(new class_1293(class_1294.field_5916, 100, 1));
                }
            }
            if (values.hasTimer("clawGouge")) {
                if (values.getTimer("clawGouge") == 15) {
                    Iterator modifiers = SoulForge.getTemporaryModifiers((class_1309)this.player);
                    values.setTimer("forcedRunning", 15);
                    ((TemporaryModifierComponent)((Object)modifiers)).addTemporaryModifier(class_5134.field_23719, new class_1322("claw_gouge", 2.0, class_1322.class_1323.field_6331), 15.0f);
                    class_243 velAdd = this.player.method_5720().method_38499(class_2350.class_2351.field_11052, 0.0).method_1029().method_1021(this.player.method_6047().method_31574(SoulForgeItems.DETERMINATION_CLAW) ? 3.5 : 2.0);
                    this.player.method_45319(velAdd);
                    this.player.field_6037 = true;
                }
                if (values.getTimer("clawGouge") <= 15) {
                    for (class_1297 target : this.player.method_5770().method_8335((class_1297)this.player, class_238.method_30048((class_243)this.player.method_19538().method_1031(0.0, 1.0, 0.0), (double)1.0, (double)2.0, (double)1.0))) {
                        if (!(target instanceof class_1309)) continue;
                        class_1309 living = (class_1309)target;
                        if (living.method_5643(this.player.method_48923().method_48802(this.player), (float)(this.player.method_26825(class_5134.field_23721) * 1.5))) {
                            this.setStyle(this.getStyle() + (int)(this.player.method_26825(class_5134.field_23721) * 1.5));
                        }
                        if (this.player.method_6047().method_31574(SoulForgeItems.DETERMINATION_CLAW)) {
                            living.method_6092(new class_1293(SoulForgeEffects.VULNERABILITY, 140, 1));
                        } else {
                            this.player.method_18799(class_243.field_1353);
                            this.player.field_6037 = true;
                            values.removeTimer("forcedRunning");
                            values.removeTimer("clawGouge");
                            if (this.tryConsumeMagic(40.0f)) {
                                Utils.addAntiheal(this.hasCast("Furioso") ? 1.0 : (double)0.8f, this.getLV() * 40, living);
                            }
                        }
                        if (!this.player.method_6047().method_31574(SoulForgeItems.GUNLANCE)) break;
                        class_243 end = this.player.method_33571().method_1019(this.player.method_5720().method_1021(50.0));
                        class_3965 hit = this.player.method_37908().method_17742(new class_3959(this.player.method_33571(), this.player.method_33571().method_1019(this.player.method_5720().method_1021(50.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.player));
                        if (hit != null) {
                            end = hit.method_17784().method_1020(Utils.getArmPosition(this.player));
                        }
                        BlastEntity blast = new BlastEntity(this.player.method_37908(), Utils.getArmPosition(this.player), (class_1309)this.player, 0.25f, class_243.field_1353, end, (float)this.getLV() * 1.5f, Color.YELLOW, false, 10);
                        blast.owner = this.player;
                        class_3218 serverWorld = (class_3218)this.player.method_37908();
                        serverWorld.method_8649((class_1297)blast);
                        serverWorld.method_32888(class_5712.field_28738, this.player.method_19538(), class_5712.class_7397.method_43285((class_1297)this.player));
                        serverWorld.method_43129(null, (class_1297)this.player, SoulForgeSounds.UT_BLASTER_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                        break;
                    }
                }
            }
            if (values.hasTimer("dtGauntletsRush")) {
                for (class_1297 target : this.player.method_5770().method_8335((class_1297)this.player, class_238.method_30048((class_243)this.player.method_19538().method_1031(0.0, 1.0, 0.0), (double)1.0, (double)2.0, (double)1.0))) {
                    if (!(target instanceof class_1309)) continue;
                    class_1309 living = (class_1309)target;
                    living.method_37908().method_8437((class_1297)this.player, living.method_23317(), living.method_23318(), living.method_23321(), 1.0f, class_1937.class_7867.field_40888);
                    values.removeTimer("dtGauntletsRush");
                    values.removeTimer("forcedRunning");
                    this.player.method_18800(0.0, 0.0, 0.0);
                    this.player.field_6037 = true;
                    break;
                }
            }
            if (values.hasTimer("yoyoAoETimer")) {
                for (class_1297 entity : this.player.method_37908().method_8335((class_1297)this.player, class_238.method_30048((class_243)this.player.method_19538(), (double)4.0, (double)4.0, (double)4.0))) {
                    class_1309 living;
                    if (!(entity instanceof class_1309) || !(living = (class_1309)entity).method_5643(this.player.method_48923().method_48802(this.player), 12.0f)) continue;
                    this.setStyle(this.getStyle() + 12);
                }
                float angle = values.getTimer("yoyoAoETimer");
                class_243 particlePos = new class_243(Math.sin(angle), 1.0, Math.cos(angle));
                serverPlayer.method_51469().method_14199((class_2394)class_2398.field_11227, this.player.method_23317() + particlePos.field_1352, this.player.method_23318() + particlePos.field_1351, this.player.method_23321() + particlePos.field_1350, 2, 0.0, 0.0, 0.0, 0.0);
                values.removeTimer("yoyoSpin");
            }
            if (values.hasTimer("yoyoSpin")) {
                float angle = (float)(20 - values.getTimer("yoyoSpin")) / 20.0f * (float)Math.PI;
                class_243 start = new class_243((double)values.getFloat("startX"), (double)values.getFloat("startY"), (double)values.getFloat("startZ"));
                class_243 center = new class_243((double)values.getFloat("centerX"), (double)values.getFloat("centerY"), (double)values.getFloat("centerZ"));
                class_243 p = start.method_1020(center);
                class_243 axis = new class_243((double)values.getFloat("axisX"), (double)values.getFloat("axisY"), (double)values.getFloat("axisZ")).method_1029();
                float a = class_3532.method_15362((float)(angle / 2.0f));
                class_243 f = axis.method_22882().method_1021((double)class_3532.method_15374((float)(angle / 2.0f)));
                float b = (float)f.field_1352;
                float c = (float)f.field_1351;
                float d = (float)f.field_1350;
                float aa = a * a;
                float bb = b * b;
                float cc = c * c;
                float dd = d * d;
                float bc = b * c;
                float ad = a * d;
                float ac = a * c;
                float ab = a * b;
                float bd = b * d;
                float cd = c * d;
                class_243 fx = new class_243((double)(aa + bb - cc - dd), (double)(2.0f * (bc + ad)), (double)(2.0f * (bd - ac)));
                class_243 fy = new class_243((double)(2.0f * (bc - ad)), (double)(aa + cc - bb - dd), (double)(2.0f * (cd + ab)));
                class_243 fz = new class_243((double)(2.0f * (bd + ac)), (double)(2.0f * (cd - ab)), (double)(aa + dd - bb - cc));
                class_243 result = new class_243(fx.field_1352 * p.field_1352 + fx.field_1351 * p.field_1351 + fx.field_1350 * p.field_1350, fy.field_1352 * p.field_1352 + fy.field_1351 * p.field_1351 + fy.field_1350 * f.field_1350, fz.field_1352 * p.field_1352 + fz.field_1351 * p.field_1351 + fz.field_1350 * p.field_1350);
                class_3965 hit = this.player.method_37908().method_17742(new class_3959(center, center.method_1019(result), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.player));
                class_243 target = hit != null ? hit.method_17784() : center.method_1019(result);
                this.player.method_20620(target.field_1352, target.field_1351, target.field_1350);
                this.player.field_6017 = -5.0f;
            }
            if (this.disguisedAsID != null) {
                this.disguisedAs = this.player.method_37908().method_18470(this.disguisedAsID);
            }
            if (this.hasTrait(Traits.perseverance)) {
                if (!this.player.method_5996(SoulForgeAttributes.SHIELD_BREAK).method_6196(shieldBreakModifier)) {
                    this.player.method_5996(SoulForgeAttributes.SHIELD_BREAK).method_26837(shieldBreakModifier);
                }
            } else if (this.player.method_5996(SoulForgeAttributes.SHIELD_BREAK).method_6196(shieldBreakModifier)) {
                this.player.method_5996(SoulForgeAttributes.SHIELD_BREAK).method_27304(shieldBreakModifier.method_6189());
            }
            if (this.hasTrait(Traits.determination)) {
                Utils.clearModifiersByName((class_1309)this.player, class_5134.field_23721, "limit_break");
                class_1322 strengthModifier = new class_1322("limit_break", 0.1 * (double)this.styleRank, class_1322.class_1323.field_6331);
                this.player.method_5996(class_5134.field_23721).method_26837(strengthModifier);
            }
            this.spokenTextRenderer.tick();
        }
        if (this.disguisedAsID != null && (this.disguisedAs == null || this.disguisedAs.method_5667() != this.disguisedAsID)) {
            this.disguisedAs = this.player.method_37908().method_18470(this.disguisedAsID);
        }
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        if (this.player == null) {
            SoulForge.LOGGER.error("Player was null in SoulComponent while attempting to read from NBT!");
            return;
        }
        this.traits = new ArrayList();
        this.traits.add(Traits.get(tag.method_10558("trait1")));
        if (tag.method_10545("trait2")) {
            this.traits.add(Traits.get(tag.method_10558("trait2")));
        }
        this.lv = tag.method_10550("lv");
        this.exp = tag.method_10550("exp");
        this.magic = tag.method_10583("magic");
        this.magicGauge = tag.method_10545("magicGauge") ? tag.method_10583("magicGauge") : 0.0f;
        this.strong = tag.method_10577("strong");
        this.pure = tag.method_10577("pure");
        class_2487 abilityNbt = tag.method_10562("abilities");
        this.abilities = new AbilityList();
        for (String string : abilityNbt.method_10541()) {
            try {
                AbilityBase ability = Abilities.get(string);
                ability.readNbt(abilityNbt.method_10562(string));
                ability.setCooldownVal(0);
                this.abilities.add(ability);
            }
            catch (NullPointerException e) {
                SoulForge.LOGGER.warn("Ability does not exist: {}", (Object)string);
            }
        }
        for (AbilityBase abilityBase : Traits.getAbilities(this.player, this)) {
            if (this.abilities.has(abilityBase)) continue;
            this.abilities.add(abilityBase.getInstance());
        }
        this.monsterSouls = new HashMap();
        class_2487 souls = (class_2487)tag.method_10580("monsterSouls");
        if (souls != null) {
            for (String key : souls.method_10541()) {
                this.monsterSouls.put(key, souls.method_10550(key));
                if (this.player.method_37908().field_9236) continue;
                SoulForgeCriterions.MONSTER_SOUL.trigger((class_3222)this.player, this.monsterSouls.get(key), key);
            }
        }
        this.playerSouls = new HashMap();
        souls = (class_2487)tag.method_10580("playerSouls");
        if (souls != null) {
            for (String key : souls.method_10541()) {
                this.playerSouls.put(key, souls.method_10550(key));
            }
        }
        this.abilityLayout = AbilityLayout.fromNbt(List.copyOf(this.abilities.getAll()), tag.method_10554("abilityLayout", 10));
        this.resetData = new ResetData(tag.method_10562("resetData"));
        if (tag.method_10545("wormhole")) {
            class_2487 class_24872 = tag.method_10562("wormhole");
            this.wormholeRequest = new class_3545((Object)class_24872.method_25926("target"), (Object)class_24872.method_10550("time"));
        }
        if (tag.method_10545("disguisedAs")) {
            this.disguisedAsID = tag.method_25926("disguisedAs");
            this.disguisedAs = this.player.method_37908().method_18470(this.disguisedAsID);
        }
        this.spokenTextRenderer.readNbt(tag.method_10562("spokenTextRenderer"));
        this.initialized = true;
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        tag.method_10582("trait1", this.traits.get(0).getName());
        if (this.traits.size() == 2) {
            tag.method_10582("trait2", this.traits.get(1).getName());
        }
        tag.method_10569("lv", this.lv);
        tag.method_10569("exp", this.exp);
        tag.method_10548("magic", this.magic);
        tag.method_10548("magicGauge", this.magicGauge);
        tag.method_10556("strong", this.strong);
        tag.method_10556("pure", this.pure);
        class_2487 abilityNbt = new class_2487();
        for (AbilityBase abilityBase : this.abilities.getAll()) {
            abilityNbt.method_10566(abilityBase.getName(), (class_2520)abilityBase.saveNbt(new class_2487()));
        }
        tag.method_10566("abilities", (class_2520)abilityNbt);
        class_2487 souls = new class_2487();
        for (String key : this.monsterSouls.keySet()) {
            souls.method_10569(key, this.monsterSouls.get(key).intValue());
        }
        tag.method_10566("monsterSouls", (class_2520)souls);
        souls = new class_2487();
        for (String key : this.playerSouls.keySet()) {
            souls.method_10569(key, this.playerSouls.get(key).intValue());
        }
        tag.method_10566("playerSouls", (class_2520)souls);
        tag.method_10566("abilityLayout", (class_2520)this.abilityLayout.toNbt());
        tag.method_10566("resetData", (class_2520)this.resetData.toNBT());
        if (this.wormholeRequest != null) {
            class_2487 class_24872 = new class_2487();
            class_24872.method_25927("target", (UUID)this.wormholeRequest.method_15442());
            class_24872.method_10569("time", ((Integer)this.wormholeRequest.method_15441()).intValue());
            tag.method_10566("wormhole", (class_2520)class_24872);
        }
        if (this.disguisedAsID != null) {
            tag.method_25927("disguisedAs", this.disguisedAsID);
        }
        tag.method_10566("spokenTextRenderer", (class_2520)this.spokenTextRenderer.writeNbt());
    }

    public String toString() {
        String str = "Trait: " + (String)(this.traits.size() == 2 ? this.traits.get(0).getName() + "-" + this.traits.get(1).getName() : this.traits.get(0).getName());
        str = str + ", LV: " + this.lv + ", EXP: " + this.exp;
        return str;
    }

    public void reset() {
        this.resetTrait();
        this.lv = 1;
        this.exp = 0;
        this.magic = 100.0f;
        if (Utils.isInverted(this)) {
            this.magicGauge = 1000.0f;
        }
        this.monsterSouls = new HashMap();
        this.playerSouls = new HashMap();
        this.removeWeapon(false);
        this.abilityLayout = new AbilityLayout();
        for (AbilityBase ability : this.abilities.getAll()) {
            if (ability.getActive()) {
                ability.end((class_3222)this.player);
            }
            ability.setActive(false);
        }
        this.updateAbilities();
        this.sync();
    }

    public void softReset() {
        this.lv = 1;
        this.exp = 0;
        this.magic = 100.0f;
        if (Utils.isInverted(this)) {
            this.magicGauge = 1000.0f;
        }
        this.monsterSouls = new HashMap();
        this.playerSouls = new HashMap();
        this.removeWeapon(false);
        this.abilityLayout = new AbilityLayout();
        for (AbilityBase ability : this.abilities.getAll()) {
            if (ability.getActive()) {
                ability.end((class_3222)this.player);
            }
            ability.setActive(false);
        }
        this.updateAbilities();
        this.sync();
    }

    private void updateAbilities() {
        if (this.player == null) {
            return;
        }
        if (this.player.method_37908().field_9236) {
            return;
        }
        List<String> shouldBeAbilityNames = Traits.getAbilities(this.player, this).stream().map(AbilityBase::getName).toList();
        for (String abilityName : shouldBeAbilityNames) {
            if (this.abilities.has(abilityName)) continue;
            this.abilities.add(Abilities.get(abilityName));
        }
        if (Utils.getHate((class_1309)this.player) > 0.0f) {
            for (AbilityBase ability : Abilities.hateAbilities) {
                if (this.abilities.has(ability.getName())) continue;
                this.abilities.add(ability.getInstance());
            }
        }
        for (AbilityBase ability : this.abilities.getAll()) {
            if (shouldBeAbilityNames.contains(ability.getName())) continue;
            this.abilities.remove(ability);
        }
    }

    private void resetTrait() {
        List<TraitBase> oldTraits = this.getTraits();
        if (oldTraits == null) {
            oldTraits = new ArrayList<TraitBase>(List.of(Traits.bravery, Traits.integrity, Traits.spite));
        }
        Random rnd = new Random();
        int num = rnd.nextInt(100);
        this.strong = false;
        this.pure = false;
        this.traits = new ArrayList();
        if (num <= this.resetData.resetsSinceDT && !oldTraits.contains(Traits.determination)) {
            this.traits.add(Traits.determination);
            this.resetData.resetsSinceDT = -1;
        } else if (num <= this.resetData.resetsSinceDT + 5 * this.resetData.resetsSinceDual) {
            this.traits.add(Traits.randomNormal());
            this.traits.add(Traits.randomNormal());
            while (this.traits.get(1) == this.traits.get(0) && !oldTraits.equals(this.traits)) {
                this.traits.set(1, Traits.randomNormal());
            }
            this.resetData.resetsSinceDual = -1;
            num = rnd.nextInt(10);
            if (num <= this.resetData.resetsSinceStrong) {
                this.strong = true;
                this.resetData.resetsSinceStrong = 0;
            } else {
                ++this.resetData.resetsSinceStrong;
            }
        } else {
            this.traits.add(Traits.randomNormal());
            while (oldTraits.equals(this.traits)) {
                this.traits = new ArrayList();
                this.traits.add(Traits.randomNormal());
            }
            num = rnd.nextInt(50);
            if (num <= this.resetData.resetsSincePure) {
                this.strong = true;
                this.pure = true;
                this.resetData.resetsSincePure = 0;
                this.resetData.resetsSinceStrong = 0;
            } else if (num <= this.resetData.resetsSincePure + this.resetData.resetsSinceStrong * 5) {
                this.strong = true;
                this.resetData.resetsSinceStrong = 0;
                ++this.resetData.resetsSincePure;
            } else {
                ++this.resetData.resetsSinceStrong;
                ++this.resetData.resetsSincePure;
            }
        }
        ++this.resetData.resetsSinceDT;
        ++this.resetData.resetsSinceDual;
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            SoulForgeCriterions.PLAYER_LV.trigger(serverPlayer, this.getLV());
            SoulForgeCriterions.PLAYER_TRAIT.trigger(serverPlayer, this);
            SoulForgeCriterions.PLAYER_SOUL.trigger(serverPlayer, this);
        }
        if (this.traits.size() == 1) {
            if (this.traits.get(0) == Traits.bravery) {
                this.resetData.bravery = true;
            }
            if (this.traits.get(0) == Traits.justice) {
                this.resetData.justice = true;
            }
            if (this.traits.get(0) == Traits.kindness) {
                this.resetData.kindness = true;
            }
            if (this.traits.get(0) == Traits.patience) {
                this.resetData.patience = true;
            }
            if (this.traits.get(0) == Traits.integrity) {
                this.resetData.integrity = true;
            }
            if (this.traits.get(0) == Traits.perseverance) {
                this.resetData.perseverance = true;
            }
            if (this.traits.get(0) == Traits.determination) {
                this.resetData.determination = true;
            }
            if (this.pure) {
                this.resetData.addPure(this.traits.get(0));
            }
        } else if (this.traits.size() == 2) {
            if (this.strong) {
                this.resetData.strongDual = true;
            }
            this.resetData.addDual(this.traits.get(0), this.traits.get(1));
        }
    }
}

