/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.components;

import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.util.Triplet;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class TemporaryModifierComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1309 entity;
    private List<Triplet<class_1322, class_1320, Float>> modifierDurations;

    public TemporaryModifierComponent(class_1309 living) {
        this.entity = living;
        this.modifierDurations = new ArrayList<Triplet<class_1322, class_1320, Float>>();
    }

    public List<Triplet<class_1322, class_1320, Float>> getModifiers() {
        return this.modifierDurations;
    }

    public int getModifierCount() {
        return this.modifierDurations.size();
    }

    public void addStackingTemporaryModifier(class_1320 attribute, class_1322 modifier, float duration) {
        class_1324 instance = this.entity.method_5996(attribute);
        if (instance != null) {
            if (instance.method_6196(modifier)) {
                modifier = new class_1322(UUID.randomUUID(), modifier.method_6185(), modifier.method_6186(), modifier.method_6182());
            }
            instance.method_26837(modifier);
            this.modifierDurations.add(new Triplet<class_1322, class_1320, Float>(modifier, attribute, Float.valueOf(duration)));
        }
    }

    public void addTemporaryModifier(class_1320 attribute, class_1322 modifier, float duration) {
        class_1324 instance = this.entity.method_5996(attribute);
        if (instance != null) {
            this.removeTemporaryModifier(attribute, modifier);
            instance.method_26837(modifier);
            this.modifierDurations.add(new Triplet<class_1322, class_1320, Float>(modifier, attribute, Float.valueOf(duration)));
        }
    }

    public Triplet<class_1322, class_1320, Float> getModifierEntry(class_1320 attribute, UUID uuid) {
        class_1324 instance = this.entity.method_5996(attribute);
        if (instance != null) {
            Triplet<class_1322, class_1320, Float> match = null;
            for (Triplet<class_1322, class_1320, Float> testing : Set.copyOf(this.modifierDurations)) {
                if (testing.getFirst().method_6189().compareTo(uuid) != 0 || testing.getSecond() != attribute) continue;
                match = testing;
                break;
            }
            return match;
        }
        return null;
    }

    public class_1322 getModifier(class_1320 attribute, UUID uuid) {
        class_1324 instance = this.entity.method_5996(attribute);
        if (instance != null) {
            Triplet<class_1322, class_1320, Float> match = null;
            for (Triplet<class_1322, class_1320, Float> testing : Set.copyOf(this.modifierDurations)) {
                if (testing.getFirst().method_6189().compareTo(uuid) != 0 || testing.getSecond() != attribute) continue;
                match = testing;
                break;
            }
            if (match != null) {
                return (class_1322)match.getFirst();
            }
        }
        return null;
    }

    public void removeTemporaryModifier(class_1320 attribute, class_1322 modifier) {
        class_1324 instance = this.entity.method_5996(attribute);
        if (instance != null) {
            instance.method_27304(modifier.method_6189());
            Triplet<class_1322, class_1320, Float> match = null;
            for (Triplet<class_1322, class_1320, Float> testing : Set.copyOf(this.modifierDurations)) {
                if (testing.getFirst().method_6189().compareTo(modifier.method_6189()) != 0 || testing.getSecond() != attribute) continue;
                match = testing;
                break;
            }
            if (match != null) {
                this.modifierDurations.remove(match);
            }
        }
    }

    public void removeTemporaryModifier(class_1320 attribute, UUID uuid) {
        class_1324 instance = this.entity.method_5996(attribute);
        if (instance != null) {
            instance.method_27304(uuid);
            Triplet<class_1322, class_1320, Float> match = null;
            for (Triplet<class_1322, class_1320, Float> testing : Set.copyOf(this.modifierDurations)) {
                if (testing.getFirst().method_6189().compareTo(uuid) != 0 || testing.getSecond() != attribute) continue;
                match = testing;
                break;
            }
            if (match != null) {
                this.modifierDurations.remove(match);
            }
        }
    }

    public void tick() {
        for (Triplet<class_1322, class_1320, Float> modifier : Set.copyOf(this.modifierDurations)) {
            float duration = modifier.getThird().floatValue();
            modifier.setThird(Float.valueOf(duration - (float)this.entity.method_26825(SoulForgeAttributes.EFFECT_DURATION_MULTIPLIER)));
            if (!(duration - 1.0f <= 0.0f)) continue;
            this.removeTemporaryModifier(modifier.getSecond(), modifier.getFirst());
        }
    }

    public void readFromNbt(class_2487 tag) {
        if (tag.method_10545("modifiers")) {
            this.modifierDurations = new ArrayList<Triplet<class_1322, class_1320, Float>>();
            class_2499 list = tag.method_10554("modifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 modifierNbt = list.method_10602(i);
                class_1322 modifier = class_1322.method_26859((class_2487)modifierNbt.method_10562("modifier"));
                class_1320 attribute = null;
                for (class_1324 instance : this.entity.method_6127().method_26841()) {
                    if (!Objects.equals(instance.method_6198().method_26830(), modifierNbt.method_10558("attribute"))) continue;
                    attribute = instance.method_6198();
                    break;
                }
                float duration = modifierNbt.method_10583("duration");
                if (attribute == null) continue;
                this.modifierDurations.add(new Triplet<class_1322, class_1320, Float>(modifier, attribute, Float.valueOf(duration)));
            }
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 list = new class_2499();
        for (Triplet<class_1322, class_1320, Float> modifier : Set.copyOf(this.modifierDurations)) {
            class_2487 modifierNbt = new class_2487();
            modifierNbt.method_10566("modifier", (class_2520)modifier.getFirst().method_26860());
            modifierNbt.method_10582("attribute", modifier.getSecond().method_26830());
            modifierNbt.method_10548("duration", modifier.getThird().floatValue());
            list.add((Object)modifierNbt);
        }
        tag.method_10566("modifiers", (class_2520)list);
    }
}

