/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.components;

import com.pulsar.soulforge.components.EntityInitializer;
import com.pulsar.soulforge.util.Utils;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ValueComponent
implements AutoSyncedComponent,
ServerTickingComponent {
    HashMap<String, Float> floatVals;
    HashMap<String, Integer> intVals;
    HashMap<String, Boolean> boolVals;
    HashMap<String, class_243> vecVals;
    HashMap<String, UUID> uuidVals;
    HashMap<String, Integer> timerVals;
    class_2487 extraVals;
    final class_1309 entity;

    public ValueComponent(class_1309 living) {
        this.entity = living;
        this.floatVals = new HashMap();
        this.intVals = new HashMap();
        this.boolVals = new HashMap();
        this.vecVals = new HashMap();
        this.uuidVals = new HashMap();
        this.timerVals = new HashMap();
        this.extraVals = new class_2487();
    }

    public float getFloat(String key) {
        return this.floatVals.get(key).floatValue();
    }

    public void setFloat(String key, float value) {
        this.floatVals.put(key, Float.valueOf(value));
        this.sync();
    }

    public void removeFloat(String key) {
        this.floatVals.remove(key);
        this.sync();
    }

    public boolean hasFloat(String key) {
        return this.floatVals.containsKey(key);
    }

    public int getInt(String key) {
        return this.intVals.get(key);
    }

    public void setInt(String key, int value) {
        this.intVals.put(key, value);
        this.sync();
    }

    public void removeInt(String key) {
        this.intVals.remove(key);
        this.sync();
    }

    public boolean hasInt(String key) {
        return this.intVals.containsKey(key);
    }

    public boolean getBool(String key) {
        if (!this.boolVals.containsKey(key)) {
            return false;
        }
        return this.boolVals.get(key);
    }

    public void setBool(String key, boolean value) {
        this.boolVals.put(key, value);
        this.sync();
    }

    public void removeBool(String key) {
        this.boolVals.remove(key);
        this.sync();
    }

    public boolean hasBool(String key) {
        return this.boolVals.containsKey(key);
    }

    public class_243 getVec(String key) {
        return this.vecVals.get(key);
    }

    public void setVec(String key, class_243 value) {
        this.vecVals.put(key, value);
        this.sync();
    }

    public void removeVec(String key) {
        this.vecVals.remove(key);
        this.sync();
    }

    public boolean hasVec(String key) {
        return this.vecVals.containsKey(key);
    }

    public UUID getUUID(String key) {
        return this.uuidVals.get(key);
    }

    public void setUUID(String key, UUID value) {
        this.uuidVals.put(key, value);
        this.sync();
    }

    public void removeUUID(String key) {
        this.uuidVals.remove(key);
        this.sync();
    }

    public boolean hasUUID(String key) {
        return this.uuidVals.containsKey(key);
    }

    public int getTimer(String key) {
        return this.timerVals.getOrDefault(key, 0);
    }

    public void setTimer(String key, int value) {
        this.timerVals.put(key, value);
        this.sync();
    }

    public void removeTimer(String key) {
        this.timerVals.remove(key);
        this.sync();
    }

    public boolean hasTimer(String key) {
        return this.timerVals.containsKey(key);
    }

    public class_2487 getExtraVals() {
        return this.extraVals;
    }

    public void setExtraVals(class_2487 value) {
        this.extraVals = value;
        this.sync();
    }

    public void modifyExtraVals(Consumer<class_2487> consumer) {
        consumer.accept(this.extraVals);
        this.sync();
    }

    void sync() {
        EntityInitializer.VALUES.sync((Object)this.entity);
    }

    public void readFromNbt(class_2487 nbt) {
        class_2487 floatNbt = nbt.method_10562("floatVals");
        this.floatVals = new HashMap();
        for (Object key : floatNbt.method_10541()) {
            this.floatVals.put((String)key, Float.valueOf(floatNbt.method_10583((String)key)));
        }
        class_2487 intNbt = nbt.method_10562("intVals");
        this.intVals = new HashMap();
        for (Object key : intNbt.method_10541()) {
            this.intVals.put((String)key, intNbt.method_10550((String)key));
        }
        class_2487 boolNbt = nbt.method_10562("boolVals");
        this.boolVals = new HashMap();
        for (Object key : boolNbt.method_10541()) {
            this.boolVals.put((String)key, boolNbt.method_10577((String)key));
        }
        class_2487 vecNbt = nbt.method_10562("vecVals");
        this.vecVals = new HashMap();
        for (Object key : vecNbt.method_10541()) {
            this.vecVals.put((String)key, Utils.nbtToVector(vecNbt.method_10554((String)key, 6)));
        }
        class_2487 uuidNbt = nbt.method_10562("uuidVals");
        this.uuidVals = new HashMap();
        for (String key : uuidNbt.method_10541()) {
            this.uuidVals.put(key, uuidNbt.method_25926(key));
        }
        class_2487 timerNbt = nbt.method_10562("timerVals");
        this.timerVals = new HashMap();
        for (String key : timerNbt.method_10541()) {
            this.timerVals.put(key, timerNbt.method_10550(key));
        }
        this.extraVals = nbt.method_10562("extras");
    }

    public void writeToNbt(class_2487 nbt) {
        class_2487 floatNbt = new class_2487();
        for (Map.Entry<String, Float> entry : this.floatVals.entrySet()) {
            floatNbt.method_10548(entry.getKey(), entry.getValue().floatValue());
        }
        nbt.method_10566("floatVals", (class_2520)floatNbt);
        class_2487 intNbt = new class_2487();
        for (Map.Entry<String, Integer> entry : this.intVals.entrySet()) {
            intNbt.method_10569(entry.getKey(), entry.getValue().intValue());
        }
        nbt.method_10566("intVals", (class_2520)intNbt);
        class_2487 class_24872 = new class_2487();
        for (Map.Entry<String, Boolean> entry : this.boolVals.entrySet()) {
            class_24872.method_10556(entry.getKey(), entry.getValue().booleanValue());
        }
        nbt.method_10566("boolVals", (class_2520)class_24872);
        class_2487 class_24873 = new class_2487();
        for (Map.Entry<String, class_243> entry : this.vecVals.entrySet()) {
            class_24873.method_10566(entry.getKey(), (class_2520)Utils.vectorToNbt(entry.getValue()));
        }
        nbt.method_10566("vecVals", (class_2520)class_24873);
        class_2487 class_24874 = new class_2487();
        for (Map.Entry<String, UUID> entry : this.uuidVals.entrySet()) {
            class_24874.method_25927(entry.getKey(), entry.getValue());
        }
        nbt.method_10566("uuidVals", (class_2520)class_24874);
        class_2487 class_24875 = new class_2487();
        for (Map.Entry<String, Integer> entry : this.timerVals.entrySet()) {
            class_24875.method_10569(entry.getKey(), entry.getValue().intValue());
        }
        nbt.method_10566("timerVals", (class_2520)class_24875);
        nbt.method_10566("extras", (class_2520)this.extraVals);
    }

    public void serverTick() {
        boolean shouldSync = !this.timerVals.isEmpty();
        for (String timerKey : Set.copyOf(this.timerVals.keySet())) {
            this.timerVals.put(timerKey, this.timerVals.get(timerKey) - 1);
            if (this.timerVals.get(timerKey) != 0) continue;
            this.timerVals.remove(timerKey);
        }
        if (shouldSync) {
            this.sync();
        }
    }
}

