/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.config;

import com.pulsar.soulforge.config.SoulForgeConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHelper {
    private static boolean initalized = false;

    public static void register() {
        if (FabricLoader.getInstance().isModLoaded("cloth-config")) {
            AutoConfig.register(SoulForgeConfig.class, GsonConfigSerializer::new);
            initalized = true;
        }
    }

    public static SoulForgeConfig getConfig() {
        return (SoulForgeConfig)AutoConfig.getConfigHolder(SoulForgeConfig.class).getConfig();
    }

    public static MagicBarLocation getMagicBarLocation() {
        return initalized ? ConfigHelper.getConfig().magicBarLocation : MagicBarLocation.BOTTOM_LEFT;
    }

    public static boolean getShowValues() {
        return !initalized || ConfigHelper.getConfig().showValues;
    }

    public static boolean getDebugResetPercentages() {
        return initalized && ConfigHelper.getConfig().debugResetPercentages;
    }

    public static boolean getMagicBarHotkeying() {
        return !initalized || ConfigHelper.getConfig().magicBarHotkeying;
    }

    public static boolean getSplitHotbars() {
        return !initalized || ConfigHelper.getConfig().splitHotbars;
    }

    public static enum MagicBarLocation {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }
}

