/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.data;

import com.pulsar.soulforge.ability.AbilityBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;

public class AbilityLayout {
    public List<AbilityRow> rows;

    public AbilityLayout(List<AbilityRow> rows) {
        this.rows = rows;
    }

    public AbilityLayout() {
        this.rows = new ArrayList<AbilityRow>(Arrays.asList(new AbilityRow(), new AbilityRow(), new AbilityRow(), new AbilityRow()));
    }

    public static AbilityLayout fromBuf(List<AbilityBase> abilities, class_2540 buf) {
        AbilityLayout layout = new AbilityLayout();
        try {
            int abilityCount = buf.method_10816();
            for (int i = 0; i < abilityCount; ++i) {
                String abilityName = buf.method_19772();
                int row = buf.method_10816();
                int column = buf.method_10816();
                AbilityBase slotAbility = null;
                for (AbilityBase ability : abilities) {
                    if (!Objects.equals(ability.getID().toString(), abilityName)) continue;
                    slotAbility = ability;
                }
                layout.setSlot(slotAbility, row, column);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return layout;
    }

    public void toBuf(class_2540 buf) {
        AbilityBase ability;
        int column;
        int row;
        int abilityCount = 0;
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 9; ++column) {
                ability = this.getSlot(row, column);
                if (ability == null) continue;
                ++abilityCount;
            }
        }
        buf.method_10804(abilityCount);
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 9; ++column) {
                ability = this.getSlot(row, column);
                if (ability == null) continue;
                buf.method_10814(ability.getID().toString());
                buf.method_10804(row);
                buf.method_10804(column);
            }
        }
    }

    public static AbilityLayout fromNbt(List<AbilityBase> abilities, class_2499 list) {
        AbilityLayout layout = new AbilityLayout();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compound = list.method_10602(i);
            for (AbilityBase ability : abilities) {
                if (!Objects.equals(ability.getID().toString(), compound.method_10558("ability"))) continue;
                layout.setSlot(ability, compound.method_10550("row"), compound.method_10550("column"));
            }
        }
        return layout;
    }

    public class_2499 toNbt() {
        class_2499 list = new class_2499();
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 9; ++column) {
                AbilityBase ability = this.getSlot(row, column);
                if (ability == null) continue;
                class_2487 compound = new class_2487();
                compound.method_10582("ability", ability.getID().toString());
                compound.method_10569("row", row);
                compound.method_10569("column", column);
                list.add((Object)compound);
            }
        }
        return list;
    }

    public void setSlot(AbilityBase ability, int row, int column) {
        if (row < 0 || row >= 4 || column < 0 || column >= 9) {
            return;
        }
        this.rows.get((int)row).abilities.set(column, ability);
    }

    public AbilityBase getSlot(int row, int column) {
        if (row < 0 || row >= 4 || column < 0 || column >= 9) {
            return null;
        }
        return this.rows.get((int)row).abilities.get(column);
    }

    public static class AbilityRow {
        public List<AbilityBase> abilities;

        public AbilityRow(List<AbilityBase> abilities) {
            this.abilities = abilities;
        }

        public AbilityRow() {
            this.abilities = new ArrayList<AbilityBase>(Arrays.asList(null, null, null, null, null, null, null, null, null));
        }
    }
}

