/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.data;

import com.pulsar.soulforge.ability.AbilityBase;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class AbilityList {
    public HashMap<String, AbilityBase> abilities = new HashMap();

    public AbilityBase get(String name) {
        return this.abilities.getOrDefault(name, null);
    }

    public AbilityBase get(AbilityBase ability) {
        return this.abilities.getOrDefault(ability.getName(), null);
    }

    @Nullable
    public <T extends AbilityBase> T getTyped(T instance) {
        return (T)((AbilityBase)this.abilities.getOrDefault(this.abilities.get(instance.getName()), null));
    }

    public List<AbilityBase> getAll() {
        return List.copyOf(this.abilities.values());
    }

    public List<AbilityBase> getActive() {
        return List.copyOf(this.abilities.values().stream().filter(AbilityBase::getActive).toList());
    }

    public List<AbilityBase> getOnCooldown() {
        return List.copyOf(this.abilities.values().stream().filter(AbilityBase::onCooldown).toList());
    }

    public int getCooldown(String name) {
        if (this.get(name) == null) {
            return 0;
        }
        return this.get(name).getCooldownVal();
    }

    public int getCooldown(AbilityBase ability) {
        if (this.get(ability) == null) {
            return 0;
        }
        return this.get(ability).getCooldownVal();
    }

    public void add(AbilityBase ability) {
        this.abilities.put(ability.getName(), ability);
    }

    public void set(List<AbilityBase> abilities) {
        HashMap<String, AbilityBase> newAbilities = new HashMap<String, AbilityBase>();
        for (AbilityBase ability : abilities) {
            newAbilities.put(ability.getName(), ability);
        }
        this.abilities = newAbilities;
    }

    public boolean has(AbilityBase ability) {
        return this.abilities.containsKey(ability.getName());
    }

    public boolean has(String name) {
        return this.abilities.containsKey(name);
    }

    public void remove(String name) {
        this.abilities.remove(name);
    }

    public void remove(AbilityBase ability) {
        this.abilities.remove(ability.getName());
    }

    public boolean isActive(String name) {
        try {
            return this.get(name).getActive();
        }
        catch (NullPointerException exception) {
            return false;
        }
    }

    public boolean isActive(AbilityBase ability) {
        try {
            return this.get(ability).getActive();
        }
        catch (NullPointerException exception) {
            return false;
        }
    }
}

