/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.entity;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.entity.SoulForgeEntities;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.TeamUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BouncingShieldEntity
extends class_1676
implements GeoEntity {
    private static final class_2940<Vector3f> POSITION = class_2945.method_12791(BouncingShieldEntity.class, (class_2941)class_2943.field_42237);
    public class_1657 owner;
    private int stallTimer = 0;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BouncingShieldEntity(class_1657 owner) {
        super(SoulForgeEntities.BOUNCING_SHIELD_ENTITY_TYPE, owner.method_37908());
        this.owner = owner;
        this.method_33574(owner.method_33571());
        this.setPos(owner.method_33571());
        this.method_18799(owner.method_5720().method_1021(1.0));
    }

    public boolean method_5822() {
        return false;
    }

    public BouncingShieldEntity(class_1657 owner, class_243 position, class_243 velocity) {
        super(SoulForgeEntities.BOUNCING_SHIELD_ENTITY_TYPE, owner.method_37908());
        this.owner = owner;
        this.method_33574(position);
        this.setPos(position);
        this.method_18799(velocity);
    }

    public BouncingShieldEntity(class_1299<BouncingShieldEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693() {
        this.field_6011.method_12784(POSITION, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public void setPos(class_243 pos) {
        this.field_6011.method_12778(POSITION, (Object)pos.method_46409());
    }

    public class_243 method_19538() {
        Vector3f vec = (Vector3f)this.field_6011.method_12789(POSITION);
        return new class_243((double)vec.x, (double)vec.y, (double)vec.z);
    }

    public void method_5773() {
        class_239 hitResult;
        if (!this.method_37908().field_9236 && (hitResult = class_1675.method_49997((class_1297)this, this::method_26958)).method_17783() != class_239.class_240.field_1333) {
            this.method_7488(hitResult);
        }
        this.method_5852();
        this.method_36456(this.method_36454() + 10.0f);
        if (this.stallTimer <= 0) {
            this.setPos(this.method_19538().method_1019(this.method_18798()));
        } else {
            --this.stallTimer;
        }
        this.method_33574(this.method_19538());
    }

    protected boolean method_26958(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 targetPlayer = (class_1657)entity;
            if (this.owner != null && !TeamUtils.canDamageEntity(this.method_5682(), this.owner, (class_1309)targetPlayer)) {
                return false;
            }
        }
        return !entity.field_5960 && super.method_26958(entity) && this.owner != entity;
    }

    protected void method_7488(class_239 hitResult) {
        if (this.owner != null) {
            SoulComponent playerSoul = SoulForge.getPlayerSoul(this.owner);
            if (hitResult.method_17783() == class_239.class_240.field_1331) {
                class_3966 hit = (class_3966)hitResult;
                class_1297 class_12972 = hit.method_17782();
                if (class_12972 instanceof class_1676) {
                    class_1676 projectile = (class_1676)class_12972;
                    if (projectile.method_24921() != this.owner) {
                        projectile.method_5768();
                    } else {
                        class_1309 nearest = null;
                        for (class_1309 living : this.method_5770().method_8390(class_1309.class, class_238.method_30048((class_243)projectile.method_19538(), (double)40.0, (double)40.0, (double)40.0), target -> target != this.owner)) {
                            if (nearest == null) {
                                nearest = living;
                                continue;
                            }
                            if (!(nearest.method_5739((class_1297)projectile) > living.method_5739((class_1297)projectile))) continue;
                            nearest = living;
                        }
                        if (nearest != null) {
                            projectile.method_18799(nearest.method_19538().method_1020(projectile.method_19538()).method_1029().method_1021(projectile.method_18798().method_1033() * 1.5));
                        }
                        this.stallTimer = 4;
                    }
                } else {
                    class_12972 = hit.method_17782();
                    if (class_12972 instanceof class_1309) {
                        class_1309 living = (class_1309)class_12972;
                        living.method_5643(this.method_48923().method_48811((class_1297)this, (class_1297)this.owner), (float)playerSoul.getEffectiveLV() * 0.75f);
                    }
                }
            }
            if (playerSoul.hasTrait(Traits.kindness) && playerSoul.hasTrait(Traits.justice)) {
                class_243 normal = hitResult.method_17784().method_1020(this.method_19538()).method_1029();
                if (hitResult instanceof class_3965) {
                    class_3965 hit = (class_3965)hitResult;
                    Vector3f unitVec = hit.method_17780().method_10153().method_23955();
                    normal = new class_243((double)unitVec.x, (double)unitVec.y, (double)unitVec.z);
                }
                class_243 reflect = this.method_18798().method_1020(normal.method_1021(2.0 * this.method_18798().method_1026(normal)));
                this.method_18799(reflect);
                class_1309 target2 = this.getTarget();
                if (target2 != null) {
                    this.method_18799(target2.method_19538().method_1031(0.0, (double)(target2.method_17682() / 2.0f), 0.0).method_1020(this.method_19538()).method_1029().method_1021(1.5));
                }
            }
        }
    }

    private class_1309 getTarget() {
        for (class_1297 entity : this.method_5770().method_8335((class_1297)this, this.getAttackBox())) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 target = (class_1309)entity;
            float angle = class_3532.method_15393((float)((float)(class_3532.method_15349((double)(entity.method_23317() - this.method_23317()), (double)(entity.method_23321() - this.method_23321())) * 57.2957763671875)));
            float thisAngle = class_3532.method_15393((float)((float)(class_3532.method_15349((double)this.method_18798().field_1352, (double)this.method_18798().field_1350) * 57.2957763671875)));
            if (!target.method_33190() || !this.canSee(target) || !(Math.abs(Math.abs(thisAngle) - Math.abs(angle)) <= 10.0f)) continue;
            return target;
        }
        return null;
    }

    private boolean canSee(class_1309 entity) {
        if (entity.method_37908() != this.method_37908()) {
            return false;
        }
        class_243 vec3d = new class_243(this.method_23317(), this.method_23320(), this.method_23321());
        class_243 vec3d2 = new class_243(entity.method_23317(), entity.method_23320(), entity.method_23321());
        if (vec3d2.method_1022(vec3d) > 128.0) {
            return false;
        }
        return this.method_37908().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    protected class_238 getAttackBox() {
        return class_238.method_30048((class_243)this.method_19538(), (double)200.0, (double)10.0, (double)200.0);
    }

    protected class_238 method_33332() {
        return super.method_33332().method_989(0.0, -0.5, 0.0);
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5643(class_1282 source, float damage) {
        if (source.method_5529() == this.owner) {
            this.method_18799(this.owner.method_5720().method_1029().method_1021(1.5));
        }
        return false;
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18385((float)1.1f, (float)1.1f);
    }

    public boolean method_31746() {
        return false;
    }

    public boolean method_5640(double distance) {
        return true;
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 0, event -> PlayState.STOP)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

