/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.entity;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.block.SoulForgeBlocks;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.entity.DomePart;
import com.pulsar.soulforge.entity.SoulForgeEntities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8149;
import org.jetbrains.annotations.Nullable;

public class DomeEntity
extends class_1297
implements class_8149 {
    private static final class_2940<Float> MAX_HEALTH = class_2945.method_12791(DomeEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> HEALTH = class_2945.method_12791(DomeEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> SIZE = class_2945.method_12791(DomeEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> EMITTER = class_2945.method_12791(DomeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHIELD_BREAK_IMMUNE = class_2945.method_12791(DomeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(DomeEntity.class, (class_2941)class_2943.field_13313);
    private class_1657 owner;
    public DomePart[] parts = new DomePart[0];

    public boolean method_5822() {
        return false;
    }

    public DomeEntity(class_1937 world, class_243 position, int size, float health, class_1657 owner) {
        super(SoulForgeEntities.DOME_ENTITY_TYPE, world);
        this.method_33574(position);
        this.setMaxHealth(health);
        this.setHealth(health);
        this.setSize(size);
        this.setEmitter(false);
        this.setShieldBreakImmune(false);
        this.setOwner(owner);
    }

    public DomeEntity(class_1937 world, class_243 position, int size, float health, boolean domeEmitter, class_1657 owner) {
        super(SoulForgeEntities.DOME_ENTITY_TYPE, world);
        this.method_33574(position);
        this.setMaxHealth(health);
        this.setHealth(health);
        this.setSize(size);
        this.setEmitter(domeEmitter);
        this.setShieldBreakImmune(false);
        this.setOwner(owner);
    }

    public DomeEntity(class_1937 world, class_243 position, int size, float health, boolean domeEmitter, class_1657 owner, boolean shieldBreakImmune) {
        super(SoulForgeEntities.DOME_ENTITY_TYPE, world);
        this.method_33574(position);
        this.setMaxHealth(health);
        this.setHealth(health);
        this.setSize(size);
        this.setEmitter(domeEmitter);
        this.setShieldBreakImmune(shieldBreakImmune);
        this.setOwner(owner);
    }

    public DomeEntity(class_1299<? extends class_1297> type, class_1937 world) {
        super(type, world);
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setSize(4);
        this.setEmitter(false);
        this.setShieldBreakImmune(false);
        this.setOwner((class_1657)null);
    }

    protected void method_5693() {
        this.field_6011.method_12784(MAX_HEALTH, (Object)Float.valueOf(100.0f));
        this.field_6011.method_12784(HEALTH, (Object)Float.valueOf(100.0f));
        this.field_6011.method_12784(SIZE, (Object)4);
        this.field_6011.method_12784(EMITTER, (Object)false);
        this.field_6011.method_12784(SHIELD_BREAK_IMMUNE, (Object)false);
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
    }

    public void addPart(DomePart part) {
        ArrayList<DomePart> newParts = new ArrayList<DomePart>();
        Collections.addAll(newParts, this.parts);
        newParts.add(part);
        this.parts = newParts.toArray(new DomePart[0]);
    }

    private void setOwner(@Nullable class_1657 owner) {
        if (owner == null) {
            this.owner = null;
            return;
        }
        this.field_6011.method_12778(OWNER_UUID, Optional.of(owner.method_5667()));
        this.owner = owner;
    }

    private void setOwner(@Nullable UUID ownerUUID) {
        if (ownerUUID != null) {
            this.setOwner(this.method_37908().method_18470(ownerUUID));
        } else {
            this.owner = null;
        }
    }

    private void setMaxHealth(float health) {
        this.field_6011.method_12778(MAX_HEALTH, (Object)Float.valueOf(health));
    }

    private void setHealth(float health) {
        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(health));
    }

    private void setSize(int size) {
        this.field_6011.method_12778(SIZE, (Object)size);
    }

    private void setEmitter(boolean emitter) {
        this.field_6011.method_12778(EMITTER, (Object)emitter);
    }

    private void setShieldBreakImmune(boolean shieldBreakImmune) {
        this.field_6011.method_12778(SHIELD_BREAK_IMMUNE, (Object)shieldBreakImmune);
    }

    public class_1657 getOwner() {
        UUID uuid = ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
        return uuid != null ? this.method_37908().method_18470(uuid) : null;
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public float getMaxHealth() {
        return ((Float)this.field_6011.method_12789(MAX_HEALTH)).floatValue();
    }

    public float getHealth() {
        return ((Float)this.field_6011.method_12789(HEALTH)).floatValue();
    }

    public int getSize() {
        return (Integer)this.field_6011.method_12789(SIZE);
    }

    public boolean getEmitter() {
        return (Boolean)this.field_6011.method_12789(EMITTER);
    }

    public boolean getShieldBreakImmune() {
        return (Boolean)this.field_6011.method_12789(SHIELD_BREAK_IMMUNE);
    }

    protected void method_5749(class_2487 nbt) {
        this.setSize(nbt.method_10550("size"));
        this.setMaxHealth(nbt.method_10583("maxHealth"));
        this.setHealth(nbt.method_10583("health"));
        if (nbt.method_10545("owner")) {
            this.setOwner(nbt.method_25926("owner"));
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("size", this.getSize());
        nbt.method_10548("maxHealth", this.getMaxHealth());
        nbt.method_10548("health", this.getHealth());
        if (this.owner != null && this.getOwnerUUID() != null) {
            nbt.method_25927("owner", this.getOwnerUUID());
        }
    }

    @Nullable
    public class_1309 method_49107() {
        return null;
    }

    public void method_5773() {
        for (DomePart part : this.parts) {
            if (!part.method_5805()) continue;
            part.method_5773();
        }
        if (this.getOwnerUUID() != null && this.owner == null) {
            this.setOwner(this.getOwnerUUID());
        } else if (this.owner != null && this.owner.method_5667() != this.getOwnerUUID()) {
            this.setOwner(this.getOwnerUUID());
        }
        if (this.owner != null && (this.owner.method_29504() || this.owner.method_31481())) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15081, class_3419.field_15245, 10.0f, 1.0f);
            this.method_5650(class_1297.class_5529.field_26998);
        }
        super.method_5773();
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        if (!this.getShieldBreakImmune() && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            amount *= (float)attacker.method_26825(SoulForgeAttributes.SHIELD_BREAK);
        }
        this.setHealth(this.getHealth() - amount);
        if (this.owner != null) {
            SoulComponent playerSoul = SoulForge.getPlayerSoul(this.owner);
            playerSoul.setStyle(playerSoul.getStyle() + (int)amount);
        }
        if (source.method_5529() == this.owner && this.getEmitter()) {
            this.setHealth(-1.0f);
        }
        if (this.getHealth() <= 0.0f) {
            if (this.getEmitter()) {
                int domeRadius = this.getSize();
                for (int x = -domeRadius; x <= domeRadius; ++x) {
                    for (int y = -domeRadius; y <= domeRadius; ++y) {
                        for (int z = -domeRadius; z <= domeRadius; ++z) {
                            class_2338 pos = new class_2338(x, y, z).method_10081((class_2382)this.method_24515());
                            if (!this.method_37908().method_8320(pos).method_27852(SoulForgeBlocks.DOME_BLOCK)) continue;
                            this.method_37908().method_31595(pos, this.method_37908().method_8320(pos));
                            this.method_37908().method_8501(pos, class_2246.field_10124.method_9564());
                        }
                    }
                }
                for (DomePart part : this.getParts()) {
                    if (part.method_31481()) continue;
                    part.method_5650(class_1297.class_5529.field_26998);
                }
            }
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15081, class_3419.field_15248, 2.0f, 1.0f);
            this.method_5650(class_1297.class_5529.field_26998);
        }
        return true;
    }

    public DomePart[] getParts() {
        return this.parts;
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5640(double distance) {
        return false;
    }
}

