/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.entity;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.TemporaryModifierComponent;
import com.pulsar.soulforge.damage_type.SoulForgeDamageTypes;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.entity.SoulForgeEntities;
import com.pulsar.soulforge.entity.TotalFrostbiteEntity;
import com.pulsar.soulforge.util.Utils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SnowgraveProjectile
extends class_1297
implements GeoEntity {
    private static final class_2940<Vector3f> POSITION = class_2945.method_12791(SnowgraveProjectile.class, (class_2941)class_2943.field_42237);
    private static final class_2940<Float> DAMAGE = class_2945.method_12791(SnowgraveProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(SnowgraveProjectile.class, (class_2941)class_2943.field_13313);
    private class_1657 owner;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public SnowgraveProjectile(class_1299<? extends SnowgraveProjectile> entityType, class_1937 world) {
        super(entityType, world);
    }

    public SnowgraveProjectile(class_1657 owner, class_1937 world, class_243 pos) {
        super(SoulForgeEntities.SNOWGRAVE_PROJECTILE_TYPE, world);
        this.owner = owner;
        this.field_6011.method_12778(OWNER_UUID, Optional.of(owner.method_5667()));
        SoulComponent playerSoul = SoulForge.getPlayerSoul(owner);
        this.field_6011.method_12778(DAMAGE, (Object)Float.valueOf(playerSoul.getEffectiveLV()));
        this.field_6011.method_12778(POSITION, (Object)pos.method_46409());
        this.method_33574(pos);
    }

    protected void method_5693() {
        this.field_6011.method_12784(POSITION, (Object)new Vector3f());
        this.field_6011.method_12784(DAMAGE, (Object)Float.valueOf(20.0f));
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
    }

    public void setPos(class_243 position) {
        this.field_6011.method_12778(POSITION, (Object)position.method_46409());
    }

    public class_243 method_19538() {
        return Utils.vector3fToVec3d((Vector3f)this.field_6011.method_12789(POSITION));
    }

    public void method_5773() {
        if (this.field_6012 % 10 == 0) {
            if (this.owner == null && ((Optional)this.field_6011.method_12789(OWNER_UUID)).isPresent()) {
                this.owner = this.method_37908().method_18470((UUID)((Optional)this.field_6011.method_12789(OWNER_UUID)).get());
            } else if (this.owner != null && ((Optional)this.field_6011.method_12789(OWNER_UUID)).isPresent() && ((UUID)((Optional)this.field_6011.method_12789(OWNER_UUID)).get()).compareTo(this.owner.method_5667()) != 0) {
                this.owner = this.method_37908().method_18470((UUID)((Optional)this.field_6011.method_12789(OWNER_UUID)).get());
            }
            if (this.owner != null) {
                for (class_1297 entity : this.method_37908().method_8335((class_1297)this, this.method_5829())) {
                    class_1282 source;
                    class_1309 living;
                    if (!(entity instanceof class_1309) || !(living = (class_1309)entity).method_5643(source = SoulForgeDamageTypes.of(this.owner, this.method_37908(), SoulForgeDamageTypes.ABILITY_PROJECTILE_DAMAGE_TYPE), ((Float)this.field_6011.method_12789(DAMAGE)).floatValue()) || this.owner == null) continue;
                    SoulComponent playerSoul = SoulForge.getPlayerSoul(this.owner);
                    playerSoul.setStyle(playerSoul.getStyle() + ((Float)this.field_6011.method_12789(DAMAGE)).intValue());
                    TemporaryModifierComponent modifiers = SoulForge.getTemporaryModifiers(living);
                    modifiers.addStackingTemporaryModifier(class_5134.field_23719, new class_1322(UUID.fromString("4e72a713-f496-41e2-a5d1-9ed15e75b4dc"), "proceed", (double)((float)(-playerSoul.getEffectiveLV()) * 0.02f), class_1322.class_1323.field_6330), 200.0f);
                    modifiers.addStackingTemporaryModifier(SoulForgeAttributes.AIR_SPEED_BECAUSE_MOJANG_SUCKS, new class_1322(UUID.fromString("4e72a713-f496-41e2-a5d1-9ed15e75b4dc"), "proceed", (double)((float)(-playerSoul.getEffectiveLV()) * 0.02f), class_1322.class_1323.field_6330), 200.0f);
                    modifiers.addStackingTemporaryModifier(class_5134.field_23719, new class_1322(UUID.fromString("4e72a713-f496-41e2-a5d1-9ed15e75b4dc"), "proceed", (double)((float)(-playerSoul.getEffectiveLV()) * 0.02f), class_1322.class_1323.field_6331), 200.0f);
                    modifiers.addStackingTemporaryModifier(SoulForgeAttributes.AIR_SPEED_BECAUSE_MOJANG_SUCKS, new class_1322(UUID.fromString("4e72a713-f496-41e2-a5d1-9ed15e75b4dc"), "proceed", (double)((float)(-playerSoul.getEffectiveLV()) * 0.02f), class_1322.class_1323.field_6331), 200.0f);
                    modifiers.addStackingTemporaryModifier(class_5134.field_23721, new class_1322(UUID.fromString("4e72a713-f496-41e2-a5d1-9ed15e75b4dc"), "proceed", (double)((float)(-playerSoul.getEffectiveLV()) * 0.02f), class_1322.class_1323.field_6331), 200.0f);
                    if (this.field_6012 < 55) continue;
                    living.method_6092(new class_1293(SoulForgeEffects.FROSTBITE, playerSoul.getEffectiveLV() * 10, (int)((float)playerSoul.getEffectiveLV() / 5.0f)));
                    living.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15081, class_3419.field_15248, 1.0f, 1.0f);
                    TotalFrostbiteEntity frostbite = new TotalFrostbiteEntity(living.method_37908(), living.method_19538(), 20.0f, living, this.owner);
                    frostbite.maxHealth = 20.0f;
                    frostbite.health = 20.0f;
                    frostbite.method_33574(entity.method_19538());
                    frostbite.setEntity(living);
                    frostbite.setSize((float)Math.max(entity.method_5829().method_17939(), entity.method_5829().method_17941()), (float)entity.method_5829().method_17940());
                    this.method_37908().method_8649((class_1297)frostbite);
                    entity.method_5684(true);
                }
            }
        }
        if (this.field_6012 >= 59) {
            this.method_5768();
        }
    }

    public boolean method_5822() {
        return false;
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("snowgrave.main", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

