/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.item;

import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.block.SoulForgeBlocks;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.data.AbilityLayout;
import com.pulsar.soulforge.entity.PlayerSoulEntity;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class SoulJarItem
extends class_1747 {
    public SoulJarItem() {
        super(SoulForgeBlocks.SOUL_JAR, (class_1792.class_1793)new FabricItemSettings().maxCount(1));
    }

    public class_1269 method_7884(class_1838 context) {
        if (Objects.requireNonNull(context.method_8036()).method_5715()) {
            return super.method_7884(context);
        }
        class_1269 useResult = this.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467();
        return useResult == class_1269.field_21466 ? class_1269.field_33562 : useResult;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1297 class_12972;
        class_3966 hit;
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236 && (hit = Utils.getFocussedEntity(user, (float)ReachEntityAttributes.getReachDistance((class_1309)user, (double)3.0), entity -> entity instanceof PlayerSoulEntity)) != null && (class_12972 = hit.method_17782()) instanceof PlayerSoulEntity) {
            PlayerSoulEntity soulEntity = (PlayerSoulEntity)class_12972;
            SoulJarItem.setHasSoul(stack, true);
            SoulJarItem.setOwner(stack, soulEntity.getOwner());
            SoulJarItem.setTrait1(stack, soulEntity.getTrait1());
            SoulJarItem.setTrait2(stack, soulEntity.getTrait2());
            SoulJarItem.setStrong(stack, soulEntity.getStrong());
            SoulJarItem.setPure(stack, soulEntity.getPure());
            SoulJarItem.setLv(stack, soulEntity.getLV());
            SoulJarItem.setExp(stack, soulEntity.getEXP());
            SoulJarItem.setLayout(stack, new AbilityLayout());
            soulEntity.method_5768();
        }
        return class_1271.method_22428((Object)stack);
    }

    public static void setFromPlayer(class_1799 stack, class_1657 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul(player);
        SoulJarItem.setHasSoul(stack, true);
        SoulJarItem.setOwner(stack, player.method_5477().getString());
        if (!playerSoul.getTraits().isEmpty()) {
            SoulJarItem.setTrait1(stack, playerSoul.getTrait(0).getName());
            if (playerSoul.getTraitCount() == 2) {
                SoulJarItem.setTrait2(stack, playerSoul.getTrait(1).getName());
            } else {
                SoulJarItem.setTrait2(stack, "");
            }
        }
        SoulJarItem.setStrong(stack, playerSoul.isStrong());
        SoulJarItem.setPure(stack, playerSoul.isPure());
        SoulJarItem.setLv(stack, playerSoul.getLV());
        SoulJarItem.setExp(stack, playerSoul.getEXP());
        SoulJarItem.setLayout(stack, playerSoul.getAbilityLayout());
        if (SoulJarItem.getJarNbt(stack).method_10545("old")) {
            SoulJarItem.getJarNbt(stack).method_10551("old");
        }
    }

    public static class_2487 getJarNbt(class_1799 stack) {
        class_2487 nbt = class_1747.method_38072((class_1799)stack);
        if (nbt == null) {
            return new class_2487();
        }
        return nbt;
    }

    public static void setHasSoul(class_1799 stack, boolean value) {
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10556("hasSoul", value);
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static boolean getHasSoul(class_1799 stack) {
        return SoulJarItem.getJarNbt(stack).method_10545("soul");
    }

    public static void setOwner(class_1799 stack, String value) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            SoulJarItem.getJarNbt(stack).method_10566("soul", (class_2520)new class_2487());
        }
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10562("soul").method_10582("owner", value);
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static String getOwner(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            return "";
        }
        return SoulJarItem.getJarNbt(stack).method_10562("soul").method_10558("owner");
    }

    public static void setTrait1(class_1799 stack, String value) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            SoulJarItem.getJarNbt(stack).method_10566("soul", (class_2520)new class_2487());
        }
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10562("soul").method_10582("trait1", value);
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static String getTrait1(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            return "";
        }
        return SoulJarItem.getJarNbt(stack).method_10562("soul").method_10558("trait1");
    }

    public static void setTrait2(class_1799 stack, String value) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            SoulJarItem.getJarNbt(stack).method_10566("soul", (class_2520)new class_2487());
        }
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10562("soul").method_10582("trait2", value);
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static String getTrait2(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            return "";
        }
        return SoulJarItem.getJarNbt(stack).method_10562("soul").method_10558("trait2");
    }

    public static void setStrong(class_1799 stack, boolean value) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            SoulJarItem.getJarNbt(stack).method_10566("soul", (class_2520)new class_2487());
        }
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10562("soul").method_10556("strong", value);
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static boolean getStrong(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            return false;
        }
        return SoulJarItem.getJarNbt(stack).method_10562("soul").method_10577("strong");
    }

    public static void setPure(class_1799 stack, boolean value) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            SoulJarItem.getJarNbt(stack).method_10566("soul", (class_2520)new class_2487());
        }
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10562("soul").method_10556("pure", value);
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static boolean getPure(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            return false;
        }
        return SoulJarItem.getJarNbt(stack).method_10562("soul").method_10577("pure");
    }

    public static void setLv(class_1799 stack, int value) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            SoulJarItem.getJarNbt(stack).method_10566("soul", (class_2520)new class_2487());
        }
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10562("soul").method_10569("lv", value);
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static int getLv(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            return 0;
        }
        return SoulJarItem.getJarNbt(stack).method_10562("soul").method_10550("lv");
    }

    public static void setExp(class_1799 stack, int value) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            SoulJarItem.getJarNbt(stack).method_10566("soul", (class_2520)new class_2487());
        }
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10562("soul").method_10569("exp", value);
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static int getExp(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            return 0;
        }
        return SoulJarItem.getJarNbt(stack).method_10562("soul").method_10550("exp");
    }

    public static void setLayout(class_1799 stack, AbilityLayout layout) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            SoulJarItem.getJarNbt(stack).method_10566("soul", (class_2520)new class_2487());
        }
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10562("soul").method_10566("layout", (class_2520)layout.toNbt());
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static AbilityLayout getLayout(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("soul")) {
            return null;
        }
        String trait1 = SoulJarItem.getJarNbt(stack).method_10562("soul").method_10558("trait1");
        String trait2 = SoulJarItem.getJarNbt(stack).method_10562("soul").method_10558("trait2");
        int lv = SoulJarItem.getJarNbt(stack).method_10562("soul").method_10550("lv");
        boolean pure = SoulJarItem.getJarNbt(stack).method_10562("soul").method_10577("pure");
        ArrayList<TraitBase> traits = new ArrayList<TraitBase>();
        if (!Objects.equals(trait1, "")) {
            traits.add(Traits.get(trait1));
        }
        if (!Objects.equals(trait2, "")) {
            traits.add(Traits.get(trait2));
        }
        List<AbilityBase> abilities = Traits.getAbilities(traits, lv, pure, false);
        return AbilityLayout.fromNbt(abilities, SoulJarItem.getJarNbt(stack).method_10562("soul").method_10554("layout", 10));
    }

    public static void setOldJar(class_1799 stack, class_1799 old) {
        class_2487 nbt = SoulJarItem.getJarNbt(stack);
        nbt.method_10566("old", (class_2520)old.method_7953(new class_2487()));
        class_1747.method_38073((class_1799)stack, SoulForgeBlocks.SOUL_JAR_BLOCK_ENTITY, (class_2487)nbt);
    }

    public static class_1799 getOldJar(class_1799 stack) {
        if (!SoulJarItem.getJarNbt(stack).method_10545("old")) {
            return null;
        }
        return class_1799.method_7915((class_2487)SoulJarItem.getJarNbt(stack).method_10562("old"));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (SoulJarItem.getHasSoul(stack)) {
            tooltip.add((class_2561)class_2561.method_43470((String)SoulJarItem.getOwner(stack)));
            Object ttString = "";
            if (SoulJarItem.getPure(stack)) {
                ttString = (String)ttString + "Pure ";
            } else if (SoulJarItem.getStrong(stack)) {
                ttString = (String)ttString + "Strong ";
            }
            ttString = (String)ttString + SoulJarItem.getTrait1(stack);
            if (!Objects.equals(SoulJarItem.getTrait2(stack), "")) {
                ttString = (String)ttString + "-" + SoulJarItem.getTrait2(stack);
            }
            ttString = (String)ttString + ": LV " + SoulJarItem.getLv(stack);
            tooltip.add((class_2561)class_2561.method_43470((String)ttString));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"Empty"));
        }
    }
}

