/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.item.devices;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.item.TraitedArniciteCoreItem;
import com.pulsar.soulforge.item.TraitedArniciteHeartItem;
import com.pulsar.soulforge.item.TraitedArniciteItem;
import com.pulsar.soulforge.item.devices.DeviceBase;
import com.pulsar.soulforge.trait.TraitBase;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class PickaxeDeviceBase
extends class_1810 {
    public final int maxCharge;
    public final TraitBase trait;

    public PickaxeDeviceBase(class_1792.class_1793 settings, int maxCharge, TraitBase trait, float attackDamage, float attackSpeed, class_1832 material) {
        super(material, (int)attackDamage, attackSpeed, settings);
        this.maxCharge = maxCharge;
        this.trait = trait;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236 && this.getCharge(stack) < this.maxCharge) {
            class_1799 offhand = user.method_6079();
            class_1792 class_17922 = offhand.method_7909();
            if (class_17922 instanceof TraitedArniciteItem) {
                TraitedArniciteItem item = (TraitedArniciteItem)class_17922;
                if (item.trait != this.trait) {
                    return class_1271.method_22430((Object)user.method_5998(hand));
                }
                offhand.method_7934(1);
                this.increaseCharge(stack, 50);
                return class_1271.method_22427((Object)user.method_5998(hand));
            }
            class_17922 = offhand.method_7909();
            if (class_17922 instanceof TraitedArniciteHeartItem) {
                TraitedArniciteHeartItem item = (TraitedArniciteHeartItem)class_17922;
                if (item.trait != this.trait) {
                    return class_1271.method_22430((Object)user.method_5998(hand));
                }
                offhand.method_7934(1);
                this.increaseCharge(stack, 100);
                return class_1271.method_22427((Object)user.method_5998(hand));
            }
            class_17922 = offhand.method_7909();
            if (class_17922 instanceof TraitedArniciteCoreItem) {
                TraitedArniciteCoreItem item = (TraitedArniciteCoreItem)class_17922;
                if (item.trait != this.trait) {
                    return class_1271.method_22430((Object)user.method_5998(hand));
                }
                offhand.method_7934(1);
                this.increaseCharge(stack, 1000);
                return class_1271.method_22427((Object)user.method_5998(hand));
            }
        }
        return class_1271.method_22430((Object)user.method_5998(hand));
    }

    public int getCharge(class_1799 stack) {
        return stack.method_7909() instanceof DeviceBase || stack.method_7909() instanceof PickaxeDeviceBase && stack.method_7985() && stack.method_7969().method_10545("charge") ? stack.method_7969().method_10550("charge") : 0;
    }

    public void setCharge(class_1799 stack, int charge) {
        if (stack.method_7909() instanceof DeviceBase || stack.method_7909() instanceof PickaxeDeviceBase) {
            if (!stack.method_7985()) {
                stack.method_7948();
            }
            stack.method_7969().method_10569("charge", Math.min(Math.max(charge, 0), this.maxCharge));
        }
    }

    public void increaseCharge(class_1799 stack, int amount) {
        this.setCharge(stack, this.getCharge(stack) + amount);
    }

    public void decreaseCharge(class_1799 stack, int amount) {
        this.setCharge(stack, this.getCharge(stack) - amount);
    }

    public void tryCharge(class_1657 player) {
        int magic;
        SoulComponent playerSoul;
        class_1799 stack;
        if (player.method_6047().method_7909() instanceof DeviceBase || player.method_6047().method_7909() instanceof PickaxeDeviceBase) {
            stack = player.method_6047();
        } else if (player.method_6079().method_7909() instanceof DeviceBase || player.method_6047().method_7909() instanceof PickaxeDeviceBase) {
            stack = player.method_6079();
        } else {
            return;
        }
        if (this.getCharge(stack) < this.maxCharge && (playerSoul = SoulForge.getPlayerSoul(player)).hasTrait(this.trait) && playerSoul.tryConsumeMagic(magic = class_3532.method_15375((float)Math.min(playerSoul.getMagic(), Math.min(10.0f, (float)(this.maxCharge - this.getCharge(stack))))))) {
            this.increaseCharge(stack, magic);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.soulforge.charge_tooltip").method_27693(": " + this.getCharge(stack) + "/" + this.maxCharge));
    }

    public boolean method_7846() {
        return false;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }
}

