/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.item.devices.devices;

import com.pulsar.soulforge.client.item.GeoMagicItemRenderer;
import com.pulsar.soulforge.entity.JusticePelletProjectile;
import com.pulsar.soulforge.item.devices.DeviceBase;
import com.pulsar.soulforge.item.special.CrushingRound;
import com.pulsar.soulforge.item.special.FrostbiteRound;
import com.pulsar.soulforge.item.special.PuncturingRound;
import com.pulsar.soulforge.item.special.SuppressingRound;
import com.pulsar.soulforge.sounds.SoulForgeSounds;
import com.pulsar.soulforge.trait.Traits;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3419;
import net.minecraft.class_756;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;

public class JusticeGun
extends DeviceBase
implements GeoItem {
    public AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public JusticeGun() {
        super((class_1792.class_1793)new FabricItemSettings().maxCount(1).rarity(class_1814.field_8903), 300, Traits.justice);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1271<class_1799> result = super.method_7836(world, user, hand);
        if (result.method_5467().method_23665()) {
            return result;
        }
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            int ammo = 0;
            class_2487 stackNbt = stack.method_7948();
            if (stackNbt.method_10545("ammo")) {
                ammo = stack.method_7969().method_10550("ammo");
            } else {
                stackNbt.method_10569("ammo", 0);
            }
            if (stackNbt.method_10545("reloadedCount")) {
                ammo = Math.max(stackNbt.method_10550("reloadedCount"), ammo);
            }
            if (ammo > 0) {
                JusticePelletProjectile projectile = new JusticePelletProjectile(world, (class_1309)user);
                if (stackNbt.method_10545("reloaded") && stackNbt.method_10545("reloadedCount") && stackNbt.method_10550("reloadedCount") > 0) {
                    projectile = switch (stack.method_7948().method_10558("reloaded")) {
                        case "frostbite" -> FrostbiteRound.createPellet(world, (class_1309)user, 0.16666667f);
                        case "crushing" -> CrushingRound.createPellet(world, (class_1309)user, 0.16666667f);
                        case "puncturing" -> PuncturingRound.createPellet(world, (class_1309)user, 0.16666667f);
                        case "suppressing" -> SuppressingRound.createPellet(world, (class_1309)user, 0.16666667f);
                        default -> projectile;
                    };
                    stackNbt.method_10569("reloadedCount", stackNbt.method_10550("reloadedCount") - 1);
                    if (stackNbt.method_10550("reloadedCount") <= 0) {
                        stackNbt.method_10556("reloaded", false);
                    }
                }
                projectile.setPos(user.method_33571());
                projectile.setVel(user.method_5720().method_1021(8.0));
                world.method_8649((class_1297)projectile);
                world.method_43129(null, (class_1297)user, SoulForgeSounds.GUN_SHOOT_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                user.method_7357().method_7906((class_1792)this, 10);
                stack.method_7969().method_10569("ammo", ammo - 1);
                return class_1271.method_22428((Object)user.method_5998(hand));
            }
            if (this.getCharge(stack) > 0) {
                this.reload(stack, user);
                return class_1271.method_22427((Object)user.method_5998(hand));
            }
        }
        return class_1271.method_22431((Object)stack);
    }

    public void reload(class_1799 stack, class_1657 user) {
        if (this.getCharge(stack) > 0) {
            int ammo = 0;
            stack.method_7948();
            if (stack.method_7969().method_10545("ammo")) {
                ammo = stack.method_7969().method_10550("ammo");
            }
            int toRefill = 12 - ammo;
            stack.method_7969().method_10569("ammo", ammo += Math.min(toRefill, this.getCharge(stack)));
            this.decreaseCharge(stack, Math.min(toRefill, this.getCharge(stack)));
            user.method_7357().method_7906((class_1792)this, 20);
        }
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final GeoMagicItemRenderer<JusticeGun> renderer = new GeoMagicItemRenderer("justice_gun", "justice");

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, animationState -> PlayState.STOP)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

