/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.item.devices.machines;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.client.item.GeoMagicItemRenderer;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.ValueComponent;
import com.pulsar.soulforge.damage_type.SoulForgeDamageTypes;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.item.devices.DeviceBase;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.Utils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5134;
import net.minecraft.class_756;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;

public class DeterminationInjector
extends DeviceBase
implements GeoItem {
    public AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public DeterminationInjector() {
        super((class_1792.class_1793)new FabricItemSettings().maxCount(1).rarity(class_1814.field_8904), 1000, Traits.determination);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1271<class_1799> result = super.method_7836(world, user, hand);
        if (result.method_5467().method_23665()) {
            return result;
        }
        class_1799 stack = user.method_5998(hand);
        if (this.getCharge(stack) > 1 && !world.field_9236) {
            if (!stack.method_7948().method_10545("timer")) {
                stack.method_7948().method_10569("timer", 0);
            }
            int timer = stack.method_7948().method_10550("timer");
            SoulComponent playerSoul = SoulForge.getPlayerSoul(user);
            ValueComponent values = SoulForge.getValues((class_1309)user);
            class_2487 nbt = stack.method_7948();
            if (!nbt.method_10545("active")) {
                nbt.method_10556("active", false);
            }
            if (nbt.method_10577("active")) {
                values.removeBool("injected");
            } else {
                if (values.getBool("injected")) {
                    return super.method_7836(world, user, hand);
                }
                values.setBool("injected", true);
            }
            nbt.method_10556("active", !nbt.method_10577("active"));
            if (values.getBool("injected")) {
                Utils.clearModifiersByName((class_1309)user, SoulForgeAttributes.MAGIC_POWER, "dt_injector");
                user.method_5996(SoulForgeAttributes.MAGIC_POWER).method_26837(new class_1322("dt_injector", 0.5, class_1322.class_1323.field_6328));
                if (!playerSoul.hasTrait(Traits.determination)) {
                    Utils.clearModifiersByName((class_1309)user, class_5134.field_23716, "dt_injector_health");
                    Utils.clearModifiersByName((class_1309)user, class_5134.field_23721, "dt_injector_strength");
                    class_1322 healthModifier = new class_1322("dt_injector_health", 5.0, class_1322.class_1323.field_6328);
                    class_1322 strengthModifier = new class_1322("dt_injector_strength", (double)0.175f, class_1322.class_1323.field_6331);
                    user.method_5996(class_5134.field_23716).method_26837(healthModifier);
                    user.method_5996(class_5134.field_23721).method_26837(strengthModifier);
                }
                stack.method_7948().method_10569("timer", 0);
            } else {
                if (!playerSoul.hasTrait(Traits.determination)) {
                    user.method_5643(SoulForgeDamageTypes.of(world, SoulForgeDamageTypes.INJECTOR_DAMAGE_TYPE), (float)timer / 500.0f);
                    user.method_6092(new class_1293(SoulForgeEffects.MANA_SICKNESS, timer / 4, timer / 4000));
                    user.method_6092(new class_1293(class_1294.field_5909, timer / 4, timer / 4000));
                    user.method_6092(new class_1293(class_1294.field_5911, timer / 4, timer / 4000));
                }
                stack.method_7948().method_10569("timer", 0);
                Utils.clearModifiersByName((class_1309)user, SoulForgeAttributes.MAGIC_POWER, "dt_injector");
                Utils.clearModifiersByName((class_1309)user, class_5134.field_23716, "dt_injector_health");
                Utils.clearModifiersByName((class_1309)user, class_5134.field_23721, "dt_injector_strength");
            }
        }
        return class_1271.method_22431((Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && stack.method_7948().method_10545("active") && stack.method_7948().method_10577("active")) {
            int timer;
            if (!stack.method_7948().method_10545("timer")) {
                stack.method_7948().method_10569("timer", 0);
            }
            if ((timer = stack.method_7948().method_10550("timer")) > 0 && timer % 20 == 0) {
                this.decreaseCharge(stack, 1);
                if (this.getCharge(stack) <= 0) {
                    stack.method_7934(1);
                    world.method_8437(entity, entity.method_23317(), entity.method_23318(), entity.method_23321(), 5.0f, class_1937.class_7867.field_40888);
                    if (entity instanceof class_1309) {
                        class_1309 living = (class_1309)entity;
                        living.method_6066().method_5547(SoulForgeDamageTypes.of(world, SoulForgeDamageTypes.DETERMINATION_STAR_DAMAGE_TYPE), 0.0f);
                        living.method_5768();
                    }
                }
            }
            stack.method_7948().method_10569("timer", timer + 1);
        }
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final GeoMagicItemRenderer<DeterminationInjector> renderer = new GeoMagicItemRenderer("determination_injector", "determination_injector");

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, animationState -> PlayState.STOP)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

