/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.item.devices.trinkets;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.item.SoulJarItem;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

public class TraitTunerItem
extends class_1792 {
    public static Map<TraitBase, String> traitKeys = Map.of(Traits.bravery, "Bravery", Traits.justice, "Justice", Traits.kindness, "Kindness", Traits.patience, "Patience", Traits.integrity, "Integrity", Traits.perseverance, "Perseverance");
    public static Map<TraitBase, class_1792> traitItems = Map.of(Traits.bravery, SoulForgeItems.BRAVERY_ESSENCE, Traits.justice, SoulForgeItems.JUSTICE_ESSENCE, Traits.kindness, SoulForgeItems.KINDNESS_ESSENCE, Traits.patience, SoulForgeItems.PATIENCE_ESSENCE, Traits.integrity, SoulForgeItems.INTEGRITY_ESSENCE, Traits.perseverance, SoulForgeItems.PERSEVERANCE_ESSENCE);

    public TraitTunerItem() {
        super((class_1792.class_1793)new FabricItemSettings().maxCount(1));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)"soulforge.trait_tuner.description").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        int braveryChance = (int)(100.0f * (float)this.getAmount(stack, "Bravery") / 15.0f);
        int justiceChance = (int)(100.0f * (float)this.getAmount(stack, "Justice") / 15.0f);
        int kindnessChance = (int)(100.0f * (float)this.getAmount(stack, "Kindness") / 15.0f);
        int patienceChance = (int)(100.0f * (float)this.getAmount(stack, "Patience") / 15.0f);
        int integrityChance = (int)(100.0f * (float)this.getAmount(stack, "Integrity") / 15.0f);
        int perseveranceChance = (int)(100.0f * (float)this.getAmount(stack, "Perseverance") / 15.0f);
        int determinationChance = (int)(100.0f * this.getDTChance(stack));
        class_5250 chances1 = class_2561.method_43473();
        class_5250 chances2 = class_2561.method_43473();
        chances1.method_10852((class_2561)class_2561.method_43470((String)String.format("%d%%   ", braveryChance)).method_10862(class_2583.field_24360.method_36139(Traits.bravery.getColor())));
        chances1.method_10852((class_2561)class_2561.method_43470((String)String.format("%d%%   ", justiceChance)).method_10862(class_2583.field_24360.method_36139(Traits.justice.getColor())));
        chances1.method_10852((class_2561)class_2561.method_43470((String)String.format("%d%%", kindnessChance)).method_10862(class_2583.field_24360.method_36139(Traits.kindness.getColor())));
        chances2.method_10852((class_2561)class_2561.method_43470((String)String.format("%d%%   ", patienceChance)).method_10862(class_2583.field_24360.method_36139(Traits.patience.getColor())));
        chances2.method_10852((class_2561)class_2561.method_43470((String)String.format("%d%%   ", integrityChance)).method_10862(class_2583.field_24360.method_36139(Traits.integrity.getColor())));
        chances2.method_10852((class_2561)class_2561.method_43470((String)String.format("%d%%", perseveranceChance)).method_10862(class_2583.field_24360.method_36139(Traits.perseverance.getColor())));
        tooltip.add((class_2561)chances1);
        tooltip.add((class_2561)chances2);
        if (determinationChance != 0) {
            tooltip.add((class_2561)class_2561.method_43470((String)String.format("%d%%", determinationChance)).method_10862(class_2583.field_24360.method_36139(Traits.determination.getColor())));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public float getDTChance(class_1799 stack) {
        int minimum = 100;
        int maximum = 0;
        int total = 0;
        for (String key : traitKeys.values()) {
            int value = this.getAmount(stack, key);
            minimum = Math.min(minimum, value);
            maximum = Math.max(maximum, value);
            total += value;
        }
        if (Math.abs(maximum - minimum) <= 4) {
            return (float)total / 60.0f;
        }
        return 0.0f;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 items = class_2371.method_10211();
        for (TraitBase trait : traitKeys.keySet()) {
            String key = traitKeys.get(trait);
            class_1792 item = traitItems.get(trait);
            if (this.getAmount(stack, key) <= 0) continue;
            items.add((Object)new class_1799((class_1935)item, this.getAmount(stack, key)));
        }
        return Optional.of(new class_5631(items, items.size()));
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014) {
            String traitKey = null;
            for (TraitBase trait : traitKeys.keySet()) {
                String key = traitKeys.get(trait);
                class_1792 item = traitItems.get(trait);
                if (!otherStack.method_31574(item)) continue;
                traitKey = key;
            }
            if (traitKey != null) {
                otherStack.method_7934(1);
                this.incrementAmount(stack, traitKey, 1);
                return true;
            }
        }
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    /*
     * WARNING - void declaration
     */
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236) {
            class_1799 jar;
            class_1799 stack = user.method_5998(hand);
            if (hand == class_1268.field_5808 && user.method_5998(class_1268.field_5810).method_31574(SoulForgeItems.SOUL_JAR) && !SoulJarItem.getHasSoul(jar = user.method_5998(class_1268.field_5810))) {
                SoulJarItem.setFromPlayer(jar, user);
            }
            SoulComponent playerSoul = SoulForge.getPlayerSoul(user);
            playerSoul.softReset();
            playerSoul.setStrong(false);
            playerSoul.setPure(false);
            Random random = new Random();
            float determinationChance = this.getDTChance(stack);
            if (random.nextFloat() <= determinationChance) {
                playerSoul.setTraits(List.of(Traits.determination));
                user.method_6122(hand, class_1799.field_8037);
                return super.method_7836(world, user, hand);
            }
            ArrayList<TraitBase> pures = new ArrayList<TraitBase>();
            for (Map.Entry<TraitBase, String> traitEntry : traitKeys.entrySet()) {
                if (this.getAmount(stack, traitEntry.getValue()) < 50) continue;
                pures.add((TraitBase)traitEntry.getKey());
            }
            if (!pures.isEmpty()) {
                TraitBase trait = (TraitBase)pures.get(random.nextInt(pures.size()));
                playerSoul.setPure(true);
                playerSoul.setTraits(List.of(trait));
                user.method_6122(hand, class_1799.field_8037);
                return super.method_7836(world, user, hand);
            }
            ArrayList<TraitBase> guaranteed = new ArrayList<TraitBase>();
            for (Map.Entry entry : traitKeys.entrySet()) {
                if (this.getAmount(stack, (String)entry.getValue()) < 15) continue;
                guaranteed.add((TraitBase)entry.getKey());
            }
            if (!guaranteed.isEmpty()) {
                void var11_14;
                TraitBase trait = (TraitBase)guaranteed.get(random.nextInt(guaranteed.size()));
                boolean bl = false;
                for (Map.Entry<TraitBase, String> traitEntry : traitKeys.entrySet()) {
                    if (trait != traitEntry.getKey()) continue;
                    var11_14 += this.getAmount(stack, traitEntry.getValue());
                }
                if (random.nextFloat() <= (float)var11_14 / 50.0f) {
                    playerSoul.setPure(true);
                    playerSoul.setTraits(List.of(trait));
                    user.method_6122(hand, class_1799.field_8037);
                    return super.method_7836(world, user, hand);
                }
                if (guaranteed.size() >= 2) {
                    TraitBase trait2 = (TraitBase)guaranteed.get(random.nextInt(guaranteed.size()));
                    while (trait == trait2) {
                        trait2 = (TraitBase)guaranteed.get(random.nextInt(guaranteed.size()));
                    }
                    void var11_15 = var11_14 + this.getAmount(stack, traitKeys.get(trait2));
                    if (random.nextFloat() <= (float)var11_15 / 40.0f) {
                        playerSoul.setStrong(true);
                    }
                    playerSoul.setTraits(List.of(trait, trait2));
                } else {
                    if (random.nextFloat() <= (float)var11_14 / 40.0f) {
                        playerSoul.setStrong(true);
                    }
                    playerSoul.setTraits(List.of(trait));
                }
            } else {
                int i;
                float total = 0.0f;
                List list = traitKeys.entrySet().stream().toList();
                for (Map.Entry key : list) {
                    total += (float)this.getAmount(stack, (String)key.getValue()) / 18.0f + 0.16666667f;
                }
                float val = random.nextFloat() * total;
                for (i = 0; i < traitKeys.size() - 1 && !((val -= (float)this.getAmount(stack, (String)((Map.Entry)list.get(i)).getValue()) / 18.0f + 0.16666667f) <= 0.0f); ++i) {
                }
                TraitBase trait = (TraitBase)((Map.Entry)list.get(i)).getKey();
                int affectedTotal = 0;
                for (Map.Entry<TraitBase, String> traitEntry : traitKeys.entrySet()) {
                    if (trait != traitEntry.getKey()) continue;
                    affectedTotal += this.getAmount(stack, traitEntry.getValue());
                }
                if (random.nextFloat() <= (float)affectedTotal / 50.0f) {
                    playerSoul.setPure(true);
                    playerSoul.setTraits(List.of(trait));
                    user.method_6122(hand, class_1799.field_8037);
                    return super.method_7836(world, user, hand);
                }
                for (Map.Entry<TraitBase, String> entry : traitKeys.entrySet()) {
                    if (entry.getKey() == trait || !(random.nextFloat() <= (float)this.getAmount(stack, entry.getValue()) / 15.0f)) continue;
                    affectedTotal += this.getAmount(stack, entry.getValue());
                    if (random.nextFloat() <= (float)affectedTotal / 40.0f) {
                        playerSoul.setStrong(true);
                    }
                    playerSoul.setTraits(List.of(trait, entry.getKey()));
                    user.method_6122(hand, class_1799.field_8037);
                    return super.method_7836(world, user, hand);
                }
                if (random.nextFloat() <= (float)affectedTotal / 40.0f) {
                    playerSoul.setStrong(true);
                }
                playerSoul.setTraits(List.of(trait));
            }
            user.method_6122(hand, class_1799.field_8037);
        }
        return super.method_7836(world, user, hand);
    }

    public int getAmount(class_1799 stack, String trait) {
        if (stack.method_7948().method_10545(trait)) {
            return stack.method_7948().method_10550(trait);
        }
        return 0;
    }

    public void setAmount(class_1799 stack, String trait, int amount) {
        stack.method_7948().method_10569(trait, amount);
    }

    public void incrementAmount(class_1799 stack, String trait, int amount) {
        this.setAmount(stack, trait, this.getAmount(stack, trait) + amount);
    }
}

