/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.mixin;

import com.pulsar.soulforge.item.devices.machines.SiphonImbuer;
import com.pulsar.soulforge.item.special.CrushingRound;
import com.pulsar.soulforge.item.special.FrostbiteRound;
import com.pulsar.soulforge.item.special.PuncturingRound;
import com.pulsar.soulforge.item.special.SuppressingRound;
import com.pulsar.soulforge.siphon.Siphon;
import com.pulsar.soulforge.util.Utils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1744;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1764.class})
public abstract class CrossbowItemMixin {
    @Shadow
    @Final
    private static String field_30865;

    @ModifyArgs(method={"shootAll"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/CrossbowItem;shoot(Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/util/Hand;Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;FZFFF)V"))
    private static void modifyProjectileSpeed(Args args) {
        Siphon.Type type;
        class_1799 stack = (class_1799)args.get(3);
        if (stack.method_7985() && stack.method_7969().method_10545("Siphon") && ((type = Siphon.Type.getSiphon(stack.method_7969().method_10558("Siphon"))) == Siphon.Type.BRAVERY || type == Siphon.Type.SPITE)) {
            args.set(7, (Object)Float.valueOf(((Float)args.get(7)).floatValue() * 1.2f));
        }
        if (stack.method_7969() != null && stack.method_7969().method_10577("imbued")) {
            args.set(7, (Object)Float.valueOf(((Float)args.get(7)).floatValue() * 2.0f));
        }
    }

    @Inject(method={"getPullTime"}, at={@At(value="RETURN")}, cancellable=true)
    private static void modifyPullTime(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        if (stack.method_7969() != null && stack.method_7969().method_10577("imbued")) {
            cir.setReturnValue((Object)((Integer)cir.getReturnValue() / 5));
        }
    }

    @Redirect(method={"createArrow"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ArrowItem;createArrow(Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/LivingEntity;)Lnet/minecraft/entity/projectile/PersistentProjectileEntity;"))
    private static class_1665 addProjectileEffects(class_1744 instance, class_1937 world, class_1799 arrowStack, class_1309 shooter) {
        class_1799 stack = shooter.method_6047();
        class_2487 arrowNbt = arrowStack.method_7969();
        if (arrowNbt == null) {
            arrowNbt = new class_2487();
        }
        if (stack.method_7969() != null && stack.method_7969().method_10545("Siphon")) {
            arrowNbt.method_10582("Siphon", stack.method_7969().method_10558("Siphon"));
        }
        arrowStack.method_7980(arrowNbt);
        class_1665 persistentProjectileEntity = null;
        if (stack.method_7948().method_10545("reloaded")) {
            switch (stack.method_7948().method_10558("reloaded")) {
                case "frostbite": {
                    persistentProjectileEntity = FrostbiteRound.createProjectile(world, stack, shooter);
                    break;
                }
                case "crushing": {
                    persistentProjectileEntity = CrushingRound.createProjectile(world, stack, shooter);
                    break;
                }
                case "puncturing": {
                    persistentProjectileEntity = PuncturingRound.createProjectile(world, stack, shooter);
                    break;
                }
                case "suppressing": {
                    persistentProjectileEntity = SuppressingRound.createProjectile(world, stack, shooter);
                }
            }
            stack.method_7948().method_10551("reloaded");
        } else {
            persistentProjectileEntity = instance.method_7702(world, arrowStack, shooter);
        }
        assert (persistentProjectileEntity != null);
        if (stack.method_7969() != null && stack.method_7969().method_10545("Siphon")) {
            Siphon.Type type = Siphon.Type.getSiphon(stack.method_7969().method_10558("Siphon"));
            if (type == Siphon.Type.DETERMINATION || type == Siphon.Type.SPITE) {
                persistentProjectileEntity.method_5780("Determination Siphon");
            }
            if (type == Siphon.Type.PATIENCE || type == Siphon.Type.SPITE) {
                persistentProjectileEntity.method_5780("Patience Siphon");
            }
            if (type == Siphon.Type.KINDNESS || type == Siphon.Type.SPITE) {
                persistentProjectileEntity.method_5780("Kindness Siphon");
            }
            if (type == Siphon.Type.JUSTICE || type == Siphon.Type.SPITE) {
                persistentProjectileEntity.field_7572 = class_1665.class_1666.field_7594;
            }
        }
        if (stack.method_7969() != null && stack.method_7969().method_10577("imbued")) {
            persistentProjectileEntity.method_5875(true);
        }
        return persistentProjectileEntity;
    }

    @Inject(method={"loadProjectile"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;split(I)Lnet/minecraft/item/ItemStack;", shift=At.Shift.BEFORE)}, cancellable=true)
    private static void onLoadProjectile(class_1309 shooter, class_1799 crossbow, class_1799 projectile, boolean simulated, boolean creative, CallbackInfoReturnable<Boolean> cir) {
        Siphon.Type type;
        if (crossbow.method_7985() && crossbow.method_7969().method_10545("Siphon") && ((type = Siphon.Type.getSiphon(crossbow.method_7969().method_10558("Siphon"))) == Siphon.Type.JUSTICE || type == Siphon.Type.SPITE)) {
            CrossbowItemMixin.putProjectile(crossbow, projectile);
            cir.setReturnValue((Object)true);
        }
        if (shooter instanceof class_1657) {
            class_1799 stack;
            class_1657 player = (class_1657)shooter;
            if (crossbow.method_7969() != null && crossbow.method_7969().method_10577("imbued") && (stack = Utils.getImbuer(crossbow, player)) != null) {
                if (((SiphonImbuer)stack.method_7909()).getCharge(stack) <= 0) {
                    cir.setReturnValue((Object)false);
                }
                ((SiphonImbuer)stack.method_7909()).decreaseCharge(stack, 3);
            }
        }
    }

    @Unique
    private static void putProjectile(class_1799 crossbow, class_1799 projectile) {
        class_2487 nbtCompound = crossbow.method_7948();
        class_2499 nbtList = nbtCompound.method_10573(field_30865, 9) ? nbtCompound.method_10554(field_30865, 10) : new class_2499();
        class_2487 nbtCompound2 = new class_2487();
        projectile.method_7953(nbtCompound2);
        nbtList.add((Object)nbtCompound2);
        nbtCompound.method_10566(field_30865, (class_2520)nbtList);
    }

    @Inject(method={"appendTooltip"}, at={@At(value="HEAD")})
    public void appendTooltip(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context, CallbackInfo ci) {
        if (stack.method_7969() != null) {
            Siphon.Type siphonType;
            if (stack.method_7969().method_10545("Siphon") && (siphonType = Siphon.Type.getSiphon(stack.method_7969().method_10558("Siphon"))) != null) {
                switch (siphonType) {
                    case BRAVERY: {
                        tooltip.add((class_2561)class_2561.method_43471((String)"siphon.soulforge.bravery").method_27692(class_124.field_1065));
                        break;
                    }
                    case JUSTICE: {
                        tooltip.add((class_2561)class_2561.method_43471((String)"siphon.soulforge.justice").method_27692(class_124.field_1054));
                        break;
                    }
                    case KINDNESS: {
                        tooltip.add((class_2561)class_2561.method_43471((String)"siphon.soulforge.kindness").method_27692(class_124.field_1060));
                        break;
                    }
                    case PATIENCE: {
                        tooltip.add((class_2561)class_2561.method_43471((String)"siphon.soulforge.patience").method_27692(class_124.field_1078));
                        break;
                    }
                    case INTEGRITY: {
                        tooltip.add((class_2561)class_2561.method_43471((String)"siphon.soulforge.integrity").method_27692(class_124.field_1058));
                        break;
                    }
                    case PERSEVERANCE: {
                        tooltip.add((class_2561)class_2561.method_43471((String)"siphon.soulforge.perseverance").method_27692(class_124.field_1076));
                        break;
                    }
                    case DETERMINATION: {
                        tooltip.add((class_2561)class_2561.method_43471((String)"siphon.soulforge.determination").method_27692(class_124.field_1061));
                        break;
                    }
                    case SPITE: {
                        tooltip.add((class_2561)class_2561.method_43470((String)"Siphon: Phoenix").method_27692(class_124.field_1079));
                    }
                }
            }
            if (stack.method_7969().method_10545("imbued")) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.soulforge.siphon_imbuer.imbued"));
            }
        }
    }
}

