/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.accessors.OwnableMinion;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.ValueComponent;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.entity.DeterminationPlatformEntity;
import com.pulsar.soulforge.entity.IntegrityPlatformEntity;
import com.pulsar.soulforge.event.LivingDamageEvent;
import com.pulsar.soulforge.event.LivingDeathEvent;
import com.pulsar.soulforge.event.LivingEntityTick;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.item.devices.devices.RevivalIdol;
import com.pulsar.soulforge.mixin.LivingEntityAccessor;
import com.pulsar.soulforge.siphon.Siphon;
import com.pulsar.soulforge.tag.SoulForgeTags;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.Constants;
import com.pulsar.soulforge.util.TeamUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5131;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    protected boolean field_6282;
    @Shadow
    public float field_6212;
    @Shadow
    public float field_6250;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1799 method_6047();

    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    @Shadow
    public abstract void method_6033(float var1);

    @Shadow
    public abstract boolean method_6012();

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @Shadow
    protected abstract boolean method_18406();

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_1291 var1);

    @Shadow
    @Nullable
    public abstract class_1324 method_5996(class_1320 var1);

    @Shadow
    public abstract float method_43078();

    @Shadow
    public abstract double method_26825(class_1320 var1);

    @Shadow
    public abstract class_5131 method_6127();

    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    @Shadow
    public abstract boolean method_29504();

    @Shadow
    public abstract boolean method_6061(class_1282 var1);

    @Shadow
    public abstract boolean method_6016(class_1291 var1);

    @Shadow
    public abstract void method_26082(class_1293 var1, @Nullable class_1297 var2);

    @ModifyReturnValue(method={"isBlocking"}, at={@At(value="RETURN")})
    public boolean parryBlocking(boolean original) {
        class_1309 living = (class_1309)this;
        if (living.method_6115() && living.method_6030().method_31573(SoulForgeTags.PARRY_ITEMS)) {
            return true;
        }
        return original;
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void soulforge$onDamage(class_1282 source, float damage, CallbackInfoReturnable<Boolean> cir) {
        boolean actuallyDamaged;
        boolean bl = actuallyDamaged = !(this.method_5679(source) || this.method_37908().field_9236 || this.method_29504() || source.method_48789(class_8103.field_42246) && this.method_6059(class_1294.field_5918) || damage > 0.0f && this.method_6061(source));
        if (!LivingDamageEvent.onTakeDamage((class_1309)this, source, damage, actuallyDamaged)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void soulforge$onDeath(class_1282 damageSource, CallbackInfo ci) {
        LivingDeathEvent.onDeath((class_1309)this, damageSource);
    }

    @Inject(method={"onKilledBy"}, at={@At(value="HEAD")})
    private void soulforge$onKilledBy(class_1309 adversary, CallbackInfo ci) {
        LivingDeathEvent.onKilledBy((class_1309)this, adversary);
    }

    @ModifyReturnValue(method={"getJumpVelocity"}, at={@At(value="RETURN")})
    private float addJumpVelocityIncrease(float original) {
        float multiplier = 1.0f;
        multiplier *= (float)this.method_26825(SoulForgeAttributes.JUMP_MULTIPLIER);
        if (this.method_24828()) {
            class_238 box = this.method_5829();
            for (class_1297 other : this.method_5770().method_8335((class_1297)((class_1309)this), box.method_1014(1.0E-4))) {
                class_1297 platform;
                if (!this.method_30949(other)) continue;
                if (other instanceof DeterminationPlatformEntity && (platform = (DeterminationPlatformEntity)other).getStack() == 1) {
                    multiplier *= 2.5f;
                }
                if (other instanceof DeterminationPlatformEntity && (platform = (DeterminationPlatformEntity)other).getStack() == 2) {
                    multiplier *= 4.0f;
                }
                if (other instanceof IntegrityPlatformEntity && (platform = (IntegrityPlatformEntity)other).getStack() == 1) {
                    multiplier *= 2.5f;
                }
                if (!(other instanceof IntegrityPlatformEntity) || (platform = (IntegrityPlatformEntity)other).getStack() != 2) break;
                multiplier *= 4.0f;
                break;
            }
        }
        return original * multiplier;
    }

    @ModifyVariable(method={"travel"}, at=@At(value="STORE"), ordinal=0)
    private float modifySlipperiness(float slipperiness) {
        float slipMultiplier = (float)this.method_26825(SoulForgeAttributes.SLIP_MODIFIER);
        float newSlipperiness = slipperiness;
        if (slipMultiplier > 0.0f) {
            newSlipperiness = 1.0f / ((-1.0f - slipMultiplier) / (1.0f - slipperiness)) + 1.0f;
        } else if (slipMultiplier < 0.0f) {
            newSlipperiness = 1.0f / (slipMultiplier / slipperiness);
        }
        return newSlipperiness;
    }

    @ModifyReturnValue(method={"canWalkOnFluid"}, at={@At(value="RETURN")})
    private boolean soulforge$canWalkOnWater(boolean original, @Local class_3610 fluid) {
        if ((class_1309)this instanceof class_1657 && !fluid.method_39360(class_3612.field_15906) && this.method_6127().method_27306(class_5134.field_23719)) {
            try {
                if (this.method_26825(class_5134.field_23719) > 0.3) {
                    if (fluid.method_15767(class_3486.field_15518)) {
                        return this.method_5753();
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return original;
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setVelocity(DDD)V", shift=At.Shift.AFTER)})
    protected void soulforge$modifyImmobility(CallbackInfo ci) {
        ValueComponent values;
        if (!this.method_6034() && ((values = SoulForge.getValues((class_1309)this)).getBool("Immobilized") || values.getTimer("Immobilized") > 0 || this.method_6059(SoulForgeEffects.IMMOBILIZED))) {
            this.field_6282 = false;
            this.field_6212 = 0.0f;
            this.field_6250 = 0.0f;
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tickNewAi()V", shift=At.Shift.AFTER)})
    protected void soulforge$resetImmobilityMovement(CallbackInfo ci) {
        ValueComponent values = SoulForge.getValues((class_1309)this);
        if (values.getBool("Immobilized") || values.getTimer("Immobilized") > 0 || this.method_6059(SoulForgeEffects.IMMOBILIZED)) {
            this.field_6282 = false;
            this.field_6212 = 0.0f;
            this.field_6250 = 0.0f;
        }
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(doubleValue=0.08)})
    private double modifyEntityGravity(double baseGravity) {
        class_1309 living = (class_1309)this;
        ValueComponent values = SoulForge.getValues(living);
        if (values != null && (values.getBool("Immobilized") || values.getTimer("Immobilized") > 0 || this.method_6059(SoulForgeEffects.IMMOBILIZED))) {
            return 0.0;
        }
        return baseGravity * this.method_26825(SoulForgeAttributes.GRAVITY_MODIFIER);
    }

    @Inject(method={"disablesShield"}, at={@At(value="RETURN")}, cancellable=true)
    protected void addShieldBreakers(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)((Boolean)cir.getReturnValue() != false || this.method_6047().method_31573(SoulForgeTags.BREAKS_SHIELD) ? 1 : 0));
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void invokeEvent(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_6059(SoulForgeEffects.IMMOBILIZED)) {
            int newAmpl = this.method_6112(SoulForgeEffects.IMMOBILIZED).method_5578() - (int)amount;
            if (newAmpl < 0) {
                this.method_6016(SoulForgeEffects.IMMOBILIZED);
            } else {
                this.method_26082(new class_1293(SoulForgeEffects.IMMOBILIZED, -1, newAmpl, false, false, false), null);
            }
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfo) {
        class_1309 entity = (class_1309)this;
        if (!(entity.method_5679(source) && entity.method_37908().field_9236 && entity.method_29504() && source.method_48789(class_8103.field_42246) && entity.method_6059(class_1294.field_5918) || !(amount > 0.0f) || !((LivingEntityAccessor)entity).invokeBlockedByShield(source))) {
            class_1297 sourceEntity;
            ((LivingEntityAccessor)entity).invokeDamageShield(amount);
            if (!source.method_48789(class_8103.field_42247) && (sourceEntity = source.method_5526()) instanceof class_1309) {
                ((LivingEntityAccessor)entity).invokeTakeShieldHit((class_1309)sourceEntity);
            }
        }
    }

    @Redirect(method={"jump"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setVelocity(Lnet/minecraft/util/math/Vec3d;)V"))
    protected void jump(class_1309 living, class_243 vel) {
        class_1657 player;
        SoulComponent playerSoul;
        if (living instanceof class_1657 && (playerSoul = SoulForge.getPlayerSoul(player = (class_1657)living)).hasCast("Fearless Instincts")) {
            class_243 vec3d = this.method_18798();
            float angle = (float)(Math.atan2(-vec3d.field_1350, -vec3d.field_1352) + 1.5707963267948966);
            this.method_18799(this.method_18798().method_1031((double)(-class_3532.method_15374((float)angle) * 0.2f), 0.0, (double)(class_3532.method_15362((float)angle) * 0.2f)));
            return;
        }
        this.method_18799(vel);
    }

    @ModifyReturnValue(method={"tryUseTotem"}, at={@At(value="RETURN")})
    private boolean tryUseTotem(boolean original, @Local class_1282 source) {
        if (original) {
            return true;
        }
        if (!source.method_48789(class_8103.field_42242)) {
            RevivalIdol idol;
            class_1799 mainHand = this.method_5998(class_1268.field_5808);
            class_1799 offHand = this.method_5998(class_1268.field_5810);
            class_1799 stack = null;
            if (mainHand.method_31574(SoulForgeItems.REVIVAL_IDOL)) {
                idol = (RevivalIdol)mainHand.method_7909();
                if (idol.getCharge(mainHand) >= 300) {
                    idol.decreaseCharge(mainHand, 300);
                    stack = mainHand;
                }
            } else if (offHand.method_31574(SoulForgeItems.REVIVAL_IDOL) && (idol = (RevivalIdol)offHand.method_7909()).getCharge(offHand) >= 300) {
                idol.decreaseCharge(offHand, 300);
                stack = offHand;
            }
            class_1309 living = (class_1309)this;
            if (stack != null) {
                if (living instanceof class_3222) {
                    class_3222 player = (class_3222)living;
                    player.method_7259(class_3468.field_15372.method_14956((Object)class_1802.field_8288));
                    class_174.field_1204.method_9165(player, stack);
                    this.method_32876(class_5712.field_28146);
                }
                this.method_6033(1.0f);
                this.method_6012();
                this.method_6092(new class_1293(class_1294.field_5924, 900, 1));
                this.method_6092(new class_1293(class_1294.field_5898, 100, 1));
                this.method_6092(new class_1293(class_1294.field_5918, 800, 0));
                this.method_37908().method_8421((class_1297)this, (byte)35);
                return true;
            }
        }
        return false;
    }

    @ModifyVariable(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1293 modifyStatusEffect(class_1293 effect) {
        if (this.method_6059(SoulForgeEffects.SNOWED_VISION)) {
            SoulComponent snowerSoul;
            class_1657 snower;
            ValueComponent values = SoulForge.getValues((class_1309)this);
            if (values != null && values.hasUUID("SnowedBy") && (snower = this.method_37908().method_18470(values.getUUID("SnowedBy"))) != null && (snowerSoul = SoulForge.getPlayerSoul(snower)).hasTrait(Traits.patience) && snowerSoul.hasTrait(Traits.perseverance) && Constants.effectInversion.containsKey(effect.method_5579())) {
                snower.method_6092(new class_1293(Constants.effectInversion.get(effect.method_5579()), (int)((float)effect.method_5584() * 0.6f), (int)((float)effect.method_5578() * 0.6f)));
            }
            if (!effect.method_5579().method_5573()) {
                return new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578() + 1);
            }
        }
        return effect;
    }

    @Inject(method={"createLivingAttributes"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<class_5132.class_5133> info) {
        ((class_5132.class_5133)info.getReturnValue()).method_26867(SoulForgeAttributes.DAMAGE_REDUCTION).method_26867(SoulForgeAttributes.KNOCKBACK_MULTIPLIER).method_26867(SoulForgeAttributes.SLIP_MODIFIER).method_26867(SoulForgeAttributes.EFFECT_DURATION_MULTIPLIER).method_26867(SoulForgeAttributes.ANTIHEAL).method_26867(SoulForgeAttributes.AIR_SPEED_BECAUSE_MOJANG_SUCKS).method_26867(SoulForgeAttributes.JUMP_MULTIPLIER).method_26867(SoulForgeAttributes.FALL_DAMAGE_MULTIPLIER).method_26867(SoulForgeAttributes.GRAVITY_MODIFIER).method_26867(SoulForgeAttributes.STEP_HEIGHT).method_26867(SoulForgeAttributes.SHIELD_BREAK);
    }

    @ModifyReturnValue(method={"getOffGroundSpeed"}, at={@At(value="RETURN")})
    protected float modifyOffGroundSpeed(float original) {
        class_1309 living = (class_1309)this;
        if (living.method_6127().method_27306(SoulForgeAttributes.AIR_SPEED_BECAUSE_MOJANG_SUCKS)) {
            return (float)((double)original * living.method_26825(SoulForgeAttributes.AIR_SPEED_BECAUSE_MOJANG_SUCKS));
        }
        return original;
    }

    @Redirect(method={"tickRiptide"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;union(Lnet/minecraft/util/math/Box;)Lnet/minecraft/util/math/Box;"))
    private class_238 modifyRiptideCollisionBox(class_238 a, class_238 b) {
        Siphon.Type siphonType;
        class_2487 nbt;
        class_238 box = a.method_991(b);
        if (this.method_6047().method_31574(class_1802.field_8547) && (nbt = this.method_6047().method_7948()).method_10545("Siphon") && (siphonType = Siphon.Type.getSiphon(nbt.method_10558("Siphon"))) == Siphon.Type.BRAVERY) {
            return box.method_1014(2.0);
        }
        return box;
    }

    @ModifyArg(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageShield(F)V"))
    private float modifyShieldDamage(float original, @Local class_1282 source) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            return original * (float)living.method_26825(SoulForgeAttributes.SHIELD_BREAK);
        }
        return original;
    }

    @ModifyReturnValue(method={"canTarget(Lnet/minecraft/entity/LivingEntity;)Z"}, at={@At(value="RETURN")})
    private boolean modifyCanTarget(boolean original, @Local class_1309 target) {
        class_1308 mobEntity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1308 && ((OwnableMinion)(mobEntity = (class_1308)class_13092)).getOwnerUUID() != null && ((OwnableMinion)mobEntity).getOwnerUUID().compareTo(target.method_5667()) == 0) {
            return false;
        }
        return original;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void soulforge$onEntityTick(CallbackInfo ci) {
        LivingEntityTick.tick((class_1309)this);
    }

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")}, cancellable=true)
    private void soulforge$canWakeUp(CallbackInfo ci) {
        if (this.method_6059(SoulForgeEffects.EEPY) && this.method_18406()) {
            ci.cancel();
        }
    }

    @ModifyConstant(method={"modifyAppliedDamage"}, constant={@Constant(intValue=5)})
    private int soulforge$modifyResistanceMultiplier(int constant) {
        return 10;
    }

    @ModifyConstant(method={"modifyAppliedDamage"}, constant={@Constant(intValue=25)})
    private int soulforge$modifyResistanceSubtraction(int constant) {
        return 50;
    }

    @ModifyConstant(method={"modifyAppliedDamage"}, constant={@Constant(floatValue=25.0f)})
    private float soulforge$modifyResistanceDivision(float constant) {
        return 50.0f;
    }

    @ModifyVariable(method={"modifyAppliedDamage"}, at=@At(value="STORE"), ordinal=1)
    private int soulforge$modifyResistanceDamage(int value) {
        if (this.method_6059(SoulForgeEffects.VULNERABILITY)) {
            return value + 5 * (this.method_6112(SoulForgeEffects.VULNERABILITY).method_5578() + 1);
        }
        return value;
    }

    @ModifyArg(method={"modifyAppliedDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/DamageUtil;getInflictedDamage(FF)F"), index=1)
    private float soulforge$modifyProtectionLevel(float value) {
        if (this.method_6059(SoulForgeEffects.VULNERABILITY)) {
            for (int i = 0; i < this.method_6112(SoulForgeEffects.VULNERABILITY).method_5578() + 1; ++i) {
                value *= 0.9f;
            }
        }
        return value;
    }

    @ModifyReturnValue(method={"modifyAppliedDamage"}, at={@At(value="RETURN")})
    private float soulforge$modifyAppliedDamage(float value, @Local class_1282 source) {
        class_1324 attribute = this.method_5996(SoulForgeAttributes.DAMAGE_REDUCTION);
        if (attribute != null) {
            value *= (float)attribute.method_6194();
        }
        if (!source.method_48789(class_8103.field_42243) && !this.method_6059(class_1294.field_5907) && this.method_6059(SoulForgeEffects.VULNERABILITY)) {
            return value * ((float)(this.method_6112(SoulForgeEffects.VULNERABILITY).method_5578() + 1) * 0.1f + 1.0f);
        }
        return value;
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setHealth(F)V")})
    private void soulforge$onAppliedDamage(class_1282 source, float amount, CallbackInfo ci) {
        LivingDamageEvent.onApplyDamage((class_1309)this, source, amount);
    }

    @ModifyVariable(method={"takeKnockback"}, at=@At(value="HEAD"), ordinal=0)
    private double soulforge$modifyKnockbackStrength(double original) {
        return original * this.method_26825(SoulForgeAttributes.KNOCKBACK_MULTIPLIER);
    }

    @ModifyReturnValue(method={"getStepHeight"}, at={@At(value="RETURN")})
    private float soulforge$modifyStepHeight(float original) {
        return original + (float)this.method_26825(SoulForgeAttributes.STEP_HEIGHT);
    }

    @ModifyReturnValue(method={"handleFallDamage"}, at={@At(value="RETURN")})
    private boolean soulforge$modifyFallDamageMultiplier(boolean original) {
        return original && this.method_26825(SoulForgeAttributes.FALL_DAMAGE_MULTIPLIER) > 0.0;
    }

    @ModifyArg(method={"computeFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;ceil(F)I"))
    private float soulforge$modifyFallDamageMultiplier(float original) {
        return original * (float)this.method_26825(SoulForgeAttributes.FALL_DAMAGE_MULTIPLIER);
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=1)
    private float soulforge$doKindnessElytraBlock(float amount) {
        SoulComponent playerSoul;
        Siphon.Type siphonType;
        class_1799 elytra;
        class_3222 player;
        class_1309 living = (class_1309)this;
        if (living instanceof class_3222 && (player = (class_3222)living).method_6118(class_1304.field_6174).method_31574(class_1802.field_8833) && (elytra = player.method_6118(class_1304.field_6174)).method_7969() != null && elytra.method_7969().method_10545("Siphon") && ((siphonType = Siphon.Type.getSiphon(elytra.method_7969().method_10558("Siphon"))) == Siphon.Type.KINDNESS || siphonType == Siphon.Type.SPITE) && (playerSoul = SoulForge.getPlayerSoul((class_1657)player)).tryConsumeMagic(40.0f)) {
            float push = (float)Math.sqrt(amount) / 2.0f;
            amount *= 0.05f;
            for (class_1309 nearby : player.method_37908().method_8390(class_1309.class, class_238.method_30048((class_243)player.method_19538(), (double)10.0, (double)10.0, (double)10.0), target -> TeamUtils.canDamageEntity(player.method_5682(), (class_1657)player, target))) {
                if (!(nearby.method_5739((class_1297)player) < 10.0f)) continue;
                class_243 offset = player.method_19538().method_1020(nearby.method_19538()).method_1029();
                nearby.method_45319(offset.method_1021((double)push));
                nearby.field_6037 = true;
            }
        }
        return amount;
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getRotationVector()Lnet/minecraft/util/math/Vec3d;")})
    private class_243 soulforge$doPatienceElytraBoost(class_243 original) {
        Siphon.Type siphonType;
        class_1799 elytra;
        class_3222 player;
        class_1309 living = (class_1309)this;
        if (living instanceof class_3222 && (player = (class_3222)living).method_6118(class_1304.field_6174).method_31574(class_1802.field_8833) && (elytra = player.method_6118(class_1304.field_6174)).method_7969() != null && elytra.method_7969().method_10545("Siphon") && ((siphonType = Siphon.Type.getSiphon(elytra.method_7969().method_10558("Siphon"))) == Siphon.Type.PATIENCE || siphonType == Siphon.Type.SPITE) && player.method_5778()) {
            return original.method_1021((double)1.2f);
        }
        return original;
    }
}

