/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.mixin;

import com.pulsar.soulforge.accessors.SiphonableEntity;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.siphon.Siphon;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3966;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1685.class})
public abstract class TridentEntityMixin
extends class_1676
implements SiphonableEntity {
    @Shadow
    public class_1799 field_7650;
    @Unique
    private static final class_2940<String> SIPHON = class_2945.method_12791(class_1685.class, (class_2941)class_2943.field_13326);

    public TridentEntityMixin(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="TAIL")})
    public void addSiphonData(class_1937 world, class_1309 owner, class_1799 stack, CallbackInfo ci) {
        this.field_6011.method_12778(SIPHON, (Object)(stack.method_7948().method_10545("Siphon") ? stack.method_7948().method_10558("Siphon") : ""));
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    protected void addToTracker(CallbackInfo ci) {
        this.field_6011.method_12784(SIPHON, (Object)"");
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readSiphonData(class_2487 nbt, CallbackInfo ci) {
        this.field_6011.method_12778(SIPHON, (Object)(this.field_7650.method_7948().method_10545("Siphon") ? this.field_7650.method_7948().method_10558("Siphon") : ""));
    }

    @Override
    public String getSiphonString() {
        return (String)this.field_6011.method_12789(SIPHON);
    }

    @Inject(method={"onEntityHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/projectile/TridentEntity;onHit(Lnet/minecraft/entity/LivingEntity;)V")})
    private void addHitEffects(class_3966 entityHitResult, CallbackInfo ci) {
        if (!Objects.equals(this.getSiphonString(), "")) {
            class_1309 living;
            class_1297 class_12972;
            Siphon.Type siphonType = Siphon.Type.getSiphon(this.getSiphonString());
            if ((siphonType == Siphon.Type.KINDNESS || siphonType == Siphon.Type.SPITE) && (class_12972 = entityHitResult.method_17782()) instanceof class_1309) {
                living = (class_1309)class_12972;
                living.method_6092(new class_1293(SoulForgeEffects.VULNERABILITY, 400, 0));
            }
            if ((siphonType == Siphon.Type.PATIENCE || siphonType == Siphon.Type.SPITE) && (class_12972 = entityHitResult.method_17782()) instanceof class_1309) {
                living = (class_1309)class_12972;
                int useLevel = this.field_7650.method_7948().method_10545("useLevel") ? this.field_7650.method_7948().method_10550("useLevel") : 1;
                living.method_6092(new class_1293(class_1294.field_5909, 360, useLevel - 1));
                if (useLevel >= 2) {
                    living.method_6092(new class_1293(class_1294.field_5911, 360, useLevel - 2));
                }
            }
        }
    }

    @Redirect(method={"onEntityHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    private boolean modifyDamage(class_1297 instance, class_1282 source, float amount) {
        Siphon.Type siphonType;
        if (!(Objects.equals(this.getSiphonString(), "") || (siphonType = Siphon.Type.getSiphon(this.getSiphonString())) != Siphon.Type.PERSEVERANCE && siphonType != Siphon.Type.SPITE)) {
            return instance.method_5643(source, amount * 1.2f);
        }
        return instance.method_5643(source, amount);
    }

    @Inject(method={"tryPickup"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTryPickup(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        class_1685 trident = (class_1685)this;
        switch (trident.field_7572) {
            case field_7594: {
                cir.setReturnValue((Object)player.method_31549().field_7477);
                break;
            }
            case field_7592: {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

