/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.networking;

import com.google.common.collect.Sets;
import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.components.SoulComponent;
import java.util.HashSet;
import java.util.LinkedList;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;

public class VeinminePacket {
    private static final class_2350[] CARDINAL_DIRECTIONS = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035};

    public static void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        class_2338 pos = buf.method_10811();
        server.execute(() -> {
            SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)player);
            playerSoul.resetLastCastTime();
            VeinminePacket.veinMine(player, pos, player.method_37908().method_8320(pos));
        });
    }

    private static void veinMine(class_3222 playerEntity, class_2338 pos, class_2680 sourceState) {
        class_1799 stack = playerEntity.method_6047();
        class_3218 world = playerEntity.method_51469();
        class_2248 source = sourceState.method_26204();
        SoulComponent playerSoul = SoulForge.getPlayerSoul((class_1657)playerEntity);
        int maxDistance = 200;
        if (playerSoul.getMagic() < 5.0f) {
            return;
        }
        int blocks = 1;
        HashSet visited = Sets.newHashSet((Object[])new class_2338[]{pos});
        LinkedList<class_3545<class_2338, Integer>> candidates = new LinkedList<class_3545<class_2338, Integer>>(VeinminePacket.addValidNeighbors(pos, 1));
        LinkedList<class_2338> toMine = new LinkedList<class_2338>();
        while (!candidates.isEmpty() && blocks < 25) {
            class_3545<class_2338, Integer> candidate = candidates.poll();
            class_2338 blockPos = (class_2338)candidate.method_15442();
            int blockDistance = (Integer)candidate.method_15441();
            if (world.method_8320(blockPos).method_27852(source)) {
                toMine.add(blockPos);
                if (visited.add(blockPos)) {
                    if (blockDistance < maxDistance) {
                        for (class_3545 class_35452 : VeinminePacket.addValidNeighbors(blockPos, blockDistance + 1)) {
                            if (!world.method_8320((class_2338)class_35452.method_15442()).method_27852(source)) continue;
                            candidates.add((class_3545<class_2338, Integer>)class_35452);
                        }
                    }
                    ++blocks;
                }
            }
            if (!VeinminePacket.stopVeining(stack)) continue;
            break;
        }
        class_1277 drops = new class_1277(100);
        for (class_2338 mine : toMine) {
            if (!playerSoul.tryConsumeMagic(5.0f)) break;
            class_2680 blockState = world.method_8320(mine);
            class_2248 class_22482 = blockState.method_26204();
            if (blockState.method_26215() || !blockState.method_27852(source)) continue;
            class_2586 blockEntity = world.method_8321(mine);
            if (blockEntity instanceof class_1263) {
                class_1263 inventory = (class_1263)blockEntity;
                class_1264.method_5451((class_1937)world, (class_2338)mine, (class_1263)inventory);
            }
            class_22482.method_9576((class_1937)world, mine, blockState, (class_1657)playerEntity);
            world.method_8650(mine, false);
            class_22482.method_9585((class_1936)world, mine, blockState);
            if (!playerEntity.method_7305(blockState) || !playerEntity.method_7294()) continue;
            class_2248.method_9609((class_2680)blockState, (class_3218)world, (class_2338)pos, (class_2586)blockEntity, (class_1297)playerEntity, (class_1799)stack).forEach(toDrop -> drops.method_5491(toDrop));
            blockState.method_26180(world, pos, stack, true);
        }
        for (class_1799 drop : drops.field_5828) {
            class_1542 itemEntity = new class_1542((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), drop);
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
    }

    private static boolean stopVeining(class_1799 stack) {
        return stack.method_7963() && stack.method_7919() >= stack.method_7936() - 2;
    }

    private static LinkedList<class_3545<class_2338, Integer>> addValidNeighbors(class_2338 source, int distance) {
        LinkedList<class_3545<class_2338, Integer>> candidates = new LinkedList<class_3545<class_2338, Integer>>();
        for (class_2350 direction : CARDINAL_DIRECTIONS) {
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)source.method_10093(direction), (Object)distance));
        }
        return candidates;
    }
}

