/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.trait;

import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.Abilities;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.AbilityType;
import com.pulsar.soulforge.ability.determination.DeterminationSword;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.traits.Anxiety;
import com.pulsar.soulforge.trait.traits.Bravery;
import com.pulsar.soulforge.trait.traits.Despair;
import com.pulsar.soulforge.trait.traits.Determination;
import com.pulsar.soulforge.trait.traits.Fear;
import com.pulsar.soulforge.trait.traits.Ineptitude;
import com.pulsar.soulforge.trait.traits.Integrity;
import com.pulsar.soulforge.trait.traits.Justice;
import com.pulsar.soulforge.trait.traits.Kindness;
import com.pulsar.soulforge.trait.traits.Misery;
import com.pulsar.soulforge.trait.traits.Paranoia;
import com.pulsar.soulforge.trait.traits.Patience;
import com.pulsar.soulforge.trait.traits.Perseverance;
import com.pulsar.soulforge.trait.traits.Spite;
import com.pulsar.soulforge.util.Constants;
import com.pulsar.soulforge.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;

public class Traits {
    public static TraitBase bravery = new Bravery();
    public static TraitBase justice = new Justice();
    public static TraitBase kindness = new Kindness();
    public static TraitBase patience = new Patience();
    public static TraitBase integrity = new Integrity();
    public static TraitBase perseverance = new Perseverance();
    public static TraitBase determination = new Determination();
    public static TraitBase fear = new Fear();
    public static TraitBase ineptitude = new Ineptitude();
    public static TraitBase misery = new Misery();
    public static TraitBase anxiety = new Anxiety();
    public static TraitBase paranoia = new Paranoia();
    public static TraitBase despair = new Despair();
    public static TraitBase spite = new Spite();
    private static HashMap<String, TraitBase> customTraits = new HashMap();

    public static TraitBase randomNormal() {
        Random rnd = new Random();
        return switch (rnd.nextInt(6)) {
            case 0 -> bravery;
            case 1 -> integrity;
            case 2 -> justice;
            case 3 -> kindness;
            case 4 -> patience;
            case 5 -> perseverance;
            default -> bravery;
        };
    }

    public static void addCustomTrait(TraitBase trait) {
        customTraits.put(trait.getName(), trait);
    }

    public static List<TraitBase> all() {
        ArrayList<TraitBase> traits = new ArrayList<TraitBase>(Arrays.asList(bravery, justice, kindness, patience, integrity, perseverance, determination));
        traits.addAll(customTraits.values());
        return traits;
    }

    public static List<TraitBase> trueAll() {
        ArrayList<TraitBase> traits = new ArrayList<TraitBase>(Arrays.asList(bravery, justice, kindness, patience, integrity, perseverance, determination, fear, ineptitude, misery, anxiety, paranoia, despair, spite));
        traits.addAll(customTraits.values());
        return traits;
    }

    @Nullable
    public static TraitBase get(String traitName) {
        for (TraitBase trait : Traits.trueAll()) {
            if (!Objects.equals(trait.getName(), traitName)) continue;
            return trait;
        }
        return null;
    }

    public static List<AbilityBase> getAbilities(class_1657 player) {
        if (player == null) {
            return List.of();
        }
        SoulComponent playerSoul = SoulForge.getPlayerSoul(player);
        return Traits.getAbilities(player, playerSoul);
    }

    public static List<AbilityBase> getAbilities(class_1657 player, SoulComponent playerSoul) {
        return Traits.getAbilities(playerSoul.getTraits(), playerSoul.getLV(), playerSoul.isPure(), Utils.hasHate((class_1309)player));
    }

    public static List<AbilityBase> getAbilities(List<TraitBase> traits, int lv, boolean pure, boolean hasHate) {
        AbilityBase pureAbility;
        ArrayList<AbilityBase> abilities = new ArrayList<AbilityBase>();
        for (TraitBase trait : traits) {
            for (AbilityBase ability : trait.getAbilities()) {
                if (!Constants.isAllowedForDualTrait(ability, traits, lv) || ability.getLV() > lv || ability instanceof DeterminationSword && lv >= 20) continue;
                abilities.add(ability.getInstance());
            }
        }
        for (AbilityBase ability : Constants.getDualTraitAbilities(traits)) {
            if (ability.getLV() > lv) continue;
            abilities.add(ability.getInstance());
        }
        if (pure && !traits.contains(spite)) {
            for (TraitBase trait : traits) {
                if (trait == perseverance || trait == despair || trait == determination || (pureAbility = Constants.pureAbilities.get(trait)).getLV() > lv) continue;
                abilities.add(pureAbility.getInstance());
            }
        }
        if (traits.contains(spite)) {
            for (TraitBase trait : Traits.all()) {
                if (trait == perseverance || trait == despair || trait == determination || trait == spite || (pureAbility = Constants.pureAbilities.get(trait)).getLV() > lv) continue;
                abilities.add(pureAbility.getInstance());
            }
            abilities.addAll(Abilities.specialAbilities);
        }
        if (hasHate) {
            for (AbilityBase ability : Abilities.hateAbilities) {
                abilities.add(ability.getInstance());
            }
        }
        abilities.sort(Comparator.comparingInt(AbilityBase::getLV));
        return abilities;
    }

    public static List<AbilityBase> getModeAbilities(Mode mode, String traitName, SoulComponent soul) {
        ArrayList<String> abilityNames = new ArrayList<String>();
        if (mode == Mode.TRAIT) {
            for (TraitBase trait : Traits.trueAll()) {
                Object pureAbility;
                if (!Objects.equals(trait.getName(), traitName)) continue;
                for (AbilityBase ability : trait.getAbilities()) {
                    if (ability.getLV() > soul.getLV() && !soul.hasTrait(spite) || ability.getType() == AbilityType.PASSIVE || ability instanceof DeterminationSword && soul.getLV() == 20) continue;
                    abilityNames.add(ability.getName());
                }
                if (!soul.isPure() && !soul.hasTrait(spite) && !Objects.equals(traitName, "Determination") || trait == perseverance || trait == despair || trait == determination || ((AbilityBase)(pureAbility = Constants.pureAbilities.get(trait))).getLV() > soul.getLV()) continue;
                abilityNames.add(((AbilityBase)pureAbility).getName());
            }
        } else if (mode == Mode.DUALS) {
            for (AbilityBase ability : Constants.getDualTraitAbilities(soul.getTraits())) {
                if (ability.getLV() > soul.getLV()) continue;
                abilityNames.add(ability.getName());
            }
        } else if (mode == Mode.SPECIAL) {
            for (AbilityBase special : Abilities.specialAbilities) {
                abilityNames.add(special.getName());
            }
        } else {
            for (TraitBase trait : soul.getTraits()) {
                for (AbilityBase ability : trait.getAbilities()) {
                    if (ability.getLV() > soul.getLV() || ability.getType() != AbilityType.PASSIVE) continue;
                    abilityNames.add(ability.getName());
                }
            }
        }
        ArrayList<AbilityBase> abilities = new ArrayList<AbilityBase>();
        for (String abilityName : abilityNames) {
            try {
                AbilityBase ability;
                ability = soul.getAbility(abilityName);
                if (ability == null) continue;
                abilities.add(ability);
            }
            catch (Exception exception) {}
        }
        abilities.sort(Comparator.comparingInt(AbilityBase::getLV));
        return abilities;
    }

    public static enum Mode {
        TRAIT(""),
        DUALS("Duals"),
        HATE("HATE"),
        PASSIVES("Passives"),
        SPECIAL("Special");

        final String name;

        private Mode(String name) {
            this.name = name;
        }
    }
}

